/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.block.custom;

import net.mezimaru.mastersword.block.entity.SwordShrineBlockEntity;
import net.mezimaru.mastersword.item.ModItems;
import net.mezimaru.mastersword.item.custom.BlessedNetherStarItem;
import net.mezimaru.mastersword.item.custom.FairyBowItem;
import net.mezimaru.mastersword.item.custom.GoldenMasterSwordItem;
import net.mezimaru.mastersword.item.custom.HylianBottleHealingFairyItem;
import net.mezimaru.mastersword.sound.ModSounds;
import net.mezimaru.mastersword.util.ParticleHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwordShrineBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public SwordShrineBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public BlockEntity m_142194_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return new SwordShrineBlockEntity(pPos, pState);
    }

    public boolean m_7899_(BlockState pState) {
        return true;
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        super.m_6807_(pState, pLevel, pPos, pOldState, pMovedByPiston);
        pLevel.m_46672_(pPos, (Block)this);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
        pLevel.m_46672_(pPos, (Block)this);
    }

    public int m_6378_(BlockState pState, BlockGetter pLevel, BlockPos pPos, Direction pDirection) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof SwordShrineBlockEntity) {
            SwordShrineBlockEntity swordShrine = (SwordShrineBlockEntity)blockEntity;
            return swordShrine.getWeapon().m_41619_() ? 0 : 15;
        }
        return 0;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.makeShape(state);
    }

    public VoxelShape makeShape(BlockState state) {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.125, (double)1.0, (double)0.0625, (double)0.875));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.125, (double)0.1875, (double)0.9375, (double)0.1875, (double)0.8125));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.25, (double)0.25, (double)0.875, (double)0.3125, (double)0.75));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.09375, (double)0.1875, (double)0.21875, (double)0.90625, (double)0.25, (double)0.78125));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.03125, (double)0.0625, (double)0.15625, (double)0.96875, (double)0.125, (double)0.84375));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.15625, (double)0.3125, (double)0.28125, (double)0.84375, (double)0.375, (double)0.71875));
        return switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case Direction.SOUTH -> this.rotateShape(shape, Direction.SOUTH);
            case Direction.EAST -> this.rotateShape(shape, Direction.EAST);
            case Direction.WEST -> this.rotateShape(shape, Direction.WEST);
            default -> shape;
        };
    }

    private VoxelShape rotateShape(VoxelShape shape, Direction direction) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (direction.m_122416_() - Direction.NORTH.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)pContext.m_8125_());
    }

    public void m_6402_(Level level, BlockPos pos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SwordShrineBlockEntity) {
            blockEntity.m_6596_();
            level.m_151523_(blockEntity);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof SwordShrineBlockEntity) {
            double z;
            double y;
            double x;
            double offsetZ;
            double offsetY;
            double offsetX;
            int i;
            SwordShrineBlockEntity swordShrine = (SwordShrineBlockEntity)blockEntity;
            ItemStack heldItem = player.m_21120_(hand);
            if (swordShrine.getWeapon().m_41720_() instanceof BowItem && !(swordShrine.getWeapon().m_41720_() instanceof FairyBowItem) && heldItem.m_41720_() instanceof HylianBottleHealingFairyItem) {
                ItemStack oldBow = swordShrine.getWeapon();
                ItemStack fairyBow = new ItemStack((ItemLike)ModItems.FAIRY_BOW.get());
                fairyBow.m_41751_(oldBow.m_41783_());
                swordShrine.setWeapon(fairyBow);
                heldItem.m_41774_(1);
                if (!player.m_36356_(new ItemStack((ItemLike)Items.f_42590_, 1))) {
                    level.m_7967_((Entity)new ItemEntity(level, player.m_20185_(), player.m_20186_(), player.m_20189_(), new ItemStack((ItemLike)Items.f_42590_, 1)));
                }
                level.m_5594_(null, swordShrine.m_58899_(), (SoundEvent)ModSounds.FANFARE_ITEM.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                for (i = 0; i < 50; ++i) {
                    offsetX = (Math.random() - 0.5) * 1.0;
                    offsetY = 0.5;
                    offsetZ = (Math.random() - 0.5) * 1.0;
                    x = (double)swordShrine.m_58899_().m_123341_() + 0.5 + offsetX;
                    y = (double)swordShrine.m_58899_().m_123342_() + offsetY;
                    z = (double)swordShrine.m_58899_().m_123343_() + 0.5 + offsetZ;
                    ParticleHelper.spawnParticle(level, (ParticleOptions)ParticleTypes.f_123810_, x + offsetX, y + offsetY, z + offsetZ, 0.0, 0.0, 0.0);
                }
            }
            if (swordShrine.getWeapon().m_41720_() instanceof GoldenMasterSwordItem && heldItem.m_41720_() instanceof BlessedNetherStarItem) {
                ItemStack goldSword = swordShrine.getWeapon();
                ItemStack trueMasterSword = new ItemStack((ItemLike)ModItems.TRUEMASTERSWORD.get());
                trueMasterSword.m_41751_(goldSword.m_41783_());
                swordShrine.setWeapon(trueMasterSword);
                heldItem.m_41774_(1);
                level.m_5594_(null, swordShrine.m_58899_(), (SoundEvent)ModSounds.FANFARE_ITEM.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                for (i = 0; i < 50; ++i) {
                    offsetX = (Math.random() - 0.5) * 1.0;
                    offsetY = 0.5;
                    offsetZ = (Math.random() - 0.5) * 1.0;
                    x = (double)swordShrine.m_58899_().m_123341_() + 0.5 + offsetX;
                    y = (double)swordShrine.m_58899_().m_123342_() + offsetY;
                    z = (double)swordShrine.m_58899_().m_123343_() + 0.5 + offsetZ;
                    ParticleHelper.spawnParticle(level, (ParticleOptions)ParticleTypes.f_123810_, x + offsetX, y + offsetY, z + offsetZ, 0.0, 0.0, 0.0);
                }
            }
            if (swordShrine.getWeapon().m_41619_() && heldItem.m_41720_().equals(Items.f_42686_)) {
                swordShrine.setWeapon(heldItem.m_41777_());
                heldItem.m_41774_(1);
                if (level.m_46472_() == Level.f_46430_) {
                    return InteractionResult.SUCCESS;
                }
                Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)swordShrine.getWeapon());
                swordShrine.setWeapon(ItemStack.f_41583_);
            } else {
                if (swordShrine.getWeapon().m_41619_() && (heldItem.m_41720_() instanceof SwordItem || heldItem.m_41720_() instanceof BowItem)) {
                    swordShrine.setWeapon(heldItem.m_41777_());
                    heldItem.m_41774_(1);
                    level.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.PLACE_SWORD.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.MASTER_SWORD_SOUND_EFFECT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_46672_(pos, (Block)this);
                    return InteractionResult.SUCCESS;
                }
                if (heldItem.m_41619_() && !swordShrine.getWeapon().m_41619_()) {
                    player.m_21008_(hand, swordShrine.getWeapon().m_41777_());
                    swordShrine.setWeapon(ItemStack.f_41583_);
                    level.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.TAKE_SWORD.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_46672_(pos, (Block)this);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return level.m_5776_() ? null : (level0, pos0, state0, blockEntity) -> ((SwordShrineBlockEntity)blockEntity).tick();
    }
}

