/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.block.entity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.mezimaru.mastersword.block.entity.ModBlockEntities;
import net.mezimaru.mastersword.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class LinkHouseMusicBlockEntity
extends BlockEntity {
    private static final int SONG_DURATION = 15800;
    private static final float VOLUME = 0.5f;
    private static final float PITCH = 1.0f;
    public final AABB linkHouseBoundingBox;
    public final Set<UUID> playersWhoHeardSong = new HashSet<UUID>();
    public int linkHouseTickCounter = 0;
    public boolean isPlaying = false;

    public LinkHouseMusicBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.LINK_HOUSE_MUSIC_BLOCK_ENTITY.get(), pos, state);
        this.linkHouseBoundingBox = new AABB(pos).m_82400_(40.0);
    }

    public void tick() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (!this.f_58857_.m_46805_(this.f_58858_)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)this.f_58857_;
        List playersInRange = serverLevel.m_45976_(ServerPlayer.class, this.linkHouseBoundingBox);
        if (!this.isPlaying && !playersInRange.isEmpty()) {
            serverLevel.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.LINK_HOUSE.get(), SoundSource.RECORDS, 0.5f, 1.0f);
            this.linkHouseTickCounter = 0;
            this.isPlaying = true;
            this.playersWhoHeardSong.clear();
            for (ServerPlayer player : playersInRange) {
                this.playersWhoHeardSong.add(player.m_20148_());
            }
        }
        if (this.isPlaying) {
            ++this.linkHouseTickCounter;
            if (this.linkHouseTickCounter >= 15800) {
                this.isPlaying = false;
                this.linkHouseTickCounter = 0;
                this.playersWhoHeardSong.clear();
            } else {
                double x = (double)this.f_58858_.m_123341_() + 0.5;
                double y = (double)this.f_58858_.m_123342_() + 0.5;
                double z = (double)this.f_58858_.m_123343_() + 0.5;
                ArrayList<ServerPlayer> newPlayers = new ArrayList<ServerPlayer>();
                for (ServerPlayer player : playersInRange) {
                    if (this.playersWhoHeardSong.contains(player.m_20148_())) continue;
                    newPlayers.add(player);
                }
                for (ServerPlayer player : newPlayers) {
                    player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)((SoundEvent)ModSounds.LINK_HOUSE.get())), SoundSource.RECORDS, x, y, z, 0.5f, 1.0f, player.m_217043_().m_188505_()));
                    this.playersWhoHeardSong.add(player.m_20148_());
                }
            }
        }
    }
}

