/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.entity.custom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.mezimaru.mastersword.config.MasterSwordCommonConfigs;
import net.mezimaru.mastersword.item.ModItems;
import net.mezimaru.mastersword.sound.ModSounds;
import net.mezimaru.mastersword.villager.ModVillagers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.InteractGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.LookAtTradingPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GoronMerchantEntity
extends AbstractVillager
implements VillagerDataHolder,
GeoEntity,
NeutralMob {
    private static final RawAnimation ADJUST_BAG = RawAnimation.begin().thenPlay("misc.adjust_bag");
    private static final RawAnimation RUMMAGE = RawAnimation.begin().thenPlay("misc.rummage");
    private static final RawAnimation WAVE = RawAnimation.begin().thenPlay("misc.wave");
    private static final RawAnimation SCRATCH = RawAnimation.begin().thenPlay("misc.scratch");
    private static final RawAnimation RIGHT_PUNCH = RawAnimation.begin().thenPlay("attack.right_punch");
    private static final RawAnimation LEFT_PUNCH = RawAnimation.begin().thenPlay("attack.left_punch");
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private static final EntityDataAccessor<VillagerData> DATA_VILLAGER_DATA = SynchedEntityData.m_135353_(GoronMerchantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135043_);
    private static final List<VillagerTrades.ItemListing> FIRST_TRADES = Arrays.asList((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, ((Integer)MasterSwordCommonConfigs.TRADE_EMERALD_TO_RUPEE.get()).intValue()), new ItemStack((ItemLike)ModItems.GREEN_RUPEE.get(), 1), 10, 2, 0.0f), (pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)GoronMerchantEntity.getRupeeItem((String)MasterSwordCommonConfigs.TRADE_RUPEE_TO_BOMBCHU_TYPE.get()), ((Integer)MasterSwordCommonConfigs.TRADE_RUPEE_TO_BOMBCHU.get()).intValue()), new ItemStack((ItemLike)ModItems.BOMBCHU.get(), 1), 32, 4, 0.0f));
    private static final List<VillagerTrades.ItemListing> SECOND_TRADES = Arrays.asList((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.HYLIAN_BOTTLE.get(), 1), new ItemStack((ItemLike)GoronMerchantEntity.getRupeeItem((String)MasterSwordCommonConfigs.TRADE_RUPEE_TO_GREEN_POTION_TYPE.get()), ((Integer)MasterSwordCommonConfigs.TRADE_RUPEE_TO_GREEN_POTION.get()).intValue()), new ItemStack((ItemLike)ModItems.GREEN_POTION.get(), 1), 10, 15, 0.0f), (pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.LON_LON_MILK.get(), 1), new ItemStack((ItemLike)GoronMerchantEntity.getRupeeItem((String)MasterSwordCommonConfigs.TRADE_LON_LON_MILK_TO_RUPEE_TYPE.get()), ((Integer)MasterSwordCommonConfigs.TRADE_LON_LON_MILK_TO_RUPEE.get()).intValue()), 4, 15, 0.0f));
    private static final List<VillagerTrades.ItemListing> THIRD_TRADES = Arrays.asList((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)GoronMerchantEntity.getRupeeItem((String)MasterSwordCommonConfigs.TRADE_RUPEE_TO_BOOMERANG_TYPE.get()), ((Integer)MasterSwordCommonConfigs.TRADE_RUPEE_TO_BOOMERANG.get()).intValue()), new ItemStack((ItemLike)ModItems.BOOMERANG.get(), 1), 10, 10, 0.0f), (pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)GoronMerchantEntity.getRupeeItem((String)MasterSwordCommonConfigs.TRADE_RUPEE_TO_MAGIC_HAMMER_TYPE.get()), ((Integer)MasterSwordCommonConfigs.TRADE_RUPEE_TO_MAGIC_HAMMER.get()).intValue()), new ItemStack((ItemLike)ModItems.MAGIC_HAMMER.get(), 1), 10, 15, 0.0f));
    private static final List<VillagerTrades.ItemListing> FOURTH_TRADES = Arrays.asList((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)GoronMerchantEntity.getRupeeItem((String)MasterSwordCommonConfigs.TRADE_RUPEE_TO_HOOKSHOT_TYPE.get()), ((Integer)MasterSwordCommonConfigs.TRADE_RUPEE_TO_HOOKSHOT.get()).intValue()), new ItemStack((ItemLike)ModItems.HOOKSHOT.get(), 1), 10, 25, 0.0f), (pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)GoronMerchantEntity.getRupeeItem((String)MasterSwordCommonConfigs.TRADE_RUPEE_TO_FAIRY_ARROW_TYPE.get()), ((Integer)MasterSwordCommonConfigs.TRADE_RUPEE_TO_FAIRY_ARROW.get()).intValue()), new ItemStack((ItemLike)ModItems.FAIRY_ARROW.get(), 15), 32, 8, 0.0f));
    private static final List<VillagerTrades.ItemListing> FIFTH_TRADES = Arrays.asList((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)GoronMerchantEntity.getRupeeItem((String)MasterSwordCommonConfigs.TRADE_RUPEE_TO_DARK_HYLIAN_SHIELD_TYPE.get()), ((Integer)MasterSwordCommonConfigs.TRADE_RUPEE_TO_DARK_HYLIAN_SHIELD.get()).intValue()), new ItemStack((ItemLike)ModItems.HYLIAN_SHIELD_DARK.get(), 1), 2, 40, 0.0f), (pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)GoronMerchantEntity.getRupeeItem((String)MasterSwordCommonConfigs.TRADE_RUPEE_TO_TEMPLE_OF_TIME_MUSIC_DISC_TYPE.get()), ((Integer)MasterSwordCommonConfigs.TRADE_RUPEE_TO_TEMPLE_OF_TIME_MUSIC_DISC.get()).intValue()), new ItemStack((ItemLike)ModItems.TEMPLE_OF_TIME_MUSIC_DISC.get(), 1), 10, 15, 0.0f));
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int remainingPersistentAngerTime;
    @javax.annotation.Nullable
    private UUID persistentAngerTarget;
    private int updateMerchantTimer;
    private long lastRestockGameTime;
    private int numberOfRestocksToday;
    private long lastRestockCheckDayTime;
    private BlockPos wanderTarget;

    public GoronMerchantEntity(EntityType<? extends AbstractVillager> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22276_, 70.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22281_, 10.0);
    }

    private static Item getRupeeItem(String rupeeName) {
        switch (rupeeName.toLowerCase()) {
            case "green_rupee": {
                return (Item)ModItems.GREEN_RUPEE.get();
            }
            case "blue_rupee": {
                return (Item)ModItems.BLUE_RUPEE.get();
            }
            case "red_rupee": {
                return (Item)ModItems.RED_RUPEE.get();
            }
            case "purple_rupee": {
                return (Item)ModItems.PURPLE_RUPEE.get();
            }
            case "silver_rupee": {
                return (Item)ModItems.SILVER_RUPEE.get();
            }
            case "gold_rupee": {
                return (Item)ModItems.GOLD_RUPEE.get();
            }
        }
        return (Item)ModItems.GREEN_RUPEE.get();
    }

    public static <T extends Entity> AnimationController<T> animationController(T entity) {
        AnimationController controller = new AnimationController(entity, "Walk/Run/Idle", 1, state -> {
            if (state.isMoving()) {
                return state.setAndContinue(entity.m_20142_() ? DefaultAnimations.RUN : DefaultAnimations.WALK);
            }
            return state.setAndContinue(DefaultAnimations.IDLE);
        });
        controller.triggerableAnim("adjust_bag", ADJUST_BAG);
        controller.triggerableAnim("rummage", RUMMAGE);
        controller.triggerableAnim("wave", WAVE);
        controller.triggerableAnim("scratch", SCRATCH);
        controller.triggerableAnim("right_punch", RIGHT_PUNCH);
        controller.triggerableAnim("left_punch", LEFT_PUNCH);
        return controller;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (this.m_21223_() < this.m_21233_()) {
            this.m_21153_(this.m_21233_());
        }
        this.m_7604_();
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    protected AABB m_142242_() {
        double posX = this.m_20185_();
        double posY = this.m_20186_();
        double posZ = this.m_20189_();
        float width = 0.9f;
        float height = 1.8f;
        float halfWidth = width / 2.0f;
        return new AABB(posX - (double)halfWidth, posY, posZ - (double)halfWidth, posX + (double)halfWidth, posY + (double)height, posZ + (double)halfWidth);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new TradeWithPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.5, false));
        this.f_21345_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(1, (Goal)new LookAtTradingPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(2, (Goal)new WanderToPositionGoal(this, 2.0, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 0.35));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.35));
        this.f_21345_.m_25352_(9, (Goal)new InteractGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_7870_(int pTime) {
        this.remainingPersistentAngerTime = pTime;
    }

    @javax.annotation.Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@javax.annotation.Nullable UUID pTarget) {
        this.persistentAngerTarget = pTarget;
    }

    public boolean m_5825_() {
        return true;
    }

    protected SoundEvent m_6068_(boolean pIsYesSound) {
        return this.m_7515_();
    }

    public SoundEvent m_7596_() {
        return this.m_7515_();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        SoundEvent[] ambientSounds = new SoundEvent[]{(SoundEvent)ModSounds.GORON_AMBIENT1.get(), (SoundEvent)ModSounds.GORON_AMBIENT2.get(), (SoundEvent)ModSounds.GORON_AMBIENT3.get(), (SoundEvent)ModSounds.GORON_AMBIENT4.get(), SoundEvents.f_271165_};
        int randomIndex = this.m_217043_().m_188503_(ambientSounds.length);
        return ambientSounds[randomIndex];
    }

    public int m_8100_() {
        return 200;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.GORON_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.GORON_HURT.get();
    }

    public void m_6674_(InteractionHand pHand) {
        String[] animations = new String[]{"right_punch", "left_punch"};
        int randomIndex = this.m_217043_().m_188503_(animations.length);
        this.triggerAnim("Walk/Run/Idle", animations[randomIndex]);
        super.m_6674_(pHand);
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (!itemstack.m_150930_(Items.f_42601_) && this.m_6084_() && !this.m_35306_() && !this.m_6162_()) {
            if (pHand == InteractionHand.MAIN_HAND) {
                pPlayer.m_36220_(Stats.f_12940_);
                this.triggerAnim("Walk/Run/Idle", "wave");
            }
            if (this.m_6616_().size() > 5) {
                this.m_7604_();
            }
            if (this.m_6616_().isEmpty()) {
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (!this.m_9236_().f_46443_) {
                this.m_7189_(pPlayer);
                this.m_45301_(pPlayer, this.m_5446_(), this.m_7141_().m_35576_());
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    public boolean m_7826_() {
        return false;
    }

    protected void m_8058_(MerchantOffer pOffer) {
        if (pOffer.m_45383_()) {
            int i = 3 + this.f_19796_.m_188503_(4);
            this.m_9236_().m_7967_((Entity)new ExperienceOrb(this.m_9236_(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), i));
            this.updateMerchantTimer = 40;
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.shouldRestock()) {
            this.restock();
        }
        if (!this.m_35306_() && this.updateMerchantTimer > 0) {
            --this.updateMerchantTimer;
            if (this.updateMerchantTimer <= 0) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 0));
            }
        }
    }

    protected void m_7604_() {
        List<VillagerTrades.ItemListing> randomTrades = this.getRandomTrades();
        if (!randomTrades.isEmpty()) {
            MerchantOffers merchantoffers = this.m_6616_();
            merchantoffers.clear();
            this.m_35277_(merchantoffers, randomTrades.toArray(new VillagerTrades.ItemListing[0]), randomTrades.size());
        }
    }

    private List<VillagerTrades.ItemListing> getRandomTrades() {
        ArrayList<VillagerTrades.ItemListing> selectedTrades = new ArrayList<VillagerTrades.ItemListing>();
        this.addIfNotNull(selectedTrades, this.getRandomTrade(FIRST_TRADES));
        this.addIfNotNull(selectedTrades, this.getRandomTrade(SECOND_TRADES));
        this.addIfNotNull(selectedTrades, this.getRandomTrade(THIRD_TRADES));
        this.addIfNotNull(selectedTrades, this.getRandomTrade(FOURTH_TRADES));
        this.addIfNotNull(selectedTrades, this.getRandomTrade(FIFTH_TRADES));
        return selectedTrades;
    }

    private VillagerTrades.ItemListing getRandomTrade(List<VillagerTrades.ItemListing> trades) {
        if (trades == null || trades.isEmpty()) {
            return null;
        }
        return trades.get((int)(Math.random() * (double)trades.size()));
    }

    private void addIfNotNull(List<VillagerTrades.ItemListing> tradeList, VillagerTrades.ItemListing trade) {
        if (trade != null) {
            tradeList.add(trade);
        }
    }

    public boolean m_7862_() {
        return true;
    }

    public void restock() {
        this.updateDemand();
        for (MerchantOffer merchantoffer : this.m_6616_()) {
            merchantoffer.m_45372_();
        }
        this.resendOffersToTradingPlayer();
        this.lastRestockGameTime = this.m_9236_().m_46467_();
        ++this.numberOfRestocksToday;
    }

    private void resendOffersToTradingPlayer() {
        MerchantOffers merchantoffers = this.m_6616_();
        Player player = this.m_7962_();
        if (player != null && !merchantoffers.isEmpty()) {
            player.m_7662_(player.f_36096_.f_38840_, merchantoffers, this.m_7141_().m_35576_(), this.m_7809_(), this.m_7826_(), this.m_7862_());
        }
    }

    private boolean needsToRestock() {
        for (MerchantOffer merchantoffer : this.m_6616_()) {
            if (!merchantoffer.m_45382_()) continue;
            return true;
        }
        return false;
    }

    private boolean allowedToRestock() {
        return this.numberOfRestocksToday == 0 || this.numberOfRestocksToday < 2 && this.m_9236_().m_46467_() > this.lastRestockGameTime + 2400L;
    }

    public boolean shouldRestock() {
        long i = this.lastRestockGameTime + 12000L;
        long j = this.m_9236_().m_46467_();
        boolean flag = j > i;
        long k = this.m_9236_().m_46468_();
        if (this.lastRestockCheckDayTime > 0L) {
            long i1 = k / 24000L;
            long l = this.lastRestockCheckDayTime / 24000L;
            flag |= i1 > l;
        }
        this.lastRestockCheckDayTime = k;
        if (flag) {
            this.lastRestockGameTime = j;
            this.resetNumberOfRestocks();
        }
        return this.allowedToRestock() && this.needsToRestock();
    }

    private void resetNumberOfRestocks() {
        this.catchUpDemand();
        this.numberOfRestocksToday = 0;
    }

    private void catchUpDemand() {
        int i = 2 - this.numberOfRestocksToday;
        if (i > 0) {
            for (MerchantOffer merchantoffer : this.m_6616_()) {
                merchantoffer.m_45372_();
            }
        }
        for (int j = 0; j < i; ++j) {
            this.updateDemand();
        }
        this.resendOffersToTradingPlayer();
    }

    private void updateDemand() {
        for (MerchantOffer merchantoffer : this.m_6616_()) {
            merchantoffer.m_45369_();
        }
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VILLAGER_DATA, (Object)new VillagerData(VillagerType.f_35821_, (VillagerProfession)ModVillagers.GORON_MERCHANT.get(), 1));
    }

    public VillagerData m_7141_() {
        return (VillagerData)this.f_19804_.m_135370_(DATA_VILLAGER_DATA);
    }

    public void m_34375_(VillagerData pData) {
        VillagerData villagerdata = this.m_7141_();
        if (villagerdata.m_35571_() != pData.m_35571_()) {
            villagerdata.m_35565_((VillagerProfession)ModVillagers.GORON_MERCHANT.get());
        }
        if (villagerdata.m_35576_() != pData.m_35576_()) {
            villagerdata.m_35561_(5);
            this.m_7604_();
        }
        this.f_19804_.m_135381_(DATA_VILLAGER_DATA, (Object)pData);
    }

    @Nullable
    public BlockPos getWanderTarget() {
        return this.wanderTarget;
    }

    public void setWanderTarget(@Nullable BlockPos pWanderTarget) {
        this.wanderTarget = pWanderTarget;
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.wanderTarget != null) {
            pCompound.m_128365_("WanderTarget", (Tag)NbtUtils.m_129224_((BlockPos)this.wanderTarget));
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("WanderTarget")) {
            this.wanderTarget = NbtUtils.m_129239_((CompoundTag)pCompound.m_128469_("WanderTarget"));
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_ && this.isEntityStationary() && this.f_19797_ % 20 == 0 && this.f_19796_.m_188503_(10) < 1) {
            this.triggerRandomIdleAnimation();
        }
    }

    private boolean isEntityStationary() {
        Vec3 deltaMovement = this.m_20184_();
        return deltaMovement.f_82479_ == 0.0 && deltaMovement.f_82481_ == 0.0 && !this.f_20911_;
    }

    private void triggerRandomIdleAnimation() {
        int roll = this.f_19796_.m_188503_(100);
        if (roll < 60) {
            this.triggerAnim("Walk/Run/Idle", "adjust_bag");
        } else if (roll < 85) {
            this.triggerAnim("Walk/Run/Idle", "scratch");
        } else {
            this.triggerAnim("Walk/Run/Idle", "rummage");
            this.f_21344_.m_26573_();
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{GoronMerchantEntity.animationController(this)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    class WanderToPositionGoal
    extends Goal {
        final GoronMerchantEntity merchant;
        final double stopDistance;
        final double speedModifier;

        WanderToPositionGoal(GoronMerchantEntity pMerchant, double pStopDistance, double pSpeedModifier) {
            this.merchant = pMerchant;
            this.stopDistance = pStopDistance;
            this.speedModifier = pSpeedModifier;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public void m_8041_() {
            this.merchant.setWanderTarget(null);
            this.merchant.f_21344_.m_26573_();
        }

        public boolean m_8036_() {
            BlockPos blockpos = this.merchant.getWanderTarget();
            return blockpos != null && this.isTooFarAway(blockpos, this.stopDistance);
        }

        public void m_8037_() {
            BlockPos blockpos = this.merchant.getWanderTarget();
            if (blockpos != null && this.merchant.f_21344_.m_26571_()) {
                if (this.isTooFarAway(blockpos, 4.0)) {
                    Vec3 vec3 = new Vec3((double)blockpos.m_123341_() - this.merchant.m_20185_(), (double)blockpos.m_123342_() - this.merchant.m_20186_(), (double)blockpos.m_123343_() - this.merchant.m_20189_()).m_82541_();
                    Vec3 vec31 = vec3.m_82490_(10.0).m_82520_(this.merchant.m_20185_(), this.merchant.m_20186_(), this.merchant.m_20189_());
                    this.merchant.f_21344_.m_26519_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, this.speedModifier);
                } else {
                    this.merchant.f_21344_.m_26519_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), this.speedModifier);
                }
            }
        }

        private boolean isTooFarAway(BlockPos pPos, double pDistance) {
            return !pPos.m_203195_((Position)this.merchant.m_20182_(), pDistance);
        }
    }
}

