/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.entity.custom;

import java.util.UUID;
import javax.annotation.Nullable;
import net.mezimaru.mastersword.entity.ModEntities;
import net.mezimaru.mastersword.entity.custom.OcarinaHorseEntity;
import net.mezimaru.mastersword.item.custom.BaseHookshotItem;
import net.mezimaru.mastersword.network.ModMessages;
import net.mezimaru.mastersword.network.packet.HookshotRetractingS2CPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class HookshotHookProjectileEntity
extends AbstractArrow {
    private static final double BASE_DAMAGE = 2.0;
    private static final float WATER_INERTIA = 1.0f;
    protected ItemStack hookshotStack;
    private boolean isPulling = false;
    private double maxRange = 0.0;
    private double maxSpeed = 0.0;
    private double prevDistance = 30.0;
    private boolean shouldRetract = false;
    private UUID shootingPlayerUUID;
    private InteractionHand usedItemHand;
    private float shooterPitch;
    private OcarinaHorseEntity attachedHorse;

    public HookshotHookProjectileEntity(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public HookshotHookProjectileEntity(LivingEntity shooter, Level level) {
        super((EntityType)ModEntities.HOOKSHOT_HOOK.get(), shooter, level);
        this.m_5602_((Entity)shooter);
        this.shootingPlayerUUID = shooter.m_20148_();
        this.usedItemHand = shooter.m_7655_();
        this.isPulling = this.isPulling();
        this.attachedHorse = this.getAttachedHorse();
    }

    public void setShootingPlayerUUID(UUID uuid) {
        this.shootingPlayerUUID = uuid;
    }

    @Nullable
    public Player getShootingPlayer() {
        return this.shootingPlayerUUID == null ? null : this.f_19853_.m_46003_(this.shootingPlayerUUID);
    }

    protected AABB m_142242_() {
        float size = 0.5f;
        return new AABB(this.m_20185_() - (double)(size / 2.0f), this.m_20186_() + 0.2, this.m_20189_() - (double)(size / 2.0f), this.m_20185_() + (double)(size / 2.0f), this.m_20186_() + (double)size, this.m_20189_() + (double)(size / 2.0f));
    }

    @Nullable
    public InteractionHand getActiveItemHand() {
        return this.usedItemHand;
    }

    public void setActiveItemHand(InteractionHand hand) {
        this.usedItemHand = hand;
    }

    public boolean getShouldRetract() {
        return this.shouldRetract;
    }

    public void setShouldRetract(boolean value) {
        this.shouldRetract = value;
    }

    public float getShooterPitch() {
        return this.shooterPitch;
    }

    public void setShooterPitch(float pitch) {
        this.shooterPitch = pitch * -1.0f;
    }

    public boolean isPulling() {
        return this.isPulling;
    }

    public void setPulling(boolean pulling) {
        this.isPulling = pulling;
    }

    public OcarinaHorseEntity getAttachedHorse() {
        return this.attachedHorse;
    }

    public void setAttachedHorse(OcarinaHorseEntity attachedHorse) {
        this.attachedHorse = attachedHorse;
    }

    public boolean m_6072_() {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        Entity entity = this.m_19749_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.handlePlayerOwner(player);
            this.handleRetracting(player);
        }
    }

    public void handlePlayerOwner(Player player) {
        this.playPullingSound(player);
        this.handleServerSideLogic(player);
    }

    private void playPullingSound(Player player) {
        if (this.f_19797_ % 2 == 0) {
            BlockPos currentPos = player.m_20183_();
            this.m_9236_().m_6263_(null, (double)currentPos.m_123341_(), (double)currentPos.m_123342_(), (double)currentPos.m_123343_(), SoundEvents.f_11744_, SoundSource.PLAYERS, 0.5f, 1.0f);
        }
    }

    private void handleServerSideLogic(Player player) {
        if (!this.m_9236_().f_46443_) {
            this.handleOwnerState(player);
            this.handlePullingMovement(player);
        }
    }

    private void handleOwnerState(Player player) {
        if (this.shouldTerminateHookshot(player)) {
            this.m_6074_();
        } else if ((double)player.m_20270_((Entity)this) > this.maxRange) {
            this.shouldRetract = true;
            ModMessages.sendToNearbyClients(new HookshotRetractingS2CPacket(this.m_19879_(), this.shouldRetract), (ServerPlayer)player);
            ModMessages.sendToPlayer(new HookshotRetractingS2CPacket(this.m_19879_(), this.shouldRetract), (ServerPlayer)player);
        }
    }

    protected boolean shouldTerminateHookshot(Player player) {
        return player.m_21224_() || this.f_19797_ == 50 || player.m_21205_() != this.hookshotStack && player.m_21206_() != this.hookshotStack;
    }

    private void handlePullingMovement(Player player) {
        if ((player.m_21205_() == this.hookshotStack || player.m_21206_() == this.hookshotStack) && this.isPulling) {
            this.pullOwnerTowardsHookshot(player);
        }
    }

    private void handleRetracting(Player player) {
        if (this.shouldRetract) {
            Vec3 handPos = this.getHookshotHoldPosition(1.0f, player, player.m_7655_());
            handPos = new Vec3(handPos.f_82479_, handPos.f_82480_ + 0.3, handPos.f_82481_);
            Vec3 hookPos = this.m_20182_();
            Vec3 direction = handPos.m_82546_(hookPos);
            double retractSpeed = 1.2;
            this.m_20256_(direction.m_82541_().m_82490_(retractSpeed));
            this.m_36790_(true);
            if ((double)player.m_20270_((Entity)this) < 1.5) {
                this.m_6074_();
            }
        }
    }

    public void pullOwnerTowardsHookshot(Player player) {
        player.m_20242_(true);
        double pullSpeed = this.maxSpeed / 9.0;
        if (this.attachedHorse != null) {
            this.m_146884_(this.attachedHorse.m_20191_().m_82399_());
        }
        Vec3 distance = this.m_20182_().m_82546_(player.m_20182_().m_82520_(0.0, (double)(player.m_20206_() / 2.0f), 0.0));
        Vec3 motion = distance.m_82541_().m_82542_(pullSpeed, pullSpeed, pullSpeed);
        this.adjustMotionForGroundLevel(distance, motion);
        this.adjustMotionForUpwardMovement(distance, (Entity)player, motion);
        player.f_19789_ = 0.0f;
        player.m_20256_(motion);
        player.f_19864_ = true;
        this.handleBlockCollision(distance);
        if (this.attachedHorse != null && distance.m_82553_() < (double)(this.attachedHorse.m_20205_() / 2.0f)) {
            player.m_20329_((Entity)this.attachedHorse);
            this.m_6074_();
        }
        this.prevDistance = distance.m_82553_();
    }

    private void adjustMotionForGroundLevel(Vec3 distance, Vec3 motion) {
        if (Math.abs(distance.f_82480_) < 0.1) {
            motion = new Vec3(motion.f_82479_, 0.0, motion.f_82481_);
        }
    }

    private void adjustMotionForUpwardMovement(Vec3 distance, Entity target, Vec3 motion) {
        Vec3 vec3 = new Vec3(distance.f_82479_, 0.0, distance.f_82481_);
        Vec3 vec32 = new Vec3((double)(target.m_20205_() / 2.0f), 0.0, (double)(target.m_20205_() / 2.0f));
        if (vec3.m_82553_() < vec32.m_82553_() / 1.4) {
            motion = new Vec3(0.0, motion.f_82480_, 0.0);
        }
    }

    private void handleBlockCollision(Vec3 distance) {
        if (distance.m_82553_() > this.prevDistance && this.prevDistance < 1.0) {
            this.m_6074_();
        } else {
            Vec3 vec3 = new Vec3(distance.f_82479_, 0.0, distance.f_82481_);
            if (vec3.m_82553_() < 0.3) {
                this.m_6074_();
            }
        }
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        this.resetOwnerGravity(this.getShootingPlayer());
    }

    private void resetOwnerGravity(Player player) {
        if (!this.m_9236_().f_46443_ && player != null) {
            player.m_20242_(false);
        }
    }

    protected void m_8060_(@NotNull BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        this.isPulling = true;
    }

    public void setProperties(ItemStack stack, double maxRange, double maxVelocity, float pitch, float yaw, float roll, float modifierZ) {
        this.validateProperties(maxRange, maxVelocity);
        float f = (float)Math.PI / 180;
        float x = -Mth.m_14031_((float)(yaw * f)) * Mth.m_14089_((float)(pitch * f));
        float y = -Mth.m_14031_((float)((pitch + roll) * f));
        float z = Mth.m_14089_((float)(yaw * f)) * Mth.m_14089_((float)(pitch * f));
        this.m_6686_(x, y, z, modifierZ, 0.0f);
        this.hookshotStack = stack;
        this.maxRange = maxRange;
        this.maxSpeed = maxVelocity;
    }

    private void validateProperties(double maxRange, double maxVelocity) {
        if (maxRange <= 0.0) {
            throw new IllegalArgumentException("Maximum range must be greater than 0");
        }
        if (maxVelocity <= 0.0) {
            throw new IllegalArgumentException("Maximum velocity must be greater than 0");
        }
    }

    public void m_6074_() {
        if (!this.m_9236_().f_46443_) {
            this.resetOwnerState();
        }
        super.m_6074_();
    }

    private void resetOwnerState() {
        Entity entity = this.m_19749_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_20334_(0.0, 0.0, 0.0);
            player.f_19864_ = true;
        }
        this.isPulling = false;
        if (this.hookshotStack != null) {
            this.hookshotStack.m_41784_().m_128379_("ShotHook", false);
        }
    }

    public boolean m_20068_() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distance) {
        double d0 = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return super.m_6000_(pX, pY, pZ);
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12064_;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.m_36781_(2.0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.shootingPlayerUUID != null) {
            compound.m_128362_("ShootingPlayerUUID", this.shootingPlayerUUID);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("ShootingPlayerUUID")) {
            this.shootingPlayerUUID = compound.m_128342_("ShootingPlayerUUID");
        }
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    protected boolean m_142470_(Player pPlayer) {
        return false;
    }

    protected float m_6882_() {
        return 1.0f;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public Vec3 getHookshotHoldPosition(float pPartialTicks, Player player, InteractionHand hand) {
        float f2;
        HumanoidArm mainArm;
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        if (!(item instanceof BaseHookshotItem)) {
            hand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        }
        boolean mainHandIsActive = (mainArm = player.m_5737_()) == HumanoidArm.RIGHT && hand == InteractionHand.MAIN_HAND || mainArm == HumanoidArm.LEFT && hand == InteractionHand.OFF_HAND;
        double d0 = 0.22 * (mainHandIsActive ? -1.0 : 1.0);
        float f = Mth.m_14179_((float)(pPartialTicks * 0.5f), (float)player.m_146909_(), (float)player.f_19860_) * ((float)Math.PI / 180);
        float f1 = Mth.m_14179_((float)pPartialTicks, (float)player.f_20884_, (float)player.f_20883_) * ((float)Math.PI / 180);
        if (!player.m_21255_() && !player.m_21209_()) {
            if (player.m_6067_()) {
                return player.m_20318_(pPartialTicks).m_82549_(new Vec3(d0, 0.2, -0.15).m_82496_(-f).m_82524_(-f1));
            }
            double d5 = player.m_20191_().m_82376_() - 1.0;
            double d6 = player.m_6047_() ? -0.2 : 0.07;
            return player.m_20318_(pPartialTicks).m_82549_(new Vec3(d0, d5, d6).m_82524_(-f1));
        }
        Vec3 vec3 = player.m_20252_(pPartialTicks);
        Vec3 vec31 = player.m_20184_();
        double d1 = vec31.m_165925_();
        double d2 = vec3.m_165925_();
        if (d1 > 0.0 && d2 > 0.0) {
            double d3 = (vec31.f_82479_ * vec3.f_82479_ + vec31.f_82481_ * vec3.f_82481_) / Math.sqrt(d1 * d2);
            double d4 = vec31.f_82479_ * vec3.f_82481_ - vec31.f_82481_ * vec3.f_82479_;
            f2 = (float)(Math.signum(d4) * Math.acos(d3));
        } else {
            f2 = 0.0f;
        }
        return player.m_20318_(pPartialTicks).m_82549_(new Vec3(d0, -0.11, 0.85).m_82535_(-f2).m_82496_(-f).m_82524_(-f1));
    }
}

