/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.item.custom;

import java.util.UUID;
import net.mezimaru.mastersword.entity.custom.HookshotHookProjectileEntity;
import net.mezimaru.mastersword.network.ModMessages;
import net.mezimaru.mastersword.network.packet.HookshotOwnerS2CPacket;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class BaseHookshotItem
extends Item {
    protected static final int RESET_TIME_TICKS = 200;
    protected int hookTimer = 0;

    public BaseHookshotItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public boolean m_8120_(ItemStack pStack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BLOCK;
    }

    public int m_8105_(ItemStack pStack) {
        return 4;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player player, InteractionHand pHand) {
        if (!pLevel.f_46443_) {
            ItemStack itemstack = player.m_21120_(pHand);
            if (this.isHookShotActive(player)) {
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
            UUID playerUUID = player.m_20148_();
            HookshotHookProjectileEntity projectile = new HookshotHookProjectileEntity((LivingEntity)player, pLevel);
            Vec3 handPos = projectile.getHookshotHoldPosition(1.0f, player, pHand);
            projectile.m_5602_((Entity)player);
            projectile.m_6034_(handPos.f_82479_, player.m_20188_() - 0.5, handPos.f_82481_);
            this.setProjectileProperties(projectile, itemstack, player);
            player.m_6672_(pHand);
            pLevel.m_7967_((Entity)projectile);
            player.m_36335_().m_41524_((Item)this, 50);
            this.setShotFlag(itemstack, true);
            ModMessages.sendToNearbyClients(new HookshotOwnerS2CPacket(projectile.m_19879_(), playerUUID, pHand, player.m_146909_()), (ServerPlayer)player);
            ModMessages.sendToPlayer(new HookshotOwnerS2CPacket(projectile.m_19879_(), playerUUID, pHand, player.m_146909_()), (ServerPlayer)player);
        }
        this.playShootSound(pLevel, player);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(pHand));
    }

    protected abstract void setProjectileProperties(HookshotHookProjectileEntity var1, ItemStack var2, Player var3);

    public boolean isHookShotActive(Player player) {
        return player.m_21120_(InteractionHand.MAIN_HAND).m_41784_().m_128471_("ShotHook") || player.m_21120_(InteractionHand.OFF_HAND).m_41784_().m_128471_("ShotHook");
    }

    public void setShotFlag(ItemStack itemstack, boolean flag) {
        itemstack.m_41784_().m_128379_("ShotHook", flag);
    }

    public void playShootSound(Level level, Player player) {
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, -4.0f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (pEntity instanceof Player & !pLevel.f_46443_) {
            this.hookTimer = pStack.m_41784_().m_128471_("ShotHook") ? ++this.hookTimer : 0;
            if (this.hookTimer >= 200) {
                this.setShotFlag(pStack, false);
                this.hookTimer = 0;
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public MutableComponent getName(ItemStack stack) {
        MutableComponent itemName = (MutableComponent)super.m_7626_(stack);
        return itemName.m_130940_(this.getColorForType(stack));
    }

    protected abstract ChatFormatting getColorForType(ItemStack var1);
}

