/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.item.custom;

import java.util.List;
import net.mezimaru.mastersword.item.custom.FierceDeitySwordItem;
import net.mezimaru.mastersword.item.custom.GoldenMasterSwordItem;
import net.mezimaru.mastersword.item.custom.MasterSwordItem;
import net.mezimaru.mastersword.item.custom.TemperedMasterSwordItem;
import net.mezimaru.mastersword.item.custom.TrueMasterSwordItem;
import net.mezimaru.mastersword.network.ModMessages;
import net.mezimaru.mastersword.network.packet.SpinAttackAnimationS2CPacket;
import net.mezimaru.mastersword.sound.ModSounds;
import net.mezimaru.mastersword.util.AbilityCapability;
import net.mezimaru.mastersword.util.AbilityCapabilityProvider;
import net.mezimaru.mastersword.util.ParticleHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeTier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomSwordItem
extends SwordItem {
    public static final ItemCooldowns spinCooldown = new ItemCooldowns();

    public CustomSwordItem(ForgeTier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super((Tier)pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        if (pAttacker instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)pAttacker;
            pStack.m_220157_(1, pAttacker.m_217043_(), player);
        }
        return true;
    }

    public boolean m_6813_(ItemStack pStack, Level pLevel, BlockState pState, BlockPos pPos, LivingEntity pEntityLiving) {
        if (pEntityLiving instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)pEntityLiving;
            if (pState.m_60800_((BlockGetter)pLevel, pPos) != 0.0f) {
                pStack.m_220157_(2, pEntityLiving.m_217043_(), player);
            }
        }
        return true;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (stack.m_41773_() < stack.m_41776_() - 1) {
            return false;
        }
        if (!player.f_19853_.f_46443_) {
            player.m_5661_((Component)Component.m_237115_((String)"message.mastersword.sword_broken"), true);
        }
        return true;
    }

    public boolean m_6777_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        if (!pPlayer.m_7500_()) {
            ItemStack stack = pPlayer.m_21120_(InteractionHand.MAIN_HAND);
            if (stack.m_41773_() < stack.m_41776_() - 1) {
                return true;
            }
            if (!pPlayer.f_19853_.f_46443_) {
                pPlayer.m_5661_((Component)Component.m_237115_((String)"message.mastersword.sword_broken"), true);
            }
            return false;
        }
        return false;
    }

    final int getChargeDuration(ItemStack stack) {
        return 20;
    }

    public final int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand pHand) {
        ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
        AbilityCapability abilityCapability = (AbilityCapability)player.getCapability(AbilityCapabilityProvider.ABILITY_CAPABILITY).orElse(null);
        if (abilityCapability == null) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (stack.m_41720_() instanceof MasterSwordItem || stack.m_41720_() instanceof TemperedMasterSwordItem || stack.m_41720_() instanceof GoldenMasterSwordItem || stack.m_41720_() instanceof FierceDeitySwordItem || stack.m_41720_() instanceof TrueMasterSwordItem) {
            if (stack.m_41773_() >= stack.m_41776_() - 1) {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            if (spinCooldown.m_41519_(stack.m_41720_())) {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            if (player.m_6047_()) {
                player.m_6672_(pHand);
                abilityCapability.setSpinChargeSoundPlayed(false);
                abilityCapability.setShouldSpawnSpinChargeParticles(true);
                return InteractionResultHolder.m_19096_((Object)stack);
            }
        }
        return super.m_7203_(level, player, pHand);
    }

    public void m_5929_(@NotNull Level level, @NotNull LivingEntity livingEntity, @NotNull ItemStack stack, int ticks) {
        Player player;
        ItemStack mainhandItem;
        if (!level.f_46443_ && livingEntity instanceof Player && ((mainhandItem = (player = (Player)livingEntity).m_21120_(InteractionHand.MAIN_HAND)).m_41720_() instanceof MasterSwordItem || mainhandItem.m_41720_() instanceof TemperedMasterSwordItem || mainhandItem.m_41720_() instanceof GoldenMasterSwordItem || mainhandItem.m_41720_() instanceof FierceDeitySwordItem || mainhandItem.m_41720_() instanceof TrueMasterSwordItem)) {
            AbilityCapability abilityCapability = (AbilityCapability)player.getCapability(AbilityCapabilityProvider.ABILITY_CAPABILITY).orElse(null);
            if (abilityCapability == null) {
                return;
            }
            float f = (float)(stack.m_41779_() - ticks) / (float)this.getChargeDuration(stack);
            if (f >= 0.5f && !abilityCapability.isSpinChargeSoundPlayed()) {
                abilityCapability.setSpinChargeSoundPlayed(true);
                level.m_6269_(null, (Entity)livingEntity, (SoundEvent)ModSounds.SPIN_CHARGE.get(), SoundSource.NEUTRAL, 0.9f, 1.0f);
            }
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity livingEntity, int count) {
        Player player;
        ItemStack mainhandItem;
        if (!level.f_46443_ && livingEntity instanceof Player && ((mainhandItem = (player = (Player)livingEntity).m_21120_(InteractionHand.MAIN_HAND)).m_41720_() instanceof MasterSwordItem || mainhandItem.m_41720_() instanceof TemperedMasterSwordItem || mainhandItem.m_41720_() instanceof GoldenMasterSwordItem || mainhandItem.m_41720_() instanceof FierceDeitySwordItem || mainhandItem.m_41720_() instanceof TrueMasterSwordItem)) {
            AbilityCapability abilityCapability = (AbilityCapability)player.getCapability(AbilityCapabilityProvider.ABILITY_CAPABILITY).orElse(null);
            if (abilityCapability == null) {
                return;
            }
            abilityCapability.setShouldSpawnSpinChargeParticles(false);
            if (!player.m_6047_()) {
                abilityCapability.setSpinChargeSoundPlayed(false);
                return;
            }
            abilityCapability.setI(this.m_8105_(stack) - count);
            if (abilityCapability.getI() >= this.getChargeDuration(stack)) {
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                spinCooldown.m_41519_((Item)this);
                player.m_36335_().m_41524_((Item)this, 180);
                abilityCapability.setStandForSpin(true);
                ModMessages.sendToNearbyClients(new SpinAttackAnimationS2CPacket(player.m_19879_()), (ServerPlayer)player);
                ModMessages.sendToPlayer(new SpinAttackAnimationS2CPacket(player.m_19879_()), (ServerPlayer)player);
            }
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack mainhandItem = player.m_21120_(InteractionHand.MAIN_HAND);
            ItemStack offhandItem = player.m_21120_(InteractionHand.OFF_HAND);
            AbilityCapability abilityCapability = (AbilityCapability)player.getCapability(AbilityCapabilityProvider.ABILITY_CAPABILITY).orElse(null);
            if (abilityCapability == null) {
                return;
            }
            abilityCapability.tickSwordBeamCooldown();
            if (!(player.m_21211_().m_41720_() instanceof CustomSwordItem)) {
                abilityCapability.setSpinChargeSoundPlayed(false);
                abilityCapability.setShouldSpawnSpinChargeParticles(false);
            }
            if (mainhandItem.m_41720_() instanceof CustomSwordItem) {
                if (offhandItem.m_41720_() instanceof CustomSwordItem) {
                    player.m_150109_().m_150079_(offhandItem);
                    if (!level.f_46443_) {
                        player.m_5661_((Component)Component.m_237115_((String)"message.mastersword.dual_wielding"), true);
                    }
                    return;
                }
                if (abilityCapability.isSpinChargeSoundPlayed() && abilityCapability.isShouldSpawnSpinChargeParticles()) {
                    int numParticles = 1;
                    Vec3 handPosOffset = player.m_204034_((Item)this);
                    double particleY = player.m_20186_() + handPosOffset.m_7098_() + 1.0 + Math.random() * 0.1;
                    double randomX = player.m_20185_() + handPosOffset.m_7096_() + (Math.random() - 0.5) * 1.0;
                    double randomZ = player.m_20189_() + handPosOffset.m_7094_() + (Math.random() - 0.5) * 1.0;
                    for (int i = 0; i < numParticles; ++i) {
                        ParticleHelper.spawnParticle(level, (ParticleOptions)ParticleTypes.f_175830_, randomX, particleY, randomZ, (Math.random() - 0.5) * 0.2, Math.random() * 0.1, (Math.random() - 0.5) * 0.2);
                    }
                }
            }
        }
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237113_((String)""));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mastersword.rightclick.tooltip1").m_130940_(ChatFormatting.LIGHT_PURPLE));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mastersword.rightclick.tooltip2").m_130940_(ChatFormatting.LIGHT_PURPLE));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mastersword.customsword.tooltip1").m_130940_(ChatFormatting.ITALIC));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mastersword.customsword.tooltip2").m_130940_(ChatFormatting.ITALIC));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

