/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.item.custom;

import java.util.List;
import net.mezimaru.mastersword.client.MagicMeterData;
import net.mezimaru.mastersword.events.MagicMeterEvents;
import net.mezimaru.mastersword.item.custom.MagicLanternItem;
import net.mezimaru.mastersword.util.IMagicItem;
import net.mezimaru.mastersword.util.ParticleHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FairyLanternItem
extends MagicLanternItem
implements IMagicItem {
    private static final ItemCooldowns fairyLanternCoolDown = new ItemCooldowns();
    private static final String FLAME_EFFECT = "flame";
    private static final String NIGHT_VISION_EFFECT = "night_vision";
    private static final String USE_EFFECT = "use_effect";
    private static final String NIGHT_VISION_ON = "night_vision_on";
    private int tickCounter;

    public FairyLanternItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    @Override
    public boolean m_8120_(ItemStack pStack) {
        return false;
    }

    @Override
    public boolean m_5812_(ItemStack stack) {
        return stack.m_41784_().m_128471_(NIGHT_VISION_ON);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (!level.f_46443_) {
            if (fairyLanternCoolDown.m_41519_(stack.m_41720_())) {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            if (player.m_6047_()) {
                String currentEffect = stack.m_41784_().m_128461_(USE_EFFECT);
                String newEffect = currentEffect.equals(FLAME_EFFECT) ? NIGHT_VISION_EFFECT : FLAME_EFFECT;
                stack.m_41784_().m_128359_(USE_EFFECT, newEffect);
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ClientboundSetCarriedItemPacket packet = new ClientboundSetCarriedItemPacket(player.m_150109_().f_35977_);
                serverPlayer.f_8906_.m_9829_((Packet)packet);
                String effectMessage = newEffect.equals(FLAME_EFFECT) ? "message.mastersword.magic_lantern.flame_effect" : "message.mastersword.magic_lantern.night_vision_effect";
                player.m_5661_((Component)Component.m_237115_((String)effectMessage), true);
            } else {
                this.useBasedOnEffect(player, stack);
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            if (stack.m_41784_().m_128461_(USE_EFFECT).equals(NIGHT_VISION_EFFECT)) {
                fairyLanternCoolDown.m_41519_((Item)this);
                player.m_36335_().m_41524_((Item)this, 30);
            }
        }
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    @Override
    public InteractionResult m_6225_(UseOnContext pContext) {
        ItemStack stack = pContext.m_43722_();
        Level level = pContext.m_43725_();
        Player player = pContext.m_43723_();
        String currentEffect = stack.m_41784_().m_128461_(USE_EFFECT);
        if (player == null) {
            return InteractionResult.FAIL;
        }
        ItemStack mainhandItem = player.m_21120_(InteractionHand.MAIN_HAND);
        if (mainhandItem.m_41720_() != this) {
            return InteractionResult.PASS;
        }
        if (currentEffect.equals(NIGHT_VISION_EFFECT)) {
            InteractionResultHolder<ItemStack> result = this.m_7203_(level, player, InteractionHand.MAIN_HAND);
            return result.m_19089_();
        }
        if (currentEffect.equals(FLAME_EFFECT)) {
            return super.m_6225_(pContext);
        }
        stack.m_41784_().m_128359_(USE_EFFECT, FLAME_EFFECT);
        return super.m_6225_(pContext);
    }

    private void useBasedOnEffect(Player player, ItemStack stack) {
        String currentEffect = stack.m_41784_().m_128461_(USE_EFFECT);
        if (currentEffect.equals(NIGHT_VISION_EFFECT)) {
            if (MagicMeterData.getMagicAmount(player) < this.getMagicCost() && !player.m_7500_()) {
                if (!player.f_19853_.f_46443_) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.mastersword.no_magic"), true);
                }
            } else {
                boolean previousNightVisionState = stack.m_41784_().m_128471_(NIGHT_VISION_ON);
                boolean newNightVisionState = !previousNightVisionState;
                stack.m_41784_().m_128379_(NIGHT_VISION_ON, newNightVisionState);
                if (previousNightVisionState && !newNightVisionState) {
                    this.endFairyVision(stack, player);
                }
            }
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (!level.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            if (stack.m_41784_().m_128471_(NIGHT_VISION_ON)) {
                if (MagicMeterData.getMagicAmount(player) > 0 || player.m_7500_()) {
                    if (selected || player.m_21120_(InteractionHand.OFF_HAND) == stack) {
                        ++this.tickCounter;
                        if (this.tickCounter % 80 == 0 || this.tickCounter == 1) {
                            player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 500, 0, false, false));
                            if (player instanceof ServerPlayer) {
                                ServerPlayer serverPlayer = (ServerPlayer)player;
                                MagicMeterEvents.removeMagic(this.getMagicCost(), serverPlayer);
                            }
                        }
                        if (player.m_217043_().m_188503_(100) < 2) {
                            Vec3 handPosOffset = player.m_204034_((Item)this);
                            double x = player.m_20185_() + handPosOffset.f_82479_ + player.m_217043_().m_188583_() * 0.1;
                            double y = player.m_20186_() + handPosOffset.f_82480_ + player.m_217043_().m_188583_() * 0.1;
                            double z = player.m_20189_() + handPosOffset.f_82481_ + player.m_217043_().m_188583_() * 0.1;
                            ParticleHelper.spawnParticle(level, (ParticleOptions)ParticleTypes.f_123760_, x, y, z, 0.0, 0.0, 0.0);
                        }
                    } else {
                        this.endFairyVision(stack, player);
                    }
                } else {
                    this.endFairyVision(stack, player);
                }
            }
        }
        super.m_6883_(stack, level, entity, slot, selected);
    }

    private void endFairyVision(ItemStack stack, Player player) {
        this.tickCounter = 0;
        player.m_21195_(MobEffects.f_19611_);
        stack.m_41784_().m_128379_(NIGHT_VISION_ON, false);
    }

    @Override
    public MutableComponent getName(ItemStack stack) {
        MutableComponent itemName = super.getName(stack);
        return itemName.m_130940_(ChatFormatting.DARK_PURPLE);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        int magicCost = this.getMagicCost();
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mastersword.magic_cost").m_7220_((Component)Component.m_237113_((String)String.valueOf(magicCost))).m_130940_(ChatFormatting.DARK_GREEN));
        pTooltipComponents.add((Component)Component.m_237113_((String)""));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mastersword.rightclick.tooltip1").m_130940_(ChatFormatting.LIGHT_PURPLE));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mastersword.rightclick.tooltip2").m_130940_(ChatFormatting.LIGHT_PURPLE));
        String currentEffect = stack.m_41784_().m_128461_(USE_EFFECT);
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mastersword.magic_lantern.tooltip2").m_130940_(ChatFormatting.YELLOW));
        if (!currentEffect.equals(NIGHT_VISION_EFFECT)) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"message.mastersword.magic_lantern.flame_effect").m_130940_(ChatFormatting.AQUA));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"message.mastersword.magic_lantern.night_vision_effect").m_130940_(ChatFormatting.AQUA));
        }
    }

    @Override
    public int getMagicCost() {
        return 2;
    }
}

