/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.item.custom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.mezimaru.mastersword.client.MagicMeterData;
import net.mezimaru.mastersword.item.ModItems;
import net.mezimaru.mastersword.item.custom.TemperedMasterSwordItem;
import net.mezimaru.mastersword.sound.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class TriforceItem
extends Item {
    private static final String OWNER_FLAG_KEY = "HasTemperedMasterSword";

    public TriforceItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public static boolean processWish(ServerPlayer player, int wishType) {
        if (!TriforceItem.hasTriforce(player)) {
            TriforceItem.sendErrorMessage(player, "message.mastersword.need_triforce");
            return false;
        }
        try {
            switch (wishType) {
                case 1: {
                    TriforceItem.processLifeWish(player);
                    break;
                }
                case 2: {
                    TriforceItem.processExperienceWish(player);
                    break;
                }
                case 3: {
                    TriforceItem.processRepairWish(player);
                    break;
                }
                case 4: {
                    TriforceItem.processUpgradeFightersShieldWish(player);
                    break;
                }
                case 5: {
                    TriforceItem.processUpgradeHylianShieldWish(player);
                    break;
                }
                case 6: {
                    TriforceItem.processHalfMagicCostWish(player);
                    break;
                }
                default: {
                    TriforceItem.sendErrorMessage(player, "message.mastersword.invalid_number");
                    break;
                }
            }
        }
        catch (WishProcessingException e) {
            TriforceItem.sendErrorMessage(player, e.getMessage());
            return false;
        }
        TriforceItem.completeWish(player);
        return true;
    }

    private static void processLifeWish(ServerPlayer player) {
        player.m_5634_(player.m_21233_());
        player.m_36324_().m_38705_(20);
        player.m_36324_().m_38717_(20.0f);
        player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 36000, 4));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 6000, 1));
        MagicMeterData.setMagicAmount((Player)player, MagicMeterData.getMaxMagic((Player)player));
    }

    private static void processExperienceWish(ServerPlayer player) {
        player.m_6756_(3000);
    }

    private static void processRepairWish(ServerPlayer player) {
        for (ItemStack itemStack : TriforceItem.getAllItemsToRepair(player)) {
            itemStack.m_41721_(0);
        }
        player.f_19853_.m_6269_(null, (Entity)player, SoundEvents.f_11671_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private static List<ItemStack> getAllItemsToRepair(ServerPlayer player) {
        ArrayList<ItemStack> itemsToRepair = new ArrayList<ItemStack>((Collection<ItemStack>)player.m_150109_().f_35974_);
        for (ItemStack itemStack : player.m_6167_()) {
            itemsToRepair.add(itemStack);
        }
        for (ItemStack itemStack : player.m_6168_()) {
            itemsToRepair.add(itemStack);
        }
        return itemsToRepair;
    }

    private static void processUpgradeFightersShieldWish(ServerPlayer player) {
        ItemStack fightersShield = TriforceItem.getRequiredItem(player, (Item)ModItems.FIGHTERS_SHIELD.get());
        ItemStack mirrorShieldALttP = new ItemStack((ItemLike)ModItems.MIRROR_SHIELD_ALTTP.get());
        mirrorShieldALttP.m_41751_(fightersShield.m_41783_());
        fightersShield.m_41774_(1);
        if (!player.m_36356_(mirrorShieldALttP)) {
            player.f_19853_.m_7967_((Entity)new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_(), mirrorShieldALttP));
        }
    }

    private static void processUpgradeHylianShieldWish(ServerPlayer player) {
        ItemStack hylianShield = TriforceItem.getRequiredItem(player, (Item)ModItems.HYLIANSHIELD.get());
        ItemStack mirrorShieldOoT = new ItemStack((ItemLike)ModItems.MIRROR_SHIELD_OOT.get());
        mirrorShieldOoT.m_41751_(hylianShield.m_41783_());
        hylianShield.m_41774_(1);
        if (!player.m_36356_(mirrorShieldOoT)) {
            player.f_19853_.m_7967_((Entity)new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_(), mirrorShieldOoT));
        }
    }

    private static void processHalfMagicCostWish(ServerPlayer player) {
        if (MagicMeterData.getMaxMagic((Player)player) >= 200) {
            throw new WishProcessingException("message.mastersword.magic_cost_already_halved");
        }
        MagicMeterData.setMaxMagic((Player)player, 200);
        MagicMeterData.setMagicAmount((Player)player, 200);
        MagicMeterData.setWhenNeededRenderTimer((Player)player, 200);
    }

    private static ItemStack getRequiredItem(ServerPlayer player, Item requiredItem) {
        for (ItemStack itemStack : player.m_150109_().f_35974_) {
            if (itemStack.m_41720_() != requiredItem) continue;
            return itemStack;
        }
        for (ItemStack itemStack : player.m_6167_()) {
            if (itemStack.m_41720_() != requiredItem) continue;
            return itemStack;
        }
        throw new WishProcessingException("message.mastersword.wish_item_not_found");
    }

    private static boolean hasTriforce(ServerPlayer player) {
        return TriforceItem.getTriforceItem(player) != null;
    }

    private static ItemStack getTriforceItem(ServerPlayer player) {
        for (ItemStack itemStack : player.m_150109_().f_35974_) {
            if (!(itemStack.m_41720_() instanceof TriforceItem)) continue;
            return itemStack;
        }
        return null;
    }

    private static void completeWish(ServerPlayer player) {
        player.f_19853_.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.FANFARE_ITEM.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        ItemStack triforceItem = TriforceItem.getTriforceItem(player);
        if (triforceItem != null) {
            player.m_150109_().m_36022_(stack -> stack == triforceItem, 1, (Container)player.f_36095_.m_39730_());
        }
        TriforceItem.sendSuccessMessage(player, "message.mastersword.granted");
    }

    private static void sendErrorMessage(ServerPlayer player, String messageKey) {
        player.m_213846_((Component)Component.m_237115_((String)messageKey).m_130940_(ChatFormatting.RED));
    }

    private static void sendSuccessMessage(ServerPlayer player, String messageKey) {
        player.m_213846_((Component)Component.m_237115_((String)messageKey).m_130940_(ChatFormatting.GOLD));
    }

    public boolean m_5812_(ItemStack pStack) {
        CompoundTag nbt = pStack.m_41783_();
        return nbt != null && nbt.m_128471_(OWNER_FLAG_KEY);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (!pLevel.f_46443_ && pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            this.openWishSelection((Player)serverPlayer);
        }
        return InteractionResultHolder.m_19090_((Object)pPlayer.m_21120_(pUsedHand));
    }

    private void openWishSelection(Player player) {
        player.m_213846_((Component)Component.m_237115_((String)"message.mastersword.select_wish"));
        MutableComponent lifeOption = Component.m_237115_((String)"message.mastersword.life_wish1").m_130938_(style -> style.m_131140_(ChatFormatting.DARK_RED).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/triforce_wish 1")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"message.mastersword.life_wish2"))));
        MutableComponent xpOption = Component.m_237115_((String)"message.mastersword.xp_wish1").m_130938_(style -> style.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/triforce_wish 2")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"message.mastersword.xp_wish2"))));
        MutableComponent repairOption = Component.m_237115_((String)"message.mastersword.repair_wish1").m_130938_(style -> style.m_131140_(ChatFormatting.YELLOW).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/triforce_wish 3")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"message.mastersword.repair_wish2"))));
        MutableComponent fightersShieldOption = Component.m_237115_((String)"message.mastersword.fighters_shield_wish1").m_130938_(style -> style.m_131140_(ChatFormatting.GOLD).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/triforce_wish 4")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"message.mastersword.fighters_shield_wish2"))));
        MutableComponent hylianShieldOption = Component.m_237115_((String)"message.mastersword.hylian_shield_wish1").m_130938_(style -> style.m_131140_(ChatFormatting.GRAY).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/triforce_wish 5")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"message.mastersword.hylian_shield_wish2"))));
        MutableComponent halfMagicCostOption = Component.m_237115_((String)"message.mastersword.half_magic_cost_wish1").m_130938_(style -> style.m_131140_(ChatFormatting.DARK_GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/triforce_wish 6")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"message.mastersword.half_magic_cost_wish2"))));
        player.m_213846_((Component)lifeOption);
        player.m_213846_((Component)xpOption);
        player.m_213846_((Component)repairOption);
        player.m_213846_((Component)fightersShieldOption);
        player.m_213846_((Component)hylianShieldOption);
        player.m_213846_((Component)halfMagicCostOption);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            boolean hasTemperedMasterSword = false;
            for (ItemStack itemStack : player.m_150109_().f_35974_) {
                if (!(itemStack.m_41720_() instanceof TemperedMasterSwordItem)) continue;
                hasTemperedMasterSword = true;
                break;
            }
            CompoundTag nbt = stack.m_41784_();
            nbt.m_128379_(OWNER_FLAG_KEY, hasTemperedMasterSword);
        }
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        CompoundTag nbt = pStack.m_41783_();
        boolean hasTemperedMasterSword = nbt != null && nbt.m_128471_(OWNER_FLAG_KEY);
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mastersword.triforce.tooltip1").m_130940_(ChatFormatting.ITALIC));
        if (hasTemperedMasterSword) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mastersword.triforce.tooltip2").m_130940_(ChatFormatting.ITALIC));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mastersword.triforce.tooltip3").m_130940_(ChatFormatting.ITALIC));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public MutableComponent getName(ItemStack stack) {
        MutableComponent itemName = (MutableComponent)super.m_7626_(stack);
        return itemName.m_130940_(ChatFormatting.GOLD);
    }

    private static class WishProcessingException
    extends RuntimeException {
        public WishProcessingException(String message) {
            super(message);
        }
    }
}

