/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.network.packet;

import java.util.function.Supplier;
import net.mezimaru.mastersword.client.MagicMeterData;
import net.mezimaru.mastersword.config.MasterSwordCommonConfigs;
import net.mezimaru.mastersword.entity.custom.SwordBeamProjectileEntity;
import net.mezimaru.mastersword.events.MagicMeterEvents;
import net.mezimaru.mastersword.item.custom.CustomSwordItem;
import net.mezimaru.mastersword.item.custom.FierceDeitySwordItem;
import net.mezimaru.mastersword.item.custom.GoldenMasterSwordItem;
import net.mezimaru.mastersword.item.custom.MasterSwordItem;
import net.mezimaru.mastersword.item.custom.TemperedMasterSwordItem;
import net.mezimaru.mastersword.item.custom.TrueMasterSwordItem;
import net.mezimaru.mastersword.sound.ModSounds;
import net.mezimaru.mastersword.util.AbilityCapability;
import net.mezimaru.mastersword.util.AbilityCapabilityProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class ShootSwordBeamC2SPacket {
    public ShootSwordBeamC2SPacket() {
    }

    public ShootSwordBeamC2SPacket(FriendlyByteBuf buf) {
    }

    private static void shootSwordBeam(Player player, Level level) {
        CompoundTag persistTag;
        SwordBeamProjectileEntity swordBeam = new SwordBeamProjectileEntity((LivingEntity)player, level);
        CompoundTag tag = player.getPersistentData();
        if (!tag.m_128441_("PlayerPersisted")) {
            tag.m_128365_("PlayerPersisted", (Tag)new CompoundTag());
        }
        if ((persistTag = tag.m_128469_("PlayerPersisted")).m_128471_("hasPetFairy") && (persistTag.m_128461_("fairyType").equals("ciela") || persistTag.m_128461_("fairyType").equals("golden"))) {
            level.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.BEAM_SLASH.get(), SoundSource.PLAYERS, 8.0f, 1.0f);
            level.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.SWORD_BEAM2.get(), SoundSource.PLAYERS, 0.6f, 1.0f);
            swordBeam.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 2.0f, 1.0f);
        } else {
            level.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.BEAM_SLASH.get(), SoundSource.PLAYERS, 0.7f, 1.0f);
            level.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.SWORD_BEAM1.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
            swordBeam.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f);
        }
        level.m_7967_((Entity)swordBeam);
    }

    private static void handleSwordBeam(ServerPlayer player) {
        ItemStack itemStack = player.m_21120_(InteractionHand.MAIN_HAND);
        Item item = itemStack.m_41720_();
        if (!(item instanceof CustomSwordItem)) {
            return;
        }
        CustomSwordItem sword = (CustomSwordItem)item;
        AbilityCapability abilityCapability = (AbilityCapability)player.getCapability(AbilityCapabilityProvider.ABILITY_CAPABILITY).orElse(null);
        if (abilityCapability == null || abilityCapability.isSwordBeamOnCooldown()) {
            return;
        }
        int magicCost = (Integer)MasterSwordCommonConfigs.FIERCE_DEITY_SWORD_BEAM_MAGIC_COST.get();
        if (sword instanceof FierceDeitySwordItem) {
            if (player.m_7500_() || MagicMeterData.getMagicAmount((Player)player) >= magicCost) {
                ShootSwordBeamC2SPacket.shootSwordBeam((Player)player, player.f_19853_);
                abilityCapability.setSwordBeamCooldownTicks(ShootSwordBeamC2SPacket.getCooldownForSword(sword));
                if (!player.m_7500_()) {
                    MagicMeterEvents.removeMagic(magicCost, player);
                }
            }
        } else if (player.m_21223_() == player.m_21233_()) {
            ShootSwordBeamC2SPacket.shootSwordBeam((Player)player, player.f_19853_);
            abilityCapability.setSwordBeamCooldownTicks(ShootSwordBeamC2SPacket.getCooldownForSword(sword));
        }
    }

    private static int getCooldownForSword(CustomSwordItem sword) {
        if (sword instanceof TrueMasterSwordItem) {
            return (Integer)MasterSwordCommonConfigs.TRUE_MASTER_SWORD_BEAM_COOLDOWN.get();
        }
        if (sword instanceof FierceDeitySwordItem) {
            return (Integer)MasterSwordCommonConfigs.FIERCE_DEITY_SWORD_BEAM_COOLDOWN.get();
        }
        if (sword instanceof GoldenMasterSwordItem) {
            return (Integer)MasterSwordCommonConfigs.GOLDEN_MASTER_SWORD_BEAM_COOLDOWN.get();
        }
        if (sword instanceof TemperedMasterSwordItem) {
            return (Integer)MasterSwordCommonConfigs.TEMPERED_MASTER_SWORD_BEAM_COOLDOWN.get();
        }
        if (sword instanceof MasterSwordItem) {
            return (Integer)MasterSwordCommonConfigs.MASTER_SWORD_BEAM_COOLDOWN.get();
        }
        return 148;
    }

    public void toBytes(FriendlyByteBuf buf) {
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                ShootSwordBeamC2SPacket.handleSwordBeam(player);
            }
        });
        context.setPacketHandled(true);
    }
}

