/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.network.packet;

import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class SpinAttackAnimationS2CPacket {
    private final int usingPlayer;

    public SpinAttackAnimationS2CPacket(int usingPlayer) {
        this.usingPlayer = usingPlayer;
    }

    public SpinAttackAnimationS2CPacket(FriendlyByteBuf buf) {
        this.usingPlayer = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.usingPlayer);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Entity clientPlayer = Minecraft.m_91087_().f_91073_.m_6815_(this.usingPlayer);
            if (clientPlayer == null) {
                return;
            }
            ModifierLayer animation = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)((AbstractClientPlayer)clientPlayer)).get(new ResourceLocation("mastersword", "spin_attack"));
            if (animation != null) {
                animation.setAnimation((IAnimation)new KeyframeAnimationPlayer(Objects.requireNonNull(PlayerAnimationRegistry.getAnimation((ResourceLocation)new ResourceLocation("mastersword", "spin_attack")))).setFirstPersonMode(FirstPersonMode.THIRD_PERSON_MODEL));
            }
        }));
        context.setPacketHandled(true);
    }
}

