/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.util;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import java.util.Set;
import net.mezimaru.mastersword.entity.ModEntities;
import net.mezimaru.mastersword.events.PetFairyEvents;
import net.mezimaru.mastersword.util.SupporterAccess;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;

public class SupporterFairyCommand {
    private static final Set<String> VALID_SUPPORTER_FAIRIES = Set.of("sheikah");
    private static final Map<String, EntityType<?>> FAIRY_TYPES = Map.of("sheikah", (EntityType)ModEntities.SHEIKAH_FAIRY.get());

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"supporterfairy").requires(source -> source.m_81373_() instanceof ServerPlayer)).then(Commands.m_82127_((String)"register").then(Commands.m_82129_((String)"token", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String token;
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            boolean success = SupporterAccess.registerPlayerToken(player, token = StringArgumentType.getString((CommandContext)ctx, (String)"token"));
            if (success) {
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\u2705 Token registered successfully."), false);
                return 1;
            }
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"\u274c Invalid token."));
            return 0;
        })))).then(Commands.m_82127_((String)"summon").then(Commands.m_82129_((String)"fairy", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            for (String fairy : VALID_SUPPORTER_FAIRIES) {
                builder.suggest(fairy);
            }
            return builder.buildFuture();
        }).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            String fairyType = StringArgumentType.getString((CommandContext)ctx, (String)"fairy").toLowerCase();
            return SupporterFairyCommand.executeSummon((CommandSourceStack)ctx.getSource(), player, fairyType);
        })))).then(Commands.m_82127_((String)"dismiss").executes(context -> SupporterFairyCommand.executeRemove((CommandSourceStack)context.getSource())));
    }

    private static int executeSummon(CommandSourceStack source, ServerPlayer player, String fairyType) {
        if (!VALID_SUPPORTER_FAIRIES.contains(fairyType)) {
            source.m_81352_((Component)Component.m_237113_((String)("\u274c Invalid fairy type. Valid types: " + String.join((CharSequence)", ", VALID_SUPPORTER_FAIRIES))));
            return 0;
        }
        if (!SupporterAccess.isSupporter(player.m_20148_())) {
            source.m_81352_((Component)Component.m_237113_((String)"\u274c You are not a verified supporter."));
            return 0;
        }
        CompoundTag tag = PetFairyEvents.getOrCreatePersistentTag((Player)player);
        if (tag.m_128471_("hasPetFairy")) {
            source.m_81352_((Component)Component.m_237113_((String)"\u274c You already have a fairy."));
            return 0;
        }
        EntityType<?> type = FAIRY_TYPES.get(fairyType);
        if (type == null) {
            source.m_81352_((Component)Component.m_237113_((String)"\u274c Could not resolve fairy entity type."));
            return 0;
        }
        PetFairyEvents.createPetFairy((Player)player, player.m_9236_(), fairyType);
        tag.m_128379_("hasPetFairy", true);
        tag.m_128359_("fairyType", fairyType);
        source.m_288197_(() -> Component.m_237113_((String)("\u2728 Your supporter fairy has been summoned! (" + fairyType + ")")), false);
        return 1;
    }

    private static int executeRemove(CommandSourceStack source) {
        Entity entity = source.m_81373_();
        if (!(entity instanceof ServerPlayer)) {
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (!SupporterAccess.isSupporter(player.m_20148_())) {
            source.m_81352_((Component)Component.m_237113_((String)"\u274c You are not a verified supporter."));
            return 0;
        }
        CompoundTag tag = PetFairyEvents.getOrCreatePersistentTag((Player)player);
        if (!tag.m_128471_("hasPetFairy")) {
            source.m_81352_((Component)Component.m_237113_((String)"\u274c You do not have a supporter fairy to dismiss."));
            return 0;
        }
        String fairyType = tag.m_128461_("fairyType");
        if (!VALID_SUPPORTER_FAIRIES.contains(fairyType)) {
            source.m_81352_((Component)Component.m_237113_((String)"\u274c You do not have a supporter fairy to dismiss."));
            return 0;
        }
        PetFairyEvents.removePetFairy((Player)player, player.m_9236_());
        tag.m_128473_("hasPetFairy");
        tag.m_128473_("fairyType");
        source.m_288197_(() -> Component.m_237113_((String)"\u274c Your supporter fairy has been dismissed."), false);
        return 1;
    }
}

