/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.block.entity;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.mezimaru.mastersword.block.entity.ModBlockEntities;
import net.mezimaru.mastersword.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class ShopMusicBlockEntity
extends BlockEntity {
    private static final int SONG_DURATION = 2650;
    public final AABB shopBoundingBox;
    public final Set<UUID> playersWhoHeardSong = new HashSet<UUID>();
    public int shopTickCounter = 0;
    public boolean isPlaying = false;

    public ShopMusicBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.SHOP_MUSIC_BLOCK_ENTITY.get(), pos, state);
        this.shopBoundingBox = new AABB(pos).m_82400_(40.0);
    }

    public void tick() {
        if (!this.f_58857_.f_46443_ && this.f_58857_.m_46805_(this.f_58858_)) {
            List playersInRange = this.f_58857_.m_45976_(ServerPlayer.class, this.shopBoundingBox);
            if (!this.isPlaying && !playersInRange.isEmpty()) {
                this.shopTickCounter = 0;
                this.isPlaying = true;
                for (ServerPlayer player : playersInRange) {
                    this.playSongFor(player);
                    this.playersWhoHeardSong.add(player.m_20148_());
                }
            }
            if (this.isPlaying) {
                ++this.shopTickCounter;
                for (ServerPlayer player : playersInRange) {
                    if (this.playersWhoHeardSong.contains(player.m_20148_())) continue;
                    this.playSongFor(player);
                    this.playersWhoHeardSong.add(player.m_20148_());
                }
                if (this.shopTickCounter >= 2650) {
                    this.shopTickCounter = 0;
                    this.isPlaying = false;
                    this.playersWhoHeardSong.clear();
                }
            }
        }
    }

    private void playSongFor(ServerPlayer player) {
        player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)((SoundEvent)ModSounds.SHOP.get())), SoundSource.RECORDS, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, 0.4f, 1.0f, player.m_217043_().m_188505_()));
    }
}

