/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.entity.custom;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.mezimaru.mastersword.item.ModItems;
import net.mezimaru.mastersword.sound.ModSounds;
import net.mezimaru.mastersword.util.ParticleHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GreatFairyEntity
extends PathfinderMob
implements GeoEntity {
    private static final Set<UUID> SPECIAL_PLAYER_UUIDS = Set.of(UUID.fromString("f9519917-3d16-4009-ac01-3ec094f75ead"), UUID.fromString("805d0828-15f0-4e83-8c5d-2687a0aa2074"));
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Map<Item, UpgradeFunction> upgradeMap;
    private final Set<Item> processedItems = new HashSet<Item>();
    private UUID targetPlayerUUID;
    private Map<UUID, List<ItemEntity>> thrownItemsPerPlayer;
    private int tickCounter = 0;
    private boolean playedLaughSound = false;

    public GreatFairyEntity(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.upgradeMap = new HashMap<Item, UpgradeFunction>();
        this.upgradeMap.put((Item)ModItems.OLD_RUSTY_SHIELD.get(), this::upgradeToFighterShield);
        this.upgradeMap.put((Item)ModItems.BOOMERANG.get(), this::upgradeToMagicBoomerang);
        this.upgradeMap.put((Item)ModItems.MAGIC_LANTERN.get(), this::upgradeToFairyLantern);
        this.upgradeMap.put((Item)ModItems.HYLIAN_BOTTLE.get(), this::upgradeToGreenPotion);
    }

    public static AttributeSupplier setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22283_, 3.0).m_22265_();
    }

    private void upgradeToFighterShield(Player targetPlayer, ItemStack oldShields) {
        this.spawnAndUpgradeItem(targetPlayer, oldShields, (Item)ModItems.FIGHTERS_SHIELD.get());
    }

    private void upgradeToMagicBoomerang(Player targetPlayer, ItemStack oldBoomerangs) {
        this.spawnAndUpgradeItem(targetPlayer, oldBoomerangs, (Item)ModItems.MAGIC_BOOMERANG.get());
    }

    private void upgradeToFairyLantern(Player targetPlayer, ItemStack magicLanterns) {
        if (SPECIAL_PLAYER_UUIDS.contains(targetPlayer.m_20148_())) {
            MutableComponent message = Component.m_237110_((String)"message.great_fairy.special_player.ozen_lantern", (Object[])new Object[]{targetPlayer.m_7755_()}).m_130940_(ChatFormatting.GOLD);
            targetPlayer.m_213846_((Component)message);
            this.spawnAndUpgradeItem(targetPlayer, magicLanterns, (Item)ModItems.OZEN_LANTERN.get());
        } else {
            this.spawnAndUpgradeItem(targetPlayer, magicLanterns, (Item)ModItems.FAIRY_LANTERN.get());
        }
    }

    private void upgradeToGreenPotion(Player targetPlayer, ItemStack hylianBottles) {
        this.spawnAndUpgradeItem(targetPlayer, hylianBottles, (Item)ModItems.GREEN_POTION.get());
    }

    public void setThrownItems(Map<UUID, List<ItemEntity>> thrownItemsPerPlayer) {
        this.thrownItemsPerPlayer = thrownItemsPerPlayer;
    }

    public boolean m_20068_() {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.setFairyRotationToTosser(this, serverLevel);
            }
            if (this.tickCounter == 0) {
                this.spawnParticles(true);
            }
            if (this.tickCounter == 60) {
                this.processAllItems();
                if (!this.playedLaughSound) {
                    this.f_19853_.m_6269_(null, (Entity)this, (SoundEvent)ModSounds.GREAT_FAIRY_LAUGH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    this.playedLaughSound = true;
                }
            }
            if (this.tickCounter >= 100) {
                this.spawnParticles(false);
                this.processedItems.clear();
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            ++this.tickCounter;
        }
    }

    private void setFairyRotationToTosser(GreatFairyEntity fairy, ServerLevel level) {
        Player targetPlayer = null;
        double closestDistance = Double.MAX_VALUE;
        for (UUID playerUUID : this.thrownItemsPerPlayer.keySet()) {
            double distance;
            Player player = level.m_46003_(playerUUID);
            if (player == null || !((distance = (double)fairy.m_20270_((Entity)player)) < closestDistance)) continue;
            closestDistance = distance;
            targetPlayer = player;
        }
        if (targetPlayer != null) {
            Vec3 fairyPosition = fairy.m_20182_();
            Vec3 playerPosition = targetPlayer.m_20182_();
            double deltaX = playerPosition.f_82479_ - fairyPosition.f_82479_;
            double deltaZ = playerPosition.f_82481_ - fairyPosition.f_82481_;
            float yaw = (float)(Math.atan2(deltaZ, deltaX) * 57.29577951308232) - 90.0f;
            float pitch = (float)Math.toDegrees(Math.atan2(playerPosition.f_82480_ - fairyPosition.f_82480_, Math.sqrt(deltaX * deltaX + deltaZ * deltaZ)));
            fairy.m_146922_(yaw);
            fairy.m_146926_(-pitch);
        }
    }

    private void processAllItems() {
        for (Map.Entry<UUID, List<ItemEntity>> entry : this.thrownItemsPerPlayer.entrySet()) {
            UUID playerUUID = entry.getKey();
            Player targetPlayer = this.f_19853_.m_46003_(playerUUID);
            if (targetPlayer == null) continue;
            HashMap<Item, Integer> itemCounts = new HashMap<Item, Integer>();
            for (ItemEntity itemEntity : entry.getValue()) {
                ItemStack stack = itemEntity.m_32055_();
                itemCounts.merge(stack.m_41720_(), stack.m_41613_(), Integer::sum);
            }
            for (Map.Entry entry2 : itemCounts.entrySet()) {
                this.processItemBatch((Item)entry2.getKey(), (Integer)entry2.getValue(), targetPlayer);
            }
        }
        this.thrownItemsPerPlayer.clear();
    }

    private void processItemBatch(Item item, int count, Player targetPlayer) {
        UpgradeFunction upgradeFunction = this.upgradeMap.get(item);
        if (upgradeFunction != null) {
            upgradeFunction.upgrade(targetPlayer, new ItemStack((ItemLike)item, count));
        }
    }

    private void spawnAndUpgradeItem(Player targetPlayer, ItemStack oldItems, Item newItemType) {
        int count = oldItems.m_41613_();
        for (int i = 0; i < count; ++i) {
            ItemStack newItem = new ItemStack((ItemLike)newItemType, 1);
            CompoundTag oldNBT = oldItems.m_41783_();
            if (oldNBT != null) {
                newItem.m_41751_(oldNBT.m_6426_());
            }
            Vec3 playerLookVector = targetPlayer.m_20154_();
            Vec3 spawnPosition = targetPlayer.m_146892_().m_82520_(playerLookVector.f_82479_ * 1.5, playerLookVector.f_82480_ * 1.5 - 0.5, playerLookVector.f_82481_ * 1.5);
            if (count > 1) {
                spawnPosition = spawnPosition.m_82520_((Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5);
            }
            ItemEntity itemEntity = new ItemEntity(this.f_19853_, spawnPosition.f_82479_, spawnPosition.f_82480_, spawnPosition.f_82481_, newItem);
            itemEntity.m_20334_(0.0, 0.2, 0.0);
            this.spawnUpgradeItemParticles(spawnPosition);
            this.f_19853_.m_7967_((Entity)itemEntity);
        }
    }

    private void spawnParticles(boolean isLargeBurst) {
        int particleCount = isLargeBurst ? 50 : 20;
        double radius = isLargeBurst ? 1.0 : 0.5;
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particleCount;
            double x = this.m_20185_() + radius * Math.cos(angle);
            double y = this.m_20186_() + 1.0;
            double z = this.m_20189_() + radius * Math.sin(angle);
            ParticleHelper.spawnParticle(this.f_19853_, (ParticleOptions)ParticleTypes.f_123810_, x, y, z, 1.0, 0.0, 0.0);
        }
    }

    private void spawnUpgradeItemParticles(Vec3 position) {
        int particleCount = 20;
        double radius = 0.5;
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particleCount;
            double x = position.f_82479_ + radius * Math.cos(angle);
            double y = position.f_82480_ + 1.0;
            double z = position.f_82481_ + radius * Math.sin(angle);
            ParticleHelper.spawnParticle(this.f_19853_, (ParticleOptions)ParticleTypes.f_123810_, x, y, z, 1.0, 0.0, 0.0);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("TargetPlayerUUID")) {
            this.targetPlayerUUID = compound.m_128342_("TargetPlayerUUID");
        }
        this.tickCounter = compound.m_128451_("TickCounter");
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.targetPlayerUUID != null) {
            compound.m_128362_("TargetPlayerUUID", this.targetPlayerUUID);
        }
        compound.m_128405_("TickCounter", this.tickCounter);
    }

    public boolean m_6779_(LivingEntity pTarget) {
        return false;
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    protected boolean m_7341_(Entity pVehicle) {
        return false;
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_271807_() {
        return false;
    }

    public boolean m_20039_(BlockPos pPos, BlockState pState) {
        return false;
    }

    public boolean m_7337_(Entity pEntity) {
        return false;
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    public boolean m_142066_() {
        return false;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_19390_() || pSource == this.m_269291_().m_287172_()) {
            return super.m_6469_(pSource, pAmount);
        }
        return false;
    }

    public int m_213860_() {
        return 0;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity p_20971_) {
    }

    protected AABB m_142242_() {
        AABB originalBox = super.m_142242_();
        return new AABB(originalBox.f_82288_, originalBox.f_82289_ + 0.5, originalBox.f_82290_, originalBox.f_82291_, originalBox.f_82292_ + 0.5, originalBox.f_82293_);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        tAnimationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @FunctionalInterface
    private static interface UpgradeFunction {
        public void upgrade(Player var1, ItemStack var2);
    }
}

