/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.entity.custom;

import java.util.List;
import net.mezimaru.mastersword.entity.custom.BasePetFairyEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.storage.LevelData;

public class TatlFairyEntity
extends BasePetFairyEntity {
    private int glowEffectTickCounter = 0;

    public TatlFairyEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.m_7105_(true);
    }

    public static boolean canTatlSpawn(EntityType<TatlFairyEntity> entityType, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return pRandom.m_188503_(10) == 0 && TatlFairyEntity.isRainingOrStorming(pLevel);
    }

    private static boolean isRainingOrStorming(LevelAccessor level) {
        LevelData leveldata = level.m_6106_();
        boolean isRainingOrStorming = leveldata.m_6533_() || leveldata.m_6534_();
        return isRainingOrStorming;
    }

    @Override
    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(2, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.1, 5.0f, 1.0f, true));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 0.8));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_269323_() != null) {
            ++this.glowEffectTickCounter;
            if (this.glowEffectTickCounter >= 60) {
                this.applyGlowEffectToNearbyEnemies();
                this.glowEffectTickCounter = 0;
            }
        }
    }

    private void applyGlowEffectToNearbyEnemies() {
        List nearbyEnemies = this.f_19853_.m_45976_(Monster.class, this.m_20191_().m_82400_(10.0));
        if (!nearbyEnemies.isEmpty()) {
            for (Monster enemy : nearbyEnemies) {
                enemy.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 70, 0, false, false));
            }
            nearbyEnemies.clear();
        }
    }
}

