/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.events;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.mezimaru.mastersword.client.MagicMeterData;
import net.mezimaru.mastersword.entity.ModEntities;
import net.mezimaru.mastersword.entity.custom.BasePetFairyEntity;
import net.mezimaru.mastersword.events.MagicMeterEvents;
import net.mezimaru.mastersword.item.ModItems;
import net.mezimaru.mastersword.sound.ModSounds;
import net.mezimaru.mastersword.util.ParticleHelper;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mastersword")
public class PetFairyEvents {
    private static final Map<UUID, Long> lastMessageTime = new HashMap<UUID, Long>();
    private static final Map<UUID, Long> lastSoundTime = new HashMap<UUID, Long>();
    private static final long COOLDOWN_TIME_MS = 180000L;

    public static CompoundTag getOrCreatePersistentTag(Player player) {
        CompoundTag tag = player.getPersistentData();
        if (!tag.m_128441_("PlayerPersisted")) {
            tag.m_128365_("PlayerPersisted", (Tag)new CompoundTag());
        }
        return tag.m_128469_("PlayerPersisted");
    }

    public static void createPetFairy(Player player, Level level, String fairyType) {
        if (!level.f_46443_) {
            CompoundTag persistTag = PetFairyEvents.getOrCreatePersistentTag(player);
            BasePetFairyEntity petFairy = null;
            switch (fairyType) {
                case "navi": {
                    petFairy = (BasePetFairyEntity)((EntityType)ModEntities.NAVI.get()).m_20615_(level);
                    break;
                }
                case "tatl": {
                    petFairy = (BasePetFairyEntity)((EntityType)ModEntities.TATL.get()).m_20615_(level);
                    break;
                }
                case "tael": {
                    petFairy = (BasePetFairyEntity)((EntityType)ModEntities.TAEL.get()).m_20615_(level);
                    break;
                }
                case "ciela": {
                    petFairy = (BasePetFairyEntity)((EntityType)ModEntities.CIELA.get()).m_20615_(level);
                    break;
                }
                case "leaf": {
                    petFairy = (BasePetFairyEntity)((EntityType)ModEntities.LEAF.get()).m_20615_(level);
                    break;
                }
                case "neri": {
                    petFairy = (BasePetFairyEntity)((EntityType)ModEntities.NERI.get()).m_20615_(level);
                    break;
                }
                case "white": {
                    petFairy = (BasePetFairyEntity)((EntityType)ModEntities.WHITE_FAIRY.get()).m_20615_(level);
                    break;
                }
                case "gray": {
                    petFairy = (BasePetFairyEntity)((EntityType)ModEntities.GRAY_FAIRY.get()).m_20615_(level);
                    break;
                }
                case "black": {
                    petFairy = (BasePetFairyEntity)((EntityType)ModEntities.BLACK_FAIRY.get()).m_20615_(level);
                    break;
                }
                case "orange": {
                    petFairy = (BasePetFairyEntity)((EntityType)ModEntities.ORANGE_FAIRY.get()).m_20615_(level);
                    break;
                }
                case "lime": {
                    petFairy = (BasePetFairyEntity)((EntityType)ModEntities.LIME_FAIRY.get()).m_20615_(level);
                    break;
                }
                case "green": {
                    petFairy = (BasePetFairyEntity)((EntityType)ModEntities.GREEN_FAIRY.get()).m_20615_(level);
                    break;
                }
                case "cyan": {
                    petFairy = (BasePetFairyEntity)((EntityType)ModEntities.CYAN_FAIRY.get()).m_20615_(level);
                    break;
                }
                case "purple": {
                    petFairy = (BasePetFairyEntity)((EntityType)ModEntities.PURPLE_FAIRY.get()).m_20615_(level);
                    break;
                }
                case "magenta": {
                    petFairy = (BasePetFairyEntity)((EntityType)ModEntities.MAGENTA_FAIRY.get()).m_20615_(level);
                    break;
                }
                case "brown": {
                    petFairy = (BasePetFairyEntity)((EntityType)ModEntities.BROWN_FAIRY.get()).m_20615_(level);
                    break;
                }
                case "golden": {
                    petFairy = (BasePetFairyEntity)((EntityType)ModEntities.GOLDEN_FAIRY.get()).m_20615_(level);
                    break;
                }
                case "dark": {
                    petFairy = (BasePetFairyEntity)((EntityType)ModEntities.DARK_FAIRY.get()).m_20615_(level);
                    break;
                }
                case "sheikah": {
                    petFairy = (BasePetFairyEntity)((EntityType)ModEntities.SHEIKAH_FAIRY.get()).m_20615_(level);
                    break;
                }
                default: {
                    petFairy = (BasePetFairyEntity)((EntityType)ModEntities.CYAN_FAIRY.get()).m_20615_(level);
                }
            }
            if (petFairy != null) {
                petFairy.m_21816_(player.m_20148_());
                petFairy.m_6034_(player.m_20185_() + 0.5, player.m_20186_() + 0.5, player.m_20189_() + 0.5);
                level.m_7967_((Entity)petFairy);
                persistTag.m_128362_("petFairyUUID", petFairy.m_20148_());
                persistTag.m_128379_("hasPetFairy", true);
                persistTag.m_128359_("fairyType", fairyType);
                level.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.PET_FAIRY_SPAWN.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
    }

    public static void removePetFairy(Player player, Level level) {
        if (!level.f_46443_) {
            CompoundTag persistTag = PetFairyEvents.getOrCreatePersistentTag(player);
            UUID playerUUID = player.m_20148_();
            if (persistTag.m_128441_("petFairyUUID")) {
                ServerLevel serverLevel = (ServerLevel)level;
                LevelEntityGetter entityGetter = serverLevel.m_142646_();
                Iterable entities = entityGetter.m_142273_();
                for (Entity entity : entities) {
                    BasePetFairyEntity petFairyEntity;
                    if (!(entity instanceof BasePetFairyEntity) || (petFairyEntity = (BasePetFairyEntity)entity).m_21805_() == null || !petFairyEntity.m_21805_().equals(playerUUID)) continue;
                    petFairyEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                }
                persistTag.m_128473_("petFairyUUID");
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Level level = event.getEntity().f_19853_;
        Player player = event.getEntity();
        PetFairyEvents.removePetFairy(player, level);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Level level = event.getEntity().f_19853_;
        Player player = event.getEntity();
        CompoundTag persistTag = PetFairyEvents.getOrCreatePersistentTag(player);
        persistTag.m_128405_("neriCoolDown", 6000);
        PetFairyEvents.checkIfShouldHavePetFairy(player, level);
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        MinecraftServer server = event.getServer();
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            Level level = player.f_19853_;
            PetFairyEvents.removePetFairy((Player)player, level);
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            Level level = event.getEntity().f_19853_;
            PetFairyEvents.removePetFairy(player, level);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Level level = event.getEntity().f_19853_;
        Player player = event.getEntity();
        PetFairyEvents.checkIfShouldHavePetFairy(player, level);
    }

    public static void checkIfShouldHavePetFairy(Player player, Level level) {
        CompoundTag persistTag = PetFairyEvents.getOrCreatePersistentTag(player);
        if (persistTag.m_128471_("hasPetFairy")) {
            String fairyType = persistTag.m_128461_("fairyType");
            PetFairyEvents.removePetFairy(player, level);
            PetFairyEvents.createPetFairy(player, level, fairyType);
        } else if (!persistTag.m_128471_("hasPetFairy")) {
            PetFairyEvents.removePetFairy(player, level);
        }
    }

    @SubscribeEvent
    public static void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        ResourceKey oldDimensionKey = event.getFrom();
        ResourceKey newDimensionKey = event.getTo();
        player.f_19853_.m_7654_().execute(() -> {
            ServerLevel oldLevel = player.f_19853_.m_7654_().m_129880_(oldDimensionKey);
            ServerLevel newLevel = player.f_19853_.m_7654_().m_129880_(newDimensionKey);
            PetFairyEvents.removePetFairy(player, (Level)oldLevel);
            PetFairyEvents.checkIfShouldHavePetFairy(player, (Level)newLevel);
        });
    }

    @SubscribeEvent
    public static void fairyMagicRegenEvent(TickEvent.PlayerTickEvent event) {
        CompoundTag persistTag;
        Player player = event.player;
        if (player != null && !player.f_19853_.f_46443_ && event.phase == TickEvent.Phase.END && (persistTag = PetFairyEvents.getOrCreatePersistentTag(player)).m_128471_("hasPetFairy") && persistTag.m_128461_("fairyType").equals("golden") && event.player.f_19797_ % 400 == 0) {
            MagicMeterEvents.addMagic(1, (ServerPlayer)player);
        }
    }

    @SubscribeEvent
    public static void onDarkFairyTwilightPactTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player == null || player.m_9236_().f_46443_ || event.phase != TickEvent.Phase.END) {
            return;
        }
        CompoundTag persistTag = MagicMeterEvents.getOrCreatePersistentTag(player);
        if (!persistTag.m_128471_("hasPetFairy")) {
            return;
        }
        if (!"dark".equals(persistTag.m_128461_("fairyType"))) {
            return;
        }
        if (player.f_19797_ % 100 != 0) {
            return;
        }
        if (player.m_21223_() >= player.m_21233_()) {
            return;
        }
        int magicCost = 5;
        int currentMagic = MagicMeterData.getMagicAmount(player);
        if (currentMagic < magicCost) {
            return;
        }
        float healAmount = 1.0f;
        MagicMeterEvents.removeMagic(magicCost, (ServerPlayer)player);
        player.m_5634_(healAmount);
        ServerLevel level = (ServerLevel)player.m_9236_();
        double px = player.m_20185_();
        double py = player.m_20186_() + 0.4;
        double pz = player.m_20189_();
        for (int i = 0; i < 8; ++i) {
            double offsetX = (level.f_46441_.m_188500_() - 0.5) * 0.8;
            double offsetY = (level.f_46441_.m_188500_() - 0.5) * 0.8;
            double offsetZ = (level.f_46441_.m_188500_() - 0.5) * 0.8;
            ParticleHelper.spawnParticle((Level)level, (ParticleOptions)ParticleTypes.f_123760_, px + offsetX, py + offsetY, pz + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    @SubscribeEvent
    public static void naviHintEvents(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player != null && !player.f_19853_.f_46443_ && event.phase == TickEvent.Phase.END) {
            ItemStack netherStar = new ItemStack((ItemLike)Items.f_42686_);
            ItemStack blessedNetherStar = new ItemStack((ItemLike)ModItems.BLESSED_NETHER_STAR.get());
            ItemStack bow = new ItemStack((ItemLike)Items.f_42411_);
            ItemStack healingFairy = new ItemStack((ItemLike)ModItems.HYLIAN_BOTTLE_HEALING_FAIRY.get());
            ItemStack temperedSword = new ItemStack((ItemLike)ModItems.TEMPEREDMASTERSWORD.get());
            ItemStack triforce = new ItemStack((ItemLike)ModItems.TRIFORCE.get());
            CompoundTag persistTag = PetFairyEvents.getOrCreatePersistentTag(player);
            if (persistTag.m_128471_("hasPetFairy") && persistTag.m_128461_("fairyType").equals("navi")) {
                UUID playerId = player.m_20148_();
                long currentTime = System.currentTimeMillis();
                if (!lastMessageTime.containsKey(playerId) || currentTime - lastMessageTime.get(playerId) >= 180000L) {
                    long lastSoundPlayTime;
                    boolean hintSent = false;
                    if (player.m_150109_().m_36063_(netherStar) && !PetFairyEvents.hasAdvancement((ServerPlayer)player, "mastersword:blessednetherstar")) {
                        player.m_213846_((Component)Component.m_237115_((String)"message.mastersword.navi_hint_nether_star"));
                        PetFairyEvents.updateLastMessageTime(player, currentTime);
                        hintSent = true;
                    }
                    if (player.m_150109_().m_36063_(blessedNetherStar) && !PetFairyEvents.hasAdvancement((ServerPlayer)player, "mastersword:truemastersword")) {
                        player.m_213846_((Component)Component.m_237115_((String)"message.mastersword.navi_hint_blessed_nether_star"));
                        PetFairyEvents.updateLastMessageTime(player, currentTime);
                        hintSent = true;
                    }
                    if (player.m_150109_().m_36063_(bow) && player.m_150109_().m_36063_(healingFairy) && !PetFairyEvents.hasAdvancement((ServerPlayer)player, "mastersword:fairybow")) {
                        player.m_213846_((Component)Component.m_237115_((String)"message.mastersword.navi_hint_fairy_bow"));
                        PetFairyEvents.updateLastMessageTime(player, currentTime);
                        hintSent = true;
                    }
                    if (player.m_150109_().m_36063_(temperedSword) && player.m_150109_().m_36063_(triforce) && !PetFairyEvents.hasAdvancement((ServerPlayer)player, "mastersword:goldenmastersword")) {
                        player.m_213846_((Component)Component.m_237115_((String)"message.mastersword.navi_hint_tempered_sword"));
                        PetFairyEvents.updateLastMessageTime(player, currentTime);
                        hintSent = true;
                    }
                    if (hintSent && currentTime - (lastSoundPlayTime = lastSoundTime.getOrDefault(playerId, 0L).longValue()) >= 180000L) {
                        PetFairyEvents.playNaviSound(player);
                        lastSoundTime.put(playerId, currentTime);
                    }
                }
            }
        }
    }

    private static void updateLastMessageTime(Player player, long currentTime) {
        UUID playerId = player.m_20148_();
        lastMessageTime.put(playerId, currentTime);
    }

    private static void playNaviSound(Player player) {
        Level level = player.f_19853_;
        float pitch = 0.8f + level.f_46441_.m_188501_() * 0.2f;
        level.m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.NAVI_LISTEN.get(), SoundSource.PLAYERS, 1.0f, pitch);
    }

    private static boolean hasAdvancement(ServerPlayer player, String advancementId) {
        Advancement advancement = player.f_8924_.m_129889_().m_136041_(new ResourceLocation(advancementId));
        if (advancement != null) {
            AdvancementProgress progress = player.m_8960_().m_135996_(advancement);
            return progress.m_8193_();
        }
        return false;
    }

    @SubscribeEvent
    public static void onOwnerHurtSheikahVanish(LivingHurtEvent event) {
        long nextAllowedTime;
        LivingEntity target = event.getEntity();
        if (!(target instanceof Player)) {
            return;
        }
        Player player = (Player)target;
        CompoundTag tag = PetFairyEvents.getOrCreatePersistentTag(player);
        if (!tag.m_128471_("hasPetFairy")) {
            return;
        }
        if (!"sheikah".equals(tag.m_128461_("fairyType"))) {
            return;
        }
        Entity source = event.getSource().m_7639_();
        if (!(source instanceof LivingEntity)) {
            return;
        }
        long currentTime = player.m_9236_().m_46467_();
        if (currentTime < (nextAllowedTime = tag.m_128454_("sheikahCooldown"))) {
            return;
        }
        event.setCanceled(true);
        int invisDuration = 100 + player.m_9236_().f_46441_.m_188503_(41);
        player.m_7292_(new MobEffectInstance(MobEffects.f_19609_, invisDuration, 0, false, false, true));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 60, 1, false, false, true));
        player.f_19853_.m_5594_(null, player.m_20097_(), SoundEvents.f_11953_, SoundSource.PLAYERS, 1.0f, 1.0f);
        double x = player.m_20185_();
        double y = player.m_20186_() + 1.0;
        double z = player.m_20189_();
        for (int i = 0; i < 80; ++i) {
            double ox = (Math.random() - 0.5) * 1.5;
            double oy = Math.random() * 0.5;
            double oz = (Math.random() - 0.5) * 1.5;
            int roll = player.f_19853_.f_46441_.m_188503_(10);
            SimpleParticleType particle = roll < 7 ? ParticleTypes.f_123777_ : (roll < 9 ? ParticleTypes.f_123810_ : ParticleTypes.f_123785_);
            ParticleHelper.spawnParticle(player.f_19853_, (ParticleOptions)particle, x + ox, y + oy, z + oz, 0.0, 0.01, 0.0);
        }
        player.f_19853_.m_6443_(Mob.class, player.m_20191_().m_82400_(16.0), mob -> mob.m_5448_() == player).forEach(mob -> {
            mob.m_6710_(null);
            mob.m_6703_(null);
            mob.m_21335_(null);
        });
        tag.m_128356_("sheikahCooldown", currentTime + 600L);
        tag.m_128356_("sheikahInvulnUntil", currentTime + (long)invisDuration);
    }

    @SubscribeEvent
    public static void onLivingHurtWhileInvisible(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        CompoundTag tag = PetFairyEvents.getOrCreatePersistentTag(player);
        if (!tag.m_128471_("hasPetFairy")) {
            return;
        }
        if (!"sheikah".equals(tag.m_128461_("fairyType"))) {
            return;
        }
        if (!(event.getSource().m_7639_() instanceof LivingEntity)) {
            return;
        }
        long currentTime = player.m_9236_().m_46467_();
        if (currentTime <= tag.m_128454_("sheikahInvulnUntil")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onOwnerHurtNeriAbsorption(LivingHurtEvent event) {
        Player player;
        CompoundTag persistTag;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (persistTag = PetFairyEvents.getOrCreatePersistentTag(player = (Player)livingEntity)).m_128471_("hasPetFairy") && (persistTag.m_128461_("fairyType").equals("neri") || persistTag.m_128461_("fairyType").equals("golden")) && !player.m_21023_(MobEffects.f_19617_) && Math.random() < 0.05) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 60, 0));
            player.f_19853_.m_247517_(null, player.m_20097_(), (SoundEvent)ModSounds.FAIRY1.get(), SoundSource.PLAYERS);
            double x = player.m_20185_();
            double y = player.m_20186_() + 1.0;
            double z = player.m_20189_();
            for (int i = 0; i < 60; ++i) {
                double angle = (double)i / 30.0 * Math.PI * 2.0;
                double px = Math.cos(angle) * 0.5;
                double pz = Math.sin(angle) * 0.5;
                ParticleHelper.spawnParticle(player.f_19853_, (ParticleOptions)ParticleTypes.f_123785_, x + px, y, z + pz, 0.0, 0.5, 0.0);
            }
        }
    }

    @SubscribeEvent
    public static void onTargetHurtLeaf(LivingHurtEvent event) {
        Entity source = event.getSource().m_7639_();
        LivingEntity livingEntity = event.getEntity();
        if (source instanceof Player) {
            CompoundTag persistTag;
            Player player = (Player)source;
            if (livingEntity != null && (persistTag = PetFairyEvents.getOrCreatePersistentTag(player)).m_128471_("hasPetFairy") && (persistTag.m_128461_("fairyType").equals("leaf") || persistTag.m_128461_("fairyType").equals("golden")) && Math.random() < 0.05) {
                float currentDamage = event.getAmount();
                float doubleDamage = currentDamage * 2.0f;
                event.setAmount(doubleDamage);
                player.f_19853_.m_247517_(null, player.m_20097_(), (SoundEvent)ModSounds.FAIRY1.get(), SoundSource.PLAYERS);
                double x = livingEntity.m_20185_();
                double y = livingEntity.m_20186_() + 1.0;
                double z = livingEntity.m_20189_();
                for (int i = 0; i < 60; ++i) {
                    double angle = (double)i / 30.0 * Math.PI * 2.0;
                    double px = Math.cos(angle) * 0.5;
                    double pz = Math.sin(angle) * 0.5;
                    ParticleHelper.spawnParticle(player.f_19853_, (ParticleOptions)ParticleTypes.f_123790_, x + px, y, z + pz, 0.0, 0.5, 0.0);
                }
            }
        }
    }
}

