/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.item.custom;

import java.util.List;
import net.mezimaru.mastersword.client.MagicMeterData;
import net.mezimaru.mastersword.config.MasterSwordCommonConfigs;
import net.mezimaru.mastersword.entity.custom.IceRodProjectileEntity;
import net.mezimaru.mastersword.events.MagicMeterEvents;
import net.mezimaru.mastersword.network.ModMessages;
import net.mezimaru.mastersword.network.packet.StopIceBeamSoundS2CPacket;
import net.mezimaru.mastersword.sound.ModSounds;
import net.mezimaru.mastersword.util.AbilityCapability;
import net.mezimaru.mastersword.util.AbilityCapabilityProvider;
import net.mezimaru.mastersword.util.IMagicItem;
import net.mezimaru.mastersword.util.ParticleHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IceRodItem
extends SwordItem
implements IMagicItem {
    public static final ItemCooldowns iceRodCooldown = new ItemCooldowns();
    private int tickCounter = 0;

    public IceRodItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        if (pAttacker instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)pAttacker;
            pStack.m_220157_(1, pAttacker.m_217043_(), player);
        }
        return true;
    }

    public boolean m_6813_(ItemStack pStack, Level pLevel, BlockState pState, BlockPos pPos, LivingEntity pEntityLiving) {
        if (pEntityLiving instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)pEntityLiving;
            if (pState.m_60800_((BlockGetter)pLevel, pPos) != 0.0f) {
                pStack.m_220157_(2, pEntityLiving.m_217043_(), player);
            }
        }
        return true;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (stack.m_41773_() < stack.m_41776_() - 1) {
            return false;
        }
        if (!player.f_19853_.f_46443_) {
            player.m_5661_((Component)Component.m_237115_((String)"message.mastersword.ice_rod_broken"), true);
        }
        return true;
    }

    public boolean m_6777_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        ItemStack stack;
        if (!pPlayer.m_7500_() && (stack = pPlayer.m_21120_(pPlayer.m_7655_())).m_41720_() instanceof IceRodItem) {
            if (stack.m_41773_() < stack.m_41776_() - 1) {
                return true;
            }
            if (!pPlayer.f_19853_.f_46443_) {
                pPlayer.m_5661_((Component)Component.m_237115_((String)"message.mastersword.ice_rod_broken"), true);
            }
            return false;
        }
        return false;
    }

    public final int m_8105_(ItemStack stack) {
        return 1120;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand pHand) {
        ItemStack stack = player.m_21120_(pHand);
        AbilityCapability abilityCapability = (AbilityCapability)player.getCapability(AbilityCapabilityProvider.ABILITY_CAPABILITY).orElse(null);
        if (abilityCapability == null) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (stack.m_41720_() instanceof IceRodItem) {
            if (MagicMeterData.getMagicAmount(player) < this.getMagicCost() && !player.m_7500_()) {
                if (!player.f_19853_.f_46443_) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.mastersword.no_magic"), true);
                }
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            if (stack.m_41773_() >= stack.m_41776_() - 1) {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            if (iceRodCooldown.m_41519_(stack.m_41720_())) {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            player.m_6672_(pHand);
            level.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.ICE_BEAM.get(), SoundSource.PLAYERS, 0.5f, 2.0f);
            abilityCapability.setPlayingIceRodSound(true);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(level, player, pHand);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity livingEntity, int count) {
        if (!level.f_46443_ && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (stack.m_41720_() instanceof IceRodItem) {
                AbilityCapability abilityCapability = (AbilityCapability)player.getCapability(AbilityCapabilityProvider.ABILITY_CAPABILITY).orElse(null);
                if (abilityCapability == null) {
                    return;
                }
                ModMessages.sendToNearbyClients(new StopIceBeamSoundS2CPacket(player.m_19879_()), (ServerPlayer)player);
                ModMessages.sendToPlayer(new StopIceBeamSoundS2CPacket(player.m_19879_()), (ServerPlayer)player);
                level.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.ICE_BEAM_END.get(), SoundSource.PLAYERS, 0.8f, 2.0f);
                abilityCapability.setPlayingIceRodSound(false);
                if (this.tickCounter >= 5) {
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    iceRodCooldown.m_41519_((Item)this);
                    player.m_36335_().m_41524_((Item)this, 30);
                }
                this.tickCounter = 0;
            }
        }
    }

    public void m_5929_(@NotNull Level level, @NotNull LivingEntity livingEntity, @NotNull ItemStack stack, int ticks) {
        if (!level.f_46443_ && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (stack.m_41720_() instanceof IceRodItem) {
                if (player.m_6117_() && (stack.m_41773_() >= stack.m_41776_() - 1 || MagicMeterData.getMagicAmount(player) <= 0 && !player.m_7500_())) {
                    player.m_5810_();
                }
                ++this.tickCounter;
                if (this.tickCounter % 40 == 0 && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    stack.m_220157_(1, livingEntity.m_217043_(), serverPlayer);
                }
                if (this.tickCounter >= 5) {
                    float range;
                    Vec3 endPos;
                    Vec3 lookDirection = player.m_20154_();
                    Vec3 handPosOffset = player.m_204034_((Item)this);
                    Vec3 startPos = player.m_146892_();
                    BlockHitResult blockHit = level.m_45547_(new ClipContext(startPos, endPos = startPos.m_82549_(lookDirection.m_82490_((double)(range = 20.0f))), ClipContext.Block.COLLIDER, ClipContext.Fluid.WATER, (Entity)player));
                    if (blockHit.m_6662_() == HitResult.Type.BLOCK) {
                        BlockPos blockPos = blockHit.m_82425_();
                        BlockState blockState = level.m_8055_(blockPos);
                        if (blockState.m_60713_(Blocks.f_49990_)) {
                            this.freezeWaterBlock(level, blockPos);
                        } else if (((Boolean)MasterSwordCommonConfigs.ICE_ROD_LEAVE_SNOW.get()).booleanValue()) {
                            this.leaveSnow(level, blockPos);
                        }
                    }
                    int i = 0;
                    while ((float)i < range * 2.0f) {
                        double x = player.m_20185_() + lookDirection.f_82479_ * (double)i * 0.5 + handPosOffset.f_82479_ * 0.5 * 1.0;
                        double y = player.m_20188_() + lookDirection.f_82480_ * (double)i * 0.5 + handPosOffset.f_82480_;
                        double z = player.m_20189_() + lookDirection.f_82481_ * (double)i * 0.5 + handPosOffset.f_82481_ * 0.5 * 1.0;
                        double randomOffsetX = player.m_217043_().m_188500_() * 0.2 - 0.1;
                        double randomOffsetY = player.m_217043_().m_188500_() * 0.2 - 0.1;
                        double randomOffsetZ = player.m_217043_().m_188500_() * 0.2 - 0.1;
                        BlockPos beamPos = new BlockPos((int)x, (int)y, (int)z);
                        if (level.m_8055_(beamPos).m_60713_(Blocks.f_50083_)) {
                            level.m_7471_(beamPos, false);
                        }
                        ParticleHelper.spawnParticle(level, (ParticleOptions)ParticleTypes.f_175830_, x + randomOffsetX, y + randomOffsetY + 0.2, z + randomOffsetZ, 0.0, 0.0, 0.0);
                        ++i;
                    }
                    if (this.tickCounter % 10 == 0) {
                        IceRodProjectileEntity iceBeam = new IceRodProjectileEntity((LivingEntity)player, level);
                        iceBeam.m_37251_((Entity)player, livingEntity.m_146909_(), livingEntity.m_146908_(), 0.0f, 3.5f, 1.0f);
                        iceBeam.m_6034_(iceBeam.m_20185_(), iceBeam.m_20186_() + 0.8, iceBeam.m_20189_());
                        level.m_7967_((Entity)iceBeam);
                        MagicMeterEvents.removeMagic(this.getMagicCost(), (ServerPlayer)player);
                    }
                }
            }
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            AbilityCapability abilityCapability = (AbilityCapability)player.getCapability(AbilityCapabilityProvider.ABILITY_CAPABILITY).orElse(null);
            if (abilityCapability == null) {
                return;
            }
            if (!(player.m_21211_().m_41720_() instanceof IceRodItem)) {
                this.tickCounter = 0;
                if (abilityCapability.isPlayingIceRodSound()) {
                    abilityCapability.setPlayingIceRodSound(false);
                    if (!level.f_46443_) {
                        ModMessages.sendToNearbyClients(new StopIceBeamSoundS2CPacket(player.m_19879_()), (ServerPlayer)player);
                        ModMessages.sendToPlayer(new StopIceBeamSoundS2CPacket(player.m_19879_()), (ServerPlayer)player);
                        level.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.ICE_BEAM_END.get(), SoundSource.PLAYERS, 0.8f, 2.0f);
                    }
                }
            }
        }
        super.m_6883_(stack, level, entity, slot, selected);
    }

    private void freezeWaterBlock(Level level, BlockPos pos) {
        level.m_46597_(pos, Blocks.f_50126_.m_49966_());
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = pos.m_121945_(direction);
            BlockState neighborState = level.m_8055_(neighborPos);
            if (!neighborState.m_60713_(Blocks.f_49990_)) continue;
            level.m_46597_(neighborPos, Blocks.f_50449_.m_49966_());
        }
    }

    private void leaveSnow(Level level, BlockPos pos) {
        BlockState belowState;
        BlockPos abovePos;
        BlockState aboveState;
        if (!(level.m_46472_() != Level.f_46428_ || !(aboveState = level.m_8055_(abovePos = pos.m_7494_())).m_60795_() && !aboveState.m_247087_() || (belowState = level.m_8055_(pos)).m_60713_(Blocks.f_50126_) || belowState.m_60713_(Blocks.f_50568_) || belowState.m_60713_(Blocks.f_50449_) || belowState.m_60713_(Blocks.f_50354_))) {
            level.m_46597_(pos.m_7494_(), Blocks.f_50125_.m_49966_());
        }
    }

    public MutableComponent getName(ItemStack stack) {
        MutableComponent itemName = (MutableComponent)super.m_7626_(stack);
        return itemName.m_130940_(ChatFormatting.BLUE);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        int magicCost = this.getMagicCost();
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mastersword.magic_cost").m_7220_((Component)Component.m_237113_((String)String.valueOf(magicCost))).m_130940_(ChatFormatting.DARK_GREEN));
        pTooltipComponents.add((Component)Component.m_237113_((String)""));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mastersword.rod.tooltip1").m_130940_(ChatFormatting.LIGHT_PURPLE));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mastersword.ice_rod.tooltip1").m_130940_(ChatFormatting.ITALIC));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    @Override
    public int getMagicCost() {
        return 3;
    }
}

