/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.item.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import net.mezimaru.mastersword.block.ModBlocks;
import net.mezimaru.mastersword.config.MasterSwordCommonConfigs;
import net.mezimaru.mastersword.entity.ModEntities;
import net.mezimaru.mastersword.entity.custom.HealingFairyEntity;
import net.mezimaru.mastersword.entity.custom.LonLonCowEntity;
import net.mezimaru.mastersword.entity.custom.OcarinaHorseEntity;
import net.mezimaru.mastersword.item.ModItems;
import net.mezimaru.mastersword.item.custom.OcarinaOfTimeItem;
import net.mezimaru.mastersword.network.ModMessages;
import net.mezimaru.mastersword.network.packet.StopSongSoundS2CPacket;
import net.mezimaru.mastersword.particle.custom.ColoredParticleType;
import net.mezimaru.mastersword.sound.ModSounds;
import net.mezimaru.mastersword.util.AbilityCapability;
import net.mezimaru.mastersword.util.AbilityCapabilityProvider;
import net.mezimaru.mastersword.util.ParticleHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Variant;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;

public class OcarinaFairyItem
extends Item {
    public static final ItemCooldowns songCooldown = new ItemCooldowns();
    private static final int MAX_SONGS = 5;
    private int tickCounter = 0;
    private boolean foundPattern = false;
    private BlockPos goldenBottlePos = null;

    public OcarinaFairyItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public final int m_8105_(ItemStack stack) {
        return 240;
    }

    public boolean m_8120_(ItemStack pStack) {
        return false;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.CUSTOM;
    }

    public boolean m_6777_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand pHand) {
        ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (pHand != InteractionHand.MAIN_HAND) {
            return InteractionResultHolder.m_19100_((Object)player.m_21120_(pHand));
        }
        if (!level.f_46443_) {
            if (songCooldown.m_41519_(stack.m_41720_())) {
                return InteractionResultHolder.m_19100_((Object)player.m_21120_(pHand));
            }
            CompoundTag tag = player.getPersistentData();
            if (!tag.m_128441_("PlayerPersisted")) {
                tag.m_128365_("PlayerPersisted", (Tag)new CompoundTag());
            }
            CompoundTag persistTag = tag.m_128469_("PlayerPersisted");
            if (!(stack.m_41720_() instanceof OcarinaOfTimeItem) && persistTag.m_128441_("hasUnlockedSong1")) {
                persistTag.m_128379_("hasUnlockedSong1", false);
            }
            if (player.m_6047_()) {
                boolean hasUnlockedSongs = false;
                for (int i = 1; i <= 5; ++i) {
                    String songKey = "hasUnlockedSong" + i;
                    if (!persistTag.m_128471_(songKey)) continue;
                    hasUnlockedSongs = true;
                    break;
                }
                if (!hasUnlockedSongs) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.mastersword.no_songs_unlocked"), true);
                    return InteractionResultHolder.m_19100_((Object)player.m_21120_(pHand));
                }
                int currentSongNum = stack.m_41784_().m_128451_("SongNumber");
                int nextSongNum = this.findNextUnlockedSong(persistTag, currentSongNum);
                stack.m_41784_().m_128405_("SongNumber", nextSongNum);
                String songKey = "tooltip.mastersword.ocarina.song" + nextSongNum;
                stack.m_41784_().m_128359_("SongName", songKey);
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ClientboundSetCarriedItemPacket packet = new ClientboundSetCarriedItemPacket(player.m_150109_().f_35977_);
                serverPlayer.f_8906_.m_9829_((Packet)packet);
                MutableComponent songName = Component.m_237115_((String)songKey);
                player.m_5661_((Component)Component.m_237110_((String)"message.mastersword.selected_song", (Object[])new Object[]{songName}), true);
                return InteractionResultHolder.m_19096_((Object)stack);
            }
            this.foundPattern = false;
            player.m_6672_(InteractionHand.MAIN_HAND);
        }
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    private int findNextUnlockedSong(CompoundTag persistTag, int currentSongNum) {
        for (int i = 1; i <= 5; ++i) {
            int nextSongNum = currentSongNum % 5 + 1;
            String songKey = "hasUnlockedSong" + nextSongNum;
            if (persistTag.m_128471_(songKey)) {
                return nextSongNum;
            }
            currentSongNum = nextSongNum;
        }
        return currentSongNum;
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack stack, int ticks) {
        Player player;
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_7655_() != InteractionHand.MAIN_HAND) {
            player.m_5810_();
            return;
        }
        if (!level.f_46443_ && livingEntity instanceof Player && (player = (Player)livingEntity).m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof OcarinaFairyItem) {
            int songNum = stack.m_41784_().m_128451_("SongNumber");
            Random random = new Random();
            if (random.nextInt(11) == 0) {
                this.spawnNoteParticle(level, livingEntity);
            }
            if (songNum == 1) {
                if (this.m_8105_(stack) == ticks) {
                    level.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.SONG_OF_TIME.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                if (this.m_8105_(stack) - ticks >= 180) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (serverPlayer.m_8961_() != null) {
                        if (!player.m_7500_()) {
                            player.m_36335_().m_41524_((Item)this, 1200);
                        }
                        player.m_5810_();
                        ServerLevel dimension = serverPlayer.m_20194_().m_129880_(serverPlayer.m_8963_());
                        if (dimension != null) {
                            serverPlayer.m_8999_(dimension, (double)serverPlayer.m_8961_().m_123341_(), (double)serverPlayer.m_8961_().m_123342_(), (double)serverPlayer.m_8961_().m_123343_(), serverPlayer.m_8962_(), serverPlayer.m_8962_());
                        }
                    } else {
                        player.m_213846_((Component)Component.m_237115_((String)"message.mastersword.no_spawn_location"));
                        player.m_5810_();
                    }
                }
            } else if (songNum == 2) {
                AbilityCapability ability = (AbilityCapability)player.getCapability(AbilityCapabilityProvider.ABILITY_CAPABILITY).orElse(null);
                if (ability == null) {
                    return;
                }
                if (this.m_8105_(stack) == ticks) {
                    level.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.EPONAS_SONG.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                if (this.m_8105_(stack) - ticks >= 120 && this.m_8105_(stack) - ticks <= 121 && level.m_46472_() == Level.f_46428_) {
                    int eponaCooldown = 1200;
                    if (ability.getOcarinaHorse() == null || ability.getOcarinaHorse().isEmpty()) {
                        Horse horse = (Horse)((EntityType)ModEntities.OCARINAHORSE.get()).m_20615_(level);
                        if (horse != null) {
                            horse.m_6034_(player.m_20185_() + (double)((int)(Math.sin(Math.toRadians(player.m_20155_().f_82471_)) * -2.0)), player.m_20186_(), player.m_20189_() + (double)((int)(Math.cos(Math.toRadians(player.m_20155_().f_82471_)) * 2.0)));
                            horse.m_30651_(true);
                            horse.m_30586_(player.m_20148_());
                            horse.m_5853_(null);
                            horse.m_28464_(Variant.CHESTNUT);
                            if (!player.m_7500_()) {
                                player.m_36335_().m_41524_((Item)this, eponaCooldown);
                            }
                            if (this.m_7968_().m_150930_((Item)ModItems.OCARINAOFTIME.get())) {
                                horse.m_246861_(player, new ItemStack((ItemLike)Items.f_42651_));
                            }
                            level.m_7967_((Entity)horse);
                            ability.setOcarinaHorse(horse.m_20148_().toString());
                        }
                    } else {
                        ServerLevel serverLevel = (ServerLevel)level;
                        UUID horseUUID = UUID.fromString(ability.getOcarinaHorse());
                        Entity entity = serverLevel.m_8791_(horseUUID);
                        if (entity instanceof OcarinaHorseEntity) {
                            OcarinaHorseEntity horse = (OcarinaHorseEntity)entity;
                            horse.m_6021_(player.m_20185_() + (double)((int)(Math.sin(Math.toRadians(player.m_20155_().f_82471_)) * -2.0)), player.m_20186_(), player.m_20189_() + (double)((int)(Math.cos(Math.toRadians(player.m_20155_().f_82471_)) * 2.0)));
                            horse.resetTicksSinceLastInteraction();
                            player.m_36335_().m_41524_((Item)this, eponaCooldown);
                        } else {
                            Horse horse = (Horse)((EntityType)ModEntities.OCARINAHORSE.get()).m_20615_(level);
                            if (horse != null) {
                                horse.m_6034_(player.m_20185_() + (double)((int)(Math.sin(Math.toRadians(player.m_20155_().f_82471_)) * -2.0)), player.m_20186_(), player.m_20189_() + (double)((int)(Math.cos(Math.toRadians(player.m_20155_().f_82471_)) * 2.0)));
                                horse.m_30651_(true);
                                horse.m_30586_(player.m_20148_());
                                horse.m_28464_(Variant.CHESTNUT);
                                horse.m_5853_(null);
                                if (!player.m_7500_()) {
                                    player.m_36335_().m_41524_((Item)this, eponaCooldown);
                                }
                                if (this.m_7968_().m_150930_((Item)ModItems.OCARINAOFTIME.get())) {
                                    horse.m_246861_(player, new ItemStack((ItemLike)Items.f_42651_));
                                }
                                level.m_7967_((Entity)horse);
                                ability.setOcarinaHorse(horse.m_20148_().toString());
                            }
                        }
                    }
                }
                if (this.m_8105_(stack) - ticks >= 135) {
                    if (level.m_46472_() != Level.f_46428_) {
                        player.m_5661_((Component)Component.m_237115_((String)"message.mastersword.epona_song_not_allowed"), true);
                        player.m_5810_();
                    }
                    player.m_5810_();
                }
            } else if (songNum == 3) {
                if (this.m_8105_(stack) == ticks) {
                    this.tickCounter = 0;
                    this.foundPattern = false;
                    this.goldenBottlePos = null;
                    level.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.ZELDAS_LULLABY.get(), SoundSource.PLAYERS, 0.8f, 1.0f);
                }
                double range = 30.0;
                AABB area = player.m_20191_().m_82400_(range);
                BlockPos playerPos = player.m_20183_();
                BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
                if (!this.foundPattern) {
                    block0: for (int x = -30; x <= 30; ++x) {
                        for (int y = -30; y <= 30; ++y) {
                            for (int z = -30; z <= 30; ++z) {
                                int[][] offsets;
                                checkPos.m_122190_((Vec3i)playerPos).m_122184_(x, y, z);
                                if (level.m_8055_((BlockPos)checkPos).m_60734_() != ModBlocks.HYLIAN_BOTTLE_EMPTY_BLOCK.get()) continue;
                                HashSet<Block> foundFairyBlocks = new HashSet<Block>();
                                for (int[] offset : offsets = new int[][]{{-2, 0, -2}, {-1, 0, -2}, {0, 0, -2}, {1, 0, -2}, {2, 0, -2}, {-2, 0, -1}, {2, 0, -1}, {-2, 0, 0}, {2, 0, 0}, {-2, 0, 1}, {2, 0, 1}, {-2, 0, 2}, {-1, 0, 2}, {0, 0, 2}, {1, 0, 2}, {2, 0, 2}}) {
                                    BlockPos offsetPos = checkPos.m_7918_(offset[0], offset[1], offset[2]);
                                    Block blockAtPos = level.m_8055_(offsetPos).m_60734_();
                                    if (!this.isFairyBlock(blockAtPos)) {
                                        foundFairyBlocks.clear();
                                        break;
                                    }
                                    foundFairyBlocks.add(blockAtPos);
                                }
                                if (foundFairyBlocks.size() != 16) continue;
                                this.foundPattern = true;
                                this.goldenBottlePos = checkPos.m_7949_();
                                break block0;
                            }
                        }
                    }
                }
                if (this.foundPattern) {
                    ++this.tickCounter;
                    if (this.tickCounter >= 10 && this.goldenBottlePos != null) {
                        this.spawnParticleEffect(level, this.goldenBottlePos, this.tickCounter);
                    }
                    if (this.m_8105_(stack) - ticks >= 180) {
                        int[][] offsets;
                        level.m_7731_(this.goldenBottlePos, Blocks.f_50016_.m_49966_(), 3);
                        for (int[] offset : offsets = new int[][]{{-2, 0, -2}, {-1, 0, -2}, {0, 0, -2}, {1, 0, -2}, {2, 0, -2}, {-2, 0, -1}, {2, 0, -1}, {-2, 0, 0}, {2, 0, 0}, {-2, 0, 1}, {2, 0, 1}, {-2, 0, 2}, {-1, 0, 2}, {0, 0, 2}, {1, 0, 2}, {2, 0, 2}}) {
                            BlockPos offsetPos = this.goldenBottlePos.m_7918_(offset[0], offset[1], offset[2]);
                            level.m_7731_(offsetPos, Blocks.f_50016_.m_49966_(), 3);
                        }
                        BlockState goldenFairyBlockState = (BlockState)((Block)ModBlocks.HYLIAN_BOTTLE_GOLDEN_FAIRY_BLOCK.get()).m_49966_().m_263224_((Property)BlockStateProperties.f_61422_, (Comparable)Integer.valueOf(10));
                        level.m_7731_(this.goldenBottlePos, goldenFairyBlockState, 3);
                        level.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.FANFARE_ITEM.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        this.tickCounter = 0;
                        this.foundPattern = false;
                    }
                }
                if (!level.f_46443_ && this.m_8105_(stack) - ticks >= 180) {
                    List fairies = level.m_45976_(HealingFairyEntity.class, area);
                    for (HealingFairyEntity fairy : fairies) {
                        fairy.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 600));
                    }
                    List livingEntities = level.m_45976_(LivingEntity.class, area);
                    for (LivingEntity entity : livingEntities) {
                        if (!(entity instanceof Enemy) && !(entity instanceof ArmorStand)) {
                            entity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 180, 1));
                            if (!(entity instanceof LonLonCowEntity)) continue;
                            LonLonCowEntity cow = (LonLonCowEntity)entity;
                            cow.resetMilkTimer();
                            continue;
                        }
                        if (!(entity instanceof Enemy) || entity.m_6336_() != MobType.f_21641_) continue;
                        entity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 180, 1));
                    }
                    if (!player.m_7500_()) {
                        player.m_36335_().m_41524_((Item)this, 1200);
                    }
                    player.m_5810_();
                }
            } else if (songNum == 4) {
                if (!((Boolean)MasterSwordCommonConfigs.ENABLE_SONG_OF_STORMS.get()).booleanValue()) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.mastersword.disabled_song_of_storms"), true);
                    player.m_36335_().m_41524_((Item)this, 20);
                    player.m_5810_();
                    return;
                }
                if (this.m_8105_(stack) == ticks) {
                    level.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.SONG_OF_STORMS.get(), SoundSource.PLAYERS, 0.7f, 1.0f);
                }
                if (this.m_8105_(stack) - ticks >= 80) {
                    boolean isRainingOrStorming;
                    LevelData leveldata = level.m_6106_();
                    boolean bl = isRainingOrStorming = leveldata.m_6533_() || leveldata.m_6534_();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_8606_(0, 0, !isRainingOrStorming, !isRainingOrStorming);
                    }
                    if (!player.m_7500_()) {
                        player.m_36335_().m_41524_((Item)this, 600);
                    }
                    player.m_5810_();
                }
            } else if (songNum == 5) {
                if (!((Boolean)MasterSwordCommonConfigs.ENABLE_SUNS_SONG.get()).booleanValue()) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.mastersword.disabled_sun_of_storms"), true);
                    player.m_36335_().m_41524_((Item)this, 20);
                    player.m_5810_();
                    return;
                }
                if (this.m_8105_(stack) == ticks) {
                    level.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.SUNS_SONG.get(), SoundSource.PLAYERS, 2.5f, 1.0f);
                }
                if (this.m_8105_(stack) - ticks >= 85) {
                    boolean isDay = level.m_46461_();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        long currentTime = serverLevel.m_46468_();
                        long timeOfDay = currentTime % 24000L;
                        long targetTime = isDay ? 13000L : 1000L;
                        long ticksToAdd = (targetTime - timeOfDay + 24000L) % 24000L;
                        serverLevel.m_8615_(currentTime + ticksToAdd);
                        if (!player.m_7500_()) {
                            player.m_36335_().m_41524_((Item)this, 600);
                        }
                        player.m_5810_();
                    }
                }
            }
        }
    }

    private boolean isFairyBlock(Block block) {
        return block == ModBlocks.HYLIAN_BOTTLE_NAVI_BLOCK.get() || block == ModBlocks.HYLIAN_BOTTLE_TATL_BLOCK.get() || block == ModBlocks.HYLIAN_BOTTLE_TAEL_BLOCK.get() || block == ModBlocks.HYLIAN_BOTTLE_CIELA_BLOCK.get() || block == ModBlocks.HYLIAN_BOTTLE_LEAF_BLOCK.get() || block == ModBlocks.HYLIAN_BOTTLE_NERI_BLOCK.get() || block == ModBlocks.HYLIAN_BOTTLE_WHITE_FAIRY_BLOCK.get() || block == ModBlocks.HYLIAN_BOTTLE_GRAY_FAIRY_BLOCK.get() || block == ModBlocks.HYLIAN_BOTTLE_BLACK_FAIRY_BLOCK.get() || block == ModBlocks.HYLIAN_BOTTLE_ORANGE_FAIRY_BLOCK.get() || block == ModBlocks.HYLIAN_BOTTLE_LIME_FAIRY_BLOCK.get() || block == ModBlocks.HYLIAN_BOTTLE_GREEN_FAIRY_BLOCK.get() || block == ModBlocks.HYLIAN_BOTTLE_CYAN_FAIRY_BLOCK.get() || block == ModBlocks.HYLIAN_BOTTLE_PURPLE_FAIRY_BLOCK.get() || block == ModBlocks.HYLIAN_BOTTLE_MAGENTA_FAIRY_BLOCK.get() || block == ModBlocks.HYLIAN_BOTTLE_BROWN_FAIRY_BLOCK.get();
    }

    private void spawnParticleEffect(Level level, BlockPos pos, int ticks) {
        int maxCircles = 45;
        int numCircles = Math.min(1 + ticks / 4, maxCircles);
        double radiusIncrement = 0.03;
        double heightIncrement = 0.15;
        double rotationSpeed = 8.0;
        double rotationAngle = Math.toRadians((double)ticks * rotationSpeed);
        for (int i = 0; i < numCircles; ++i) {
            double radius = 0.4 + (double)i * radiusIncrement;
            double height = (double)i * heightIncrement;
            for (int j = 0; j < 360; j += 60) {
                double angle = Math.toRadians(j) + rotationAngle;
                double particleX = (double)pos.m_123341_() + 0.5 + radius * Math.cos(angle);
                double particleY = (double)pos.m_123342_() + height;
                double particleZ = (double)pos.m_123343_() + 0.5 + radius * Math.sin(angle);
                ColoredParticleType.ColoredParticleData particleData = new ColoredParticleType.ColoredParticleData(0.765f, 0.62f, 0.243f);
                ParticleHelper.spawnParticle(level, particleData, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
            }
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity livingEntity, int count) {
        Player player;
        if (!level.f_46443_ && livingEntity instanceof Player && (player = (Player)livingEntity).m_21211_().m_41720_() instanceof OcarinaFairyItem) {
            ModMessages.sendToNearbyClients(new StopSongSoundS2CPacket(player.m_19879_()), (ServerPlayer)player);
            ModMessages.sendToPlayer(new StopSongSoundS2CPacket(player.m_19879_()), (ServerPlayer)player);
            this.tickCounter = 0;
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237113_((String)""));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mastersword.rightclick.tooltip1").m_130940_(ChatFormatting.LIGHT_PURPLE));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mastersword.rightclick.tooltip2").m_130940_(ChatFormatting.LIGHT_PURPLE));
        if (stack.m_41720_() instanceof OcarinaOfTimeItem) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mastersword.ocarina_of_time.tooltip1").m_130940_(ChatFormatting.ITALIC));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mastersword.ocarina_fairy.tooltip1").m_130940_(ChatFormatting.ITALIC));
        }
        String songName = stack.m_41784_().m_128461_("SongName");
        if (!songName.isEmpty()) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mastersword.ocarina.tooltip2").m_130940_(ChatFormatting.YELLOW));
            pTooltipComponents.add((Component)Component.m_237115_((String)songName).m_130940_(ChatFormatting.AQUA));
        }
        super.m_7373_(stack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public MutableComponent getName(ItemStack stack) {
        return Component.m_237115_((String)"item.mastersword.ocarina_fairy").m_130940_(ChatFormatting.GRAY);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private static final HumanoidModel.ArmPose PLAY_POSE = HumanoidModel.ArmPose.create((String)"PLAY", (boolean)true, (model, entity, arm) -> {
                model.f_102811_.f_104203_ = Mth.m_14036_((float)model.f_102808_.f_104203_, (float)-1.2f, (float)1.2f) - 1.2835298f;
                model.f_102811_.f_104204_ = model.f_102808_.f_104204_ - 0.31415927f;
                model.f_102812_.f_104203_ = Mth.m_14036_((float)model.f_102808_.f_104203_, (float)-1.2f, (float)1.2f) - 1.2835298f;
                model.f_102812_.f_104204_ = model.f_102808_.f_104204_ + 0.31415927f;
            });

            public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
                if (!itemStack.m_41619_() && entityLiving.m_7655_() == hand && entityLiving.m_21212_() > 0) {
                    return PLAY_POSE;
                }
                return HumanoidModel.ArmPose.ITEM;
            }

            public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
                int direction = arm == HumanoidArm.RIGHT ? 1 : -1;
                this.applyItemArmTransform(poseStack, arm);
                if (swingProcess > 0.0f) {
                    float f = Mth.m_14031_((float)(Mth.m_14116_((float)swingProcess) * (float)Math.PI));
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(f * 20.0f));
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-f * 20.0f));
                    poseStack.m_252781_(Axis.f_252403_.m_252977_(f * 80.0f));
                    return true;
                }
                if (player.m_6117_() && player.m_21211_() == itemInHand) {
                    float timeLeft = (float)itemInHand.m_41779_() - ((float)player.m_21212_() - partialTick + 1.0f);
                    float sin = Mth.m_14031_((float)((timeLeft - 0.1f) * 1.3f));
                    poseStack.m_85837_((double)direction * -0.6, (double)(sin * 0.0038f) + 0.1, 0.0);
                    poseStack.m_252781_(Axis.f_252393_.m_252977_(20.0f));
                    poseStack.m_85841_((float)direction * 1.0f, 0.7f, 0.5f);
                    return true;
                }
                return false;
            }

            private void applyItemArmTransform(PoseStack poseStack, HumanoidArm arm) {
                int i = arm == HumanoidArm.RIGHT ? 1 : -1;
                poseStack.m_252880_((float)i * 0.56f, -0.52f, -0.72f);
            }
        });
    }

    public void spawnNoteParticle(Level level, LivingEntity entity) {
        Vec3 bx = new Vec3(1.0, 0.0, 0.0);
        Vec3 by = new Vec3(0.0, 1.0, 0.0);
        Vec3 bz = new Vec3(0.0, 0.0, 1.0);
        float toRad = (float)Math.PI / 180;
        float xRot = -entity.m_146909_() * toRad;
        float yRot = -Mth.m_14177_((float)entity.f_20885_) * toRad;
        bx = bx.m_82496_(xRot).m_82524_(yRot);
        by = by.m_82496_(xRot).m_82524_(yRot);
        bz = bz.m_82496_(xRot).m_82524_(yRot);
        Vec3 armVec = new Vec3(0.0, 0.0, 0.28 + (double)level.f_46441_.m_188501_() * 0.5);
        int mirror = entity.m_5737_() == HumanoidArm.RIGHT ^ entity.m_7655_() == InteractionHand.MAIN_HAND ? -1 : 1;
        armVec = armVec.m_82524_((float)(-1.5707963267948966 * (double)mirror)).m_82520_(0.0, 0.15, 0.1);
        Vec3 newV = bx.m_82490_(armVec.f_82479_).m_82549_(by.m_82490_(armVec.f_82480_)).m_82549_(bz.m_82490_(armVec.f_82481_));
        double x = entity.m_20185_() + newV.f_82479_;
        double y = entity.m_20188_() + newV.f_82480_;
        double z = entity.m_20189_() + newV.f_82481_;
        SimpleParticleType particle = entity.m_5842_() ? ParticleTypes.f_123795_ : ParticleTypes.f_123758_;
        ParticleHelper.spawnParticle(level, (ParticleOptions)particle, x, y, z, (double)level.f_46441_.m_188503_(24) / 24.0, 0.0, 0.0);
    }
}

