/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.network.packet;

import java.util.function.Supplier;
import net.mezimaru.mastersword.client.MagicMeterData;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class MagicMeterSyncS2CPacket {
    private final int magicAmount;
    private final int maxMagic;
    private final int whenNeededRenderTime;
    private final int usingPlayer;

    public MagicMeterSyncS2CPacket(FriendlyByteBuf buffer) {
        this.magicAmount = buffer.readInt();
        this.maxMagic = buffer.readInt();
        this.whenNeededRenderTime = buffer.readInt();
        this.usingPlayer = buffer.readInt();
    }

    public MagicMeterSyncS2CPacket(int magicAmount, int maxMagic, int whenNeededRenderTime, int usingPlayer) {
        this.magicAmount = magicAmount;
        this.maxMagic = maxMagic;
        this.whenNeededRenderTime = whenNeededRenderTime;
        this.usingPlayer = usingPlayer;
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeInt(this.magicAmount);
        buffer.writeInt(this.maxMagic);
        buffer.writeInt(this.whenNeededRenderTime);
        buffer.writeInt(this.usingPlayer);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Entity clientPlayer = Minecraft.m_91087_().f_91073_.m_6815_(this.usingPlayer);
            if (clientPlayer == null) {
                return;
            }
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                if (clientPlayer instanceof Player) {
                    Player player = (Player)clientPlayer;
                    MagicMeterData.setMagicAmount(player, this.magicAmount);
                    MagicMeterData.setMaxMagic(player, this.maxMagic);
                    MagicMeterData.setWhenNeededRenderTimer(player, this.whenNeededRenderTime);
                }
            });
        });
        context.setPacketHandled(true);
    }
}

