/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.network.packet;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class StandForAbilityS2CPacket {
    private final boolean stand;
    private final int usingPlayer;

    public StandForAbilityS2CPacket(boolean stand, int usingPlayer) {
        this.stand = stand;
        this.usingPlayer = usingPlayer;
    }

    public StandForAbilityS2CPacket(FriendlyByteBuf buf) {
        this.stand = buf.readBoolean();
        this.usingPlayer = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.stand);
        buf.writeInt(this.usingPlayer);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Entity clientPlayer = Minecraft.m_91087_().f_91073_.m_6815_(this.usingPlayer);
            if (clientPlayer == null) {
                return;
            }
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> clientPlayer.getPersistentData().m_128379_("standForAbility", this.stand));
        });
        context.setPacketHandled(true);
    }
}

