/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.mezimaru.mastersword.config.MasterSwordCommonConfigs;
import net.mezimaru.mastersword.entity.custom.BasePetFairyEntity;
import net.mezimaru.mastersword.entity.custom.BombchuEntity;
import net.mezimaru.mastersword.entity.custom.GoronMerchantEntity;
import net.mezimaru.mastersword.entity.custom.HealingFairyEntity;
import net.mezimaru.mastersword.entity.custom.OcarinaHorseEntity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;

public class FriendlyFireHelper {
    private static final Set<ResourceLocation> CONFIG_BLACKLIST = new HashSet<ResourceLocation>();

    public static void refreshBlacklist() {
        CONFIG_BLACKLIST.clear();
        for (String id : (List)MasterSwordCommonConfigs.FRIENDLY_FIRE_ENTITY_BLACKLIST.get()) {
            try {
                CONFIG_BLACKLIST.add(new ResourceLocation(id));
            }
            catch (Exception exception) {}
        }
    }

    private static boolean isConfigBlacklisted(LivingEntity entity) {
        ResourceLocation id = EntityType.m_20613_((EntityType)entity.m_6095_());
        return CONFIG_BLACKLIST.contains(id);
    }

    private static boolean isAlwaysBlacklisted(LivingEntity entity) {
        return entity instanceof ArmorStand || entity instanceof BasePetFairyEntity || entity instanceof HealingFairyEntity || entity instanceof BombchuEntity || entity instanceof OcarinaHorseEntity || entity instanceof GoronMerchantEntity;
    }

    public static boolean checkFriendlyFire(LivingEntity target, Player source) {
        if (target == null || source == null) {
            return false;
        }
        if (FriendlyFireHelper.isAlwaysBlacklisted(target) || FriendlyFireHelper.isConfigBlacklisted(target)) {
            return false;
        }
        if (target instanceof Player) {
            Player playerEntity = (Player)target;
            if (playerEntity == source) {
                return false;
            }
            return playerEntity.m_7099_(source);
        }
        return true;
    }
}

