/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.util;

import net.mezimaru.mastersword.config.MasterSwordCommonConfigs;
import net.mezimaru.mastersword.item.custom.FierceDeitySwordItem;
import net.mezimaru.mastersword.item.custom.GoldenMasterSwordItem;
import net.mezimaru.mastersword.item.custom.MasterSwordItem;
import net.mezimaru.mastersword.item.custom.TemperedMasterSwordItem;
import net.mezimaru.mastersword.item.custom.TrueMasterSwordItem;
import net.mezimaru.mastersword.network.ModMessages;
import net.mezimaru.mastersword.network.packet.StandForAbilityS2CPacket;
import net.mezimaru.mastersword.sound.ModSounds;
import net.mezimaru.mastersword.util.AbilityCapability;
import net.mezimaru.mastersword.util.AbilityCapabilityProvider;
import net.mezimaru.mastersword.util.FriendlyFireHelper;
import net.mezimaru.mastersword.util.ParticleHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mastersword")
public class SpinAbilityMethod {
    public static void damageEntitiesInRadius(Player player, Level level) {
        if (!level.f_46443_) {
            AbilityCapability ability = (AbilityCapability)player.getCapability(AbilityCapabilityProvider.ABILITY_CAPABILITY).orElse(null);
            if (ability == null) {
                return;
            }
            Item handItem = player.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
            if (handItem instanceof MasterSwordItem) {
                ability.setDamageAmount((Double)MasterSwordCommonConfigs.SPIN_DAMAGE_MASTER_SWORD.get());
                ability.setRadius(3.0);
            } else if (handItem instanceof TemperedMasterSwordItem) {
                ability.setDamageAmount((Double)MasterSwordCommonConfigs.SPIN_DAMAGE_TEMPERED_MASTER_SWORD.get());
                ability.setRadius(3.5);
            } else if (handItem instanceof GoldenMasterSwordItem) {
                ability.setDamageAmount((Double)MasterSwordCommonConfigs.SPIN_DAMAGE_GOLDEN_MASTER_SWORD.get());
                ability.setRadius(4.0);
            } else if (handItem instanceof TrueMasterSwordItem) {
                ability.setDamageAmount((Double)MasterSwordCommonConfigs.SPIN_DAMAGE_TRUE_MASTER_SWORD.get());
                ability.setRadius(4.5);
            } else if (handItem instanceof FierceDeitySwordItem) {
                ability.setDamageAmount((Double)MasterSwordCommonConfigs.SPIN_DAMAGE_FIERCE_DEITY_SWORD.get());
                ability.setRadius(6.0);
            }
            AABB box = player.m_20191_().m_82400_(ability.getRadius());
            if (((Boolean)MasterSwordCommonConfigs.SPIN_ATTACK_BREAK_PLANTS.get()).booleanValue()) {
                SpinAbilityMethod.breakBlocksInRadius(player, level, box);
            }
            for (Entity entity : level.m_45933_(null, box)) {
                LivingEntity livingEntity;
                if (!(entity instanceof LivingEntity) || !FriendlyFireHelper.checkFriendlyFire(livingEntity = (LivingEntity)entity, player)) continue;
                livingEntity.m_6469_(level.m_269111_().m_269075_(player), (float)ability.getDamageAmount());
                livingEntity.m_5997_(0.0, 0.4, 0.0);
            }
        }
    }

    private static void breakBlocksInRadius(Player player, Level level, AABB box) {
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)new BlockPos((int)box.f_82288_, (int)box.f_82289_, (int)box.f_82290_), (BlockPos)new BlockPos((int)box.f_82291_, (int)box.f_82292_, (int)box.f_82293_))) {
            BlockState state = level.m_8055_(pos);
            if (!SpinAbilityMethod.canBreakBlock(state)) continue;
            level.m_46961_(pos, true);
        }
    }

    private static boolean canBreakBlock(BlockState state) {
        BushBlock bush;
        Block block = state.m_60734_();
        if (block instanceof BushBlock && !((bush = (BushBlock)block) instanceof CropBlock) || state.m_60734_() instanceof FlowerBlock) {
            return true;
        }
        block = state.m_60734_();
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            return cropBlock.m_52307_(state);
        }
        return false;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Player player = event.player;
            Level level = player.f_19853_;
            AbilityCapability ability = (AbilityCapability)player.getCapability(AbilityCapabilityProvider.ABILITY_CAPABILITY).orElse(null);
            if (ability == null) {
                return;
            }
            if (!level.f_46443_) {
                Item handItem = player.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
                if (ability.isStandForSpin()) {
                    ModMessages.sendToPlayer(new StandForAbilityS2CPacket(true, player.m_19879_()), (ServerPlayer)player);
                    if (ability.getS() > 5) {
                        int lines = 200;
                        double radius = 1.0 + (double)ability.getS() * 0.05;
                        double angleOffset = Math.toRadians(180 * ability.getS());
                        RandomSource rand = player.f_19853_.f_46441_;
                        double centerX = player.m_20185_();
                        double centerY = player.m_20186_() + 1.0;
                        double centerZ = player.m_20189_();
                        if (handItem instanceof TemperedMasterSwordItem) {
                            radius *= 1.5;
                        } else if (handItem instanceof GoldenMasterSwordItem) {
                            radius *= 1.8;
                        } else if (handItem instanceof TrueMasterSwordItem) {
                            radius *= 2.0;
                        } else if (handItem instanceof FierceDeitySwordItem) {
                            radius *= 2.5;
                        }
                        for (int l = 0; l < lines; ++l) {
                            double angle = Math.PI * 2 / (double)lines * (double)l + angleOffset;
                            double xOffset = Math.cos(angle) * radius;
                            double zOffset = Math.sin(angle) * radius;
                            double motionX = (rand.m_188500_() - 0.5) * 0.1;
                            double motionY = (rand.m_188500_() - 0.5) * 0.1;
                            double motionZ = (rand.m_188500_() - 0.5) * 0.1;
                            if (handItem instanceof TemperedMasterSwordItem) {
                                ParticleHelper.spawnParticle(level, (ParticleOptions)ParticleTypes.f_123790_, centerX + xOffset, centerY, centerZ + zOffset, motionX, motionY, motionZ);
                                continue;
                            }
                            if (handItem instanceof GoldenMasterSwordItem) {
                                ParticleHelper.spawnParticle(level, (ParticleOptions)ParticleTypes.f_123784_, centerX + xOffset, centerY, centerZ + zOffset, motionX, motionY, motionZ);
                                continue;
                            }
                            if (handItem instanceof TrueMasterSwordItem) {
                                ParticleHelper.spawnParticle(level, (ParticleOptions)ParticleTypes.f_123785_, centerX + xOffset, centerY, centerZ + zOffset, motionX, motionY, motionZ);
                                continue;
                            }
                            if (!(handItem instanceof FierceDeitySwordItem)) continue;
                            ParticleHelper.spawnParticle(level, (ParticleOptions)ParticleTypes.f_123784_, centerX + xOffset, centerY, centerZ + zOffset, motionX, motionY, motionZ);
                            ParticleHelper.spawnParticle(level, (ParticleOptions)ParticleTypes.f_123790_, centerX + xOffset, centerY, centerZ + zOffset, motionX, motionY, motionZ);
                        }
                    }
                    ability.setS(ability.getS() + 1);
                }
                if (ability.getS() == 6) {
                    SpinAbilityMethod.damageEntitiesInRadius(player, level);
                }
                if (ability.getS() > 10) {
                    ability.setStandForSpin(false);
                    ModMessages.sendToPlayer(new StandForAbilityS2CPacket(false, player.m_19879_()), (ServerPlayer)player);
                    ability.setS(0);
                }
            }
        }
    }

    private static void playSpinSound(Item sword, Player player) {
        if (sword instanceof MasterSwordItem) {
            player.f_19853_.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.SPIN_SLASH1.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        } else if (sword instanceof TemperedMasterSwordItem) {
            player.f_19853_.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.SPIN_SLASH2.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        } else if (sword instanceof GoldenMasterSwordItem || sword instanceof TrueMasterSwordItem) {
            player.f_19853_.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.SPIN_SLASH3.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        } else if (sword instanceof FierceDeitySwordItem) {
            player.f_19853_.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.SPIN_SLASH3.get(), SoundSource.NEUTRAL, 1.0f, 0.7f);
        }
    }
}

