/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.loading.FMLPaths;

public class SupporterAccess {
    private static final Map<UUID, String> uuidToTokenMap = new HashMap<UUID, String>();
    private static final File PLAYER_TOKENS_FOLDER = FMLPaths.GAMEDIR.get().resolve("player_tokens").toFile();
    private static final String PUBLIC_KEY_BASE64 = "QRNJxhk1iTZhUnHW63UrhQyQnBjXb0WXcprzT5VlG4g";

    public static boolean registerPlayerToken(ServerPlayer player, String token) {
        boolean bl;
        if (!SupporterAccess.validateToken(player.m_20148_(), token)) {
            return false;
        }
        if (!PLAYER_TOKENS_FOLDER.exists()) {
            PLAYER_TOKENS_FOLDER.mkdirs();
        }
        File playerTokenFile = new File(PLAYER_TOKENS_FOLDER, player.m_20148_() + ".json");
        FileWriter writer = new FileWriter(playerTokenFile);
        try {
            Gson gson = new Gson();
            JsonObject root = new JsonObject();
            root.addProperty("token", token);
            gson.toJson((JsonElement)root, (Appendable)writer);
            uuidToTokenMap.put(player.m_20148_(), token);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        writer.close();
        return bl;
    }

    public static boolean isSupporter(UUID playerUUID) {
        File playerTokenFile;
        String token = uuidToTokenMap.get(playerUUID);
        if (token == null && (playerTokenFile = new File(PLAYER_TOKENS_FOLDER, playerUUID + ".json")).exists()) {
            try (FileReader reader = new FileReader(playerTokenFile);){
                Gson gson = new Gson();
                JsonObject root = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                token = root.get("token").getAsString();
                uuidToTokenMap.put(playerUUID, token);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return token != null && SupporterAccess.validateToken(playerUUID, token);
    }

    private static boolean validateToken(UUID playerUUID, String base64Signature) {
        try {
            byte[] signatureBytes = Base64.getUrlDecoder().decode(base64Signature);
            byte[] uuidBytes = playerUUID.toString().getBytes(StandardCharsets.UTF_8);
            byte[] publicKeyBytes = Base64.getUrlDecoder().decode(PUBLIC_KEY_BASE64);
            Signature verifier = Signature.getInstance("Ed25519");
            PublicKey pubKey = KeyFactory.getInstance("Ed25519").generatePublic(new X509EncodedKeySpec(SupporterAccess.toX509Format(publicKeyBytes)));
            verifier.initVerify(pubKey);
            verifier.update(uuidBytes);
            return verifier.verify(signatureBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static byte[] toX509Format(byte[] rawKey) {
        byte[] prefix = new byte[]{48, 42, 48, 5, 6, 3, 43, 101, 112, 3, 33, 0};
        byte[] fullKey = new byte[prefix.length + rawKey.length];
        System.arraycopy(prefix, 0, fullKey, 0, prefix.length);
        System.arraycopy(rawKey, 0, fullKey, prefix.length, rawKey.length);
        return fullKey;
    }
}

