/*
 * Decompiled with CFR 0.152.
 */
package org.merlin204.mimic.client.sound;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.merlin204.mimic.client.sound.MimicSounds;
import org.merlin204.mimic.entity.proteus.ProteusEntity;

@OnlyIn(value=Dist.CLIENT)
public class ProteusBossMusicManager {
    private static SimpleSoundInstance currentBossMusic;
    private static boolean isPlaying;

    public static void startBossMusic(Player player, ProteusEntity proteus) {
        if (isPlaying) {
            return;
        }
        SoundEvent soundEvent = (SoundEvent)MimicSounds.PHASE_1.get();
        switch (proteus.getPhase()) {
            case 2: {
                soundEvent = (SoundEvent)MimicSounds.PHASE_2.get();
            }
            case 3: {
                soundEvent = (SoundEvent)MimicSounds.PHASE_3.get();
            }
        }
        currentBossMusic = SimpleSoundInstance.m_119745_((SoundEvent)soundEvent);
        currentBossMusic = new SimpleSoundInstance(soundEvent.m_11660_(), SoundSource.NEUTRAL, 1.0f, 1.0f, SoundInstance.m_235150_(), true, 0, SoundInstance.Attenuation.NONE, player.m_20185_(), player.m_20186_(), player.m_20189_(), false);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)currentBossMusic);
        isPlaying = true;
        System.out.println("BOSS\u97f3\u4e50\u5f00\u59cb\u64ad\u653e");
    }

    public static void stopBossMusic() {
        if (!isPlaying || currentBossMusic == null) {
            return;
        }
        Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)currentBossMusic);
        isPlaying = false;
        currentBossMusic = null;
        System.out.println("BOSS\u97f3\u4e50\u505c\u6b62\u64ad\u653e");
    }

    public static boolean isPlaying() {
        return isPlaying;
    }

    public static void pauseBossMusic() {
        if (!isPlaying || currentBossMusic == null) {
            return;
        }
        Minecraft.m_91087_().m_91106_().m_120391_();
    }

    public static void resumeBossMusic() {
        if (!isPlaying || currentBossMusic == null) {
            return;
        }
        Minecraft.m_91087_().m_91106_().m_120407_();
    }

    static {
        isPlaying = false;
    }
}

