/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.modifier.special;

import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;

public class EarthquakeHelper {
    public static final byte FLAG = 83;

    public static void performEarthQuake(AbstractGolemEntity<?, ?> golem) {
        for (Map.Entry<GolemModifier, Integer> e : golem.getModifiers().entrySet()) {
            GolemModifier golemModifier = e.getKey();
            if (!(golemModifier instanceof Modifier)) continue;
            Modifier m = (Modifier)((Object)golemModifier);
            m.performEarthQuake(golem, e.getValue());
            break;
        }
        golem.m_9236_().m_7605_(golem, (byte)83);
    }

    public static void makeParticles(LivingEntity le, float vec, float math) {
        if (le.m_9236_().f_46443_) {
            for (int i1 = 0; i1 < 80 + le.m_217043_().m_188503_(12); ++i1) {
                double DeltaMovementX = le.m_217043_().m_188583_() * 0.07;
                double DeltaMovementY = le.m_217043_().m_188583_() * 0.07;
                double DeltaMovementZ = le.m_217043_().m_188583_() * 0.07;
                float f = Mth.m_14089_((float)(le.f_20883_ * ((float)Math.PI / 180)));
                float f1 = Mth.m_14031_((float)(le.f_20883_ * ((float)Math.PI / 180)));
                float angle = (float)Math.PI / 180 * le.f_20883_ + (float)i1;
                double extraX = 2.0f * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.3f;
                double extraZ = 2.0f * Mth.m_14089_((float)angle);
                double theta = (double)le.f_20883_ * (Math.PI / 180);
                double vecX = Math.cos(theta += 1.0);
                double vecZ = Math.sin(theta);
                int hitX = Mth.m_14107_((double)(le.m_20185_() + (double)vec * vecX + extraX));
                int hitY = Mth.m_14107_((double)le.m_20186_());
                int hitZ = Mth.m_14107_((double)(le.m_20189_() + (double)vec * vecZ + extraZ));
                BlockPos hit = new BlockPos(hitX, hitY, hitZ);
                BlockState block = le.m_9236_().m_8055_(hit.m_7495_());
                le.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), le.m_20185_() + (double)vec * vecX + extraX + (double)(f * math), le.m_20186_() + extraY, le.m_20189_() + (double)vec * vecZ + extraZ + (double)(f1 * math), DeltaMovementX, DeltaMovementY, DeltaMovementZ);
            }
        }
    }

    public static void launch(LivingEntity le, Entity e, float f) {
        double d0 = e.m_20185_() - le.m_20185_();
        double d1 = e.m_20189_() - le.m_20189_();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        e.m_5997_(d0 / d2 * (double)f, 0.375 * (double)f, d1 / d2 * (double)f);
    }

    public static double getExtraRange(AbstractGolemEntity<?, ?> golem, LivingEntity target) {
        for (Map.Entry<GolemModifier, Integer> e : golem.getModifiers().entrySet()) {
            GolemModifier golemModifier = e.getKey();
            if (!(golemModifier instanceof Modifier)) continue;
            Modifier m = (Modifier)((Object)golemModifier);
            return m.getEarthquakeRangeSqr(golem, target, e.getValue());
        }
        return 25.0;
    }

    public static interface Modifier {
        public void performEarthQuake(AbstractGolemEntity<?, ?> var1, int var2);

        default public double getEarthquakeRangeSqr(AbstractGolemEntity<?, ?> golem, LivingEntity target, int lv) {
            return 25.0;
        }
    }
}

