/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod;

import ewewukek.musketmod.Config;
import ewewukek.musketmod.DeferredDamage;
import ewewukek.musketmod.MusketMod;
import ewewukek.musketmod.Sounds;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BulletEntity
extends AbstractHurtingProjectile {
    public static final EntityDataAccessor<Float> INITIAL_SPEED = SynchedEntityData.m_135353_(BulletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> DROP_REDUCTION = SynchedEntityData.m_135353_(BulletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Byte> PELLET_COUNT = SynchedEntityData.m_135353_(BulletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final TagKey<Block> DESTROYED_BY_BULLETS = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)MusketMod.resource("destroyed_by_bullets"));
    public static final TagKey<Block> DROPPED_BY_BULLETS = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)MusketMod.resource("dropped_by_bullets"));
    public static final TagKey<EntityType<?>> HEADSHOTABLE = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)MusketMod.resource("headshotable"));
    public static final ResourceKey<DamageType> BULLET_DAMAGE = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)MusketMod.resource("bullet"));
    public static EntityType<BulletEntity> ENTITY_TYPE;
    public static final double GRAVITY = 0.05;
    public static final double AIR_FRICTION = 0.99;
    public static final double WATER_FRICTION = 0.6;
    public static final short LIFETIME = 100;
    public static final int HIT_PARTICLE_COUNT = 5;
    public static final float IGNITE_SECONDS = 5.0f;
    public float damage;
    public boolean touchedWater;
    public boolean headshot;
    public float distanceTravelled;
    public short tickCounter;
    private boolean packetSpeedReceived;

    public BulletEntity(EntityType<BulletEntity> entityType, Level level) {
        super(entityType, level);
    }

    public BulletEntity(Level level) {
        this(ENTITY_TYPE, level);
    }

    public boolean isFirstTick() {
        return this.tickCounter == 0;
    }

    public void discardOnNextTick() {
        this.tickCounter = (short)100;
    }

    public float calculateEnergyFraction() {
        double energy;
        double maxEnergy = Math.pow(((Float)this.f_19804_.m_135370_(INITIAL_SPEED)).floatValue(), 2.0);
        if (maxEnergy < (energy = this.m_20184_().m_82556_())) {
            maxEnergy = energy;
        }
        return (float)(energy / maxEnergy);
    }

    public int pelletCount() {
        byte count = (Byte)this.f_19804_.m_135370_(PELLET_COUNT);
        return count > 1 ? count : (byte)1;
    }

    public boolean soundEffectRoll() {
        int count = this.pelletCount();
        return count == 1 ? true : this.f_19796_.m_188501_() < 1.5f / (float)count;
    }

    public DamageSource getDamageSource() {
        BulletEntity attacker = this.m_19749_() != null ? this.m_19749_() : this;
        return this.m_9236_().m_269111_().m_268998_(BULLET_DAMAGE, (Entity)this, (Entity)attacker);
    }

    public void setVelocity(float bulletSpeed, Vec3 direction) {
        float tickSpeed = bulletSpeed / 20.0f;
        this.setInitialSpeed(tickSpeed);
        this.m_20256_(direction.m_82490_((double)tickSpeed));
    }

    public boolean m_6051_() {
        return false;
    }

    public void m_8119_() {
        Vec3 waterPos;
        Vec3 to;
        Vec3 from;
        Vec3 velocity;
        Level level;
        block34: {
            block32: {
                BlockHitResult hitResult;
                block33: {
                    BlockHitResult fluidHitResult;
                    EntityHitResult entityHitResult;
                    this.tickCounter = (short)(this.tickCounter + 1);
                    if (this.tickCounter > 100 || this.distanceTravelled > Config.bulletMaxDistance) {
                        this.m_146870_();
                        return;
                    }
                    level = this.m_9236_();
                    velocity = this.m_20184_();
                    from = this.m_20182_();
                    to = from.m_82549_(velocity);
                    waterPos = Vec3.f_82478_;
                    this.f_19798_ = this.m_204031_(FluidTags.f_13131_, 0.0);
                    if (this.f_19798_) {
                        waterPos = from;
                        velocity = velocity.m_82490_(0.6);
                        to = from.m_82549_(velocity);
                        this.m_20256_(velocity);
                    }
                    if ((hitResult = level.m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this))).m_6662_() != HitResult.Type.MISS) {
                        to = hitResult.m_82450_();
                    }
                    if ((entityHitResult = this.findHitEntity(from, to)) != null) {
                        hitResult = entityHitResult;
                        to = hitResult.m_82450_();
                    }
                    if (!this.f_19798_ && (fluidHitResult = level.m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this))).m_6662_() == HitResult.Type.BLOCK) {
                        FluidState fluid = level.m_6425_(fluidHitResult.m_82425_());
                        double distanceToFluid = fluidHitResult.m_82450_().m_82546_(from).m_82553_();
                        double distanceToHit = to.m_82546_(from).m_82553_();
                        if (fluid.m_205070_(FluidTags.f_13131_)) {
                            this.f_19798_ = true;
                            waterPos = fluidHitResult.m_82450_();
                            double speed = velocity.m_82553_();
                            double timeInWater = 1.0 - distanceToFluid / speed;
                            double newSpeed = speed * (1.0 - timeInWater + timeInWater * Math.pow(0.6, timeInWater));
                            if (hitResult.m_6662_() != HitResult.Type.MISS) {
                                if (distanceToFluid < distanceToHit) {
                                    if (distanceToHit < newSpeed) {
                                        timeInWater = (distanceToHit - distanceToFluid) / speed;
                                        newSpeed = speed * (1.0 - timeInWater + timeInWater * Math.pow(0.6, timeInWater));
                                    } else {
                                        hitResult = BlockHitResult.m_82426_(null, null, null);
                                    }
                                } else {
                                    fluidHitResult = BlockHitResult.m_82426_(null, null, null);
                                }
                            }
                            velocity = velocity.m_82490_(newSpeed / speed);
                            to = from.m_82549_(velocity);
                            this.m_20256_(velocity);
                            if (level.f_46443_ && fluidHitResult.m_6662_() != HitResult.Type.MISS) {
                                double yv = fluidHitResult.m_82434_() == Direction.UP ? 0.02 : 0.0;
                                this.createHitParticles((ParticleOptions)ParticleTypes.f_123769_, waterPos, new Vec3(0.0, yv, 0.0));
                                this.playHitSound(Sounds.BULLET_WATER_HIT, waterPos);
                            }
                        } else if (fluid.m_205070_(FluidTags.f_13132_) && (hitResult.m_6662_() == HitResult.Type.MISS || distanceToFluid < distanceToHit)) {
                            hitResult = fluidHitResult;
                            to = fluidHitResult.m_82450_();
                        }
                    }
                    if (this.f_19798_) {
                        this.touchedWater = true;
                        this.m_252836_();
                    }
                    if (!level.f_46443_) {
                        this.m_146868_(this.m_20094_() > 0);
                    }
                    if (hitResult.m_6662_() == HitResult.Type.MISS) break block32;
                    if (this.touchedWater) {
                        this.damage *= this.calculateEnergyFraction();
                    }
                    if (level.f_46443_) break block33;
                    this.m_6532_((HitResult)hitResult);
                    if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                        float destroyProbability = this.calculateEnergyFraction();
                        if (this.pelletCount() > 1) {
                            destroyProbability = 1.5f * destroyProbability / (float)this.pelletCount();
                        }
                        if (this.f_19796_.m_188501_() < destroyProbability) {
                            BlockPos blockPos = hitResult.m_82425_();
                            BlockState blockState = this.m_9236_().m_8055_(blockPos);
                            if (blockState.m_60713_(Blocks.f_50077_)) {
                                TntBlock.m_57433_((Level)this.m_9236_(), (BlockPos)blockPos);
                                level.m_7471_(blockPos, false);
                            } else if (blockState.m_204336_(DESTROYED_BY_BULLETS)) {
                                if (level.m_7471_(blockPos, false)) {
                                    blockState.m_60734_().m_6786_((LevelAccessor)level, blockPos, blockState);
                                }
                            } else if (blockState.m_204336_(DROPPED_BY_BULLETS) && level.m_7471_(blockPos, false)) {
                                Block.m_49950_((BlockState)blockState, (Level)level, (BlockPos)blockPos);
                            }
                        }
                    }
                    this.discardOnNextTick();
                    break block34;
                }
                if (hitResult.m_6662_() != HitResult.Type.BLOCK) break block34;
                Vec3 pos = hitResult.m_82450_();
                BlockState blockState = level.m_8055_(hitResult.m_82425_());
                BlockParticleOption particle = new BlockParticleOption(ParticleTypes.f_123794_, blockState);
                this.createHitParticles((ParticleOptions)particle, pos, Vec3.f_82478_);
                if (this.m_6060_()) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123800_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.01, 0.0);
                }
                this.playHitSound(blockState.m_60827_().m_56775_(), pos);
                this.m_146870_();
                break block34;
            }
            if (level.f_46443_ && !this.f_19798_ && this.soundEffectRoll()) {
                double length = velocity.m_82553_();
                Vec3 dir = velocity.m_82490_(1.0 / length);
                float volume = this.calculateEnergyFraction();
                AABB aabbSelection = this.m_20191_().m_82369_(velocity).m_82400_(8.0);
                Predicate<Entity> predicate = entity -> entity instanceof Player && !entity.equals((Object)this.m_19749_());
                for (Entity entity2 : this.m_9236_().m_6249_((Entity)this, aabbSelection, predicate)) {
                    Vec3 pos = new Vec3(entity2.m_20185_(), entity2.m_20188_(), entity2.m_20189_());
                    Vec3 diff = pos.m_82546_(from);
                    double proj = dir.m_82526_(diff);
                    if (!(proj > 0.0) || !(proj < length)) continue;
                    Vec3 projPos = from.m_82549_(dir.m_82490_(proj));
                    this.m_9236_().m_7785_(projPos.f_82479_, projPos.f_82480_, projPos.f_82481_, Sounds.BULLET_FLY_BY, this.m_5720_(), volume, 0.92f + 0.16f * this.f_19796_.m_188501_(), false);
                }
            }
        }
        if (level.f_46443_ && this.f_19798_) {
            double length;
            Vec3 step = velocity.m_82490_(1.0 / length);
            Vec3 pos = waterPos.m_82549_(step.m_82490_(0.5));
            float prob = 1.5f * this.calculateEnergyFraction() / (float)this.pelletCount();
            for (length = velocity.m_82553_(); length > 0.5; length -= 1.0) {
                pos = pos.m_82549_(step);
                if (!(this.f_19796_.m_188501_() < prob)) continue;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123795_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
            }
        }
        if (!this.f_19798_) {
            velocity = velocity.m_82490_(0.99);
        }
        double gravity = 0.05 * (double)(1.0f - ((Float)this.f_19804_.m_135370_(DROP_REDUCTION)).floatValue());
        this.m_20256_(velocity.m_82492_(0.0, gravity, 0.0));
        this.m_146884_(to);
        this.distanceTravelled = (float)((double)this.distanceTravelled + to.m_82546_(from).m_82553_());
        this.m_20101_();
    }

    public void m_5790_(EntityHitResult hitResult) {
        boolean ignite;
        if ((double)this.calculateEnergyFraction() < 0.05) {
            return;
        }
        float damageMult = 1.0f;
        Entity target = hitResult.m_82443_();
        Entity shooter = this.m_19749_();
        if (shooter != null && shooter.m_5647_() != null && shooter.m_5647_().m_83536_(target.m_5647_()) && !shooter.m_5647_().m_6260_()) {
            return;
        }
        if (shooter instanceof Player) {
            Player playerShooter = (Player)shooter;
            if (target instanceof Player) {
                Player playerTarget = (Player)target;
                damageMult = Config.pvpDamageMultiplier;
                if (!playerShooter.m_7099_(playerTarget)) {
                    return;
                }
            }
        } else {
            damageMult = Config.mobDamageMultiplier;
        }
        DamageSource source = this.getDamageSource();
        boolean bl = ignite = this.m_6060_() && target.m_6095_() != EntityType.f_20566_;
        if (this.pelletCount() == 1) {
            if (this.headshot) {
                damageMult *= Config.headshotDamageMultiplier;
            }
            target.f_19802_ = 0;
            target.m_6469_(source, this.damage * damageMult);
            if (ignite) {
                target.m_20254_(5);
            }
        } else {
            DeferredDamage.hurt(target, source, this.damage * (damageMult /= (float)this.pelletCount()), ignite ? 1.0f : 0.0f);
        }
    }

    public boolean checkHeadshot(Entity entity, AABB aabb, Vec3 start, Vec3 end) {
        if (this.pelletCount() > 1 || !entity.m_6095_().m_204039_(HEADSHOTABLE)) {
            return false;
        }
        double width = (aabb.f_82291_ - aabb.f_82288_ + aabb.f_82293_ - aabb.f_82290_) / 2.0;
        aabb = aabb.m_165887_(aabb.f_82292_ - width);
        return aabb.m_82371_(start, end).isPresent();
    }

    public EntityHitResult findHitEntity(Vec3 start, Vec3 end) {
        Entity resultEntity = null;
        Vec3 resultPos = null;
        double resultDist = 0.0;
        AABB aabbSelection = this.m_20191_().m_82369_(this.m_20184_()).m_82400_(0.5);
        for (Entity entity : this.m_9236_().m_6249_((Entity)this, aabbSelection, this::m_5603_)) {
            double dist;
            AABB aabb = entity.m_20191_();
            Optional clipResult = aabb.m_82371_(start, end);
            if (!clipResult.isPresent()) {
                aabb = aabb.m_82386_(entity.f_19790_ - entity.m_20185_(), entity.f_19791_ - entity.m_20186_(), entity.f_19792_ - entity.m_20189_());
                clipResult = aabb.m_82371_(start, end);
            }
            if (!clipResult.isPresent() || !((dist = start.m_82557_((Vec3)clipResult.get())) < resultDist) && resultEntity != null) continue;
            resultEntity = entity;
            resultPos = (Vec3)clipResult.get();
            resultDist = dist;
            this.headshot = this.checkHeadshot(entity, aabb, start, end);
        }
        return resultEntity != null ? new EntityHitResult(resultEntity, resultPos) : null;
    }

    public boolean m_5603_(Entity entity) {
        if (entity instanceof BulletEntity || entity == this.m_19749_()) {
            return false;
        }
        if (super.m_5603_(entity)) {
            return true;
        }
        Level level = this.m_9236_();
        return level.f_46443_ && entity instanceof LivingEntity;
    }

    public void createHitParticles(ParticleOptions particle, Vec3 position, Vec3 velocity) {
        float amount = 5.0f * this.calculateEnergyFraction() / (float)this.pelletCount();
        int count = (int)amount + (this.f_19796_.m_188501_() < amount % 1.0f ? 1 : 0);
        for (int i = 0; i < count; ++i) {
            this.m_9236_().m_7106_(particle, position.f_82479_, position.f_82480_, position.f_82481_, velocity.f_82479_ + 0.01 * this.f_19796_.m_188583_(), velocity.f_82480_ + 0.01 * this.f_19796_.m_188583_(), velocity.f_82481_ + 0.01 * this.f_19796_.m_188583_());
        }
    }

    public void playHitSound(SoundEvent sound, Vec3 position) {
        if (this.soundEffectRoll()) {
            this.m_9236_().m_7785_(position.f_82479_, position.f_82480_, position.f_82481_, sound, this.m_5720_(), this.calculateEnergyFraction(), 0.95f + 0.1f * this.f_19796_.m_188501_(), false);
        }
    }

    public void setInitialSpeed(float speed) {
        this.f_19804_.m_135381_(INITIAL_SPEED, (Object)Float.valueOf(speed));
    }

    public void setDropReduction(float reduction) {
        this.f_19804_.m_135381_(DROP_REDUCTION, (Object)Float.valueOf(reduction));
    }

    public void setPelletCount(int count) {
        this.f_19804_.m_135381_(PELLET_COUNT, (Object)((byte)count));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(INITIAL_SPEED, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DROP_REDUCTION, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(PELLET_COUNT, (Object)1);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.damage = compound.m_128457_("damage");
        this.distanceTravelled = compound.m_128457_("distanceTravelled");
        this.f_19804_.m_135381_(DROP_REDUCTION, (Object)Float.valueOf(compound.m_128457_("dropReduction")));
        this.f_19804_.m_135381_(PELLET_COUNT, (Object)compound.m_128445_("pelletCount"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("damage", this.damage);
        compound.m_128350_("distanceTravelled", this.distanceTravelled);
        compound.m_128350_("dropReduction", ((Float)this.f_19804_.m_135370_(DROP_REDUCTION)).floatValue());
        compound.m_128344_("pelletCount", ((Byte)this.f_19804_.m_135370_(PELLET_COUNT)).byteValue());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        Entity owner = this.m_19749_();
        return new ClientboundAddEntityPacket(this.m_19879_(), this.m_20148_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146909_(), this.m_146908_(), this.m_6095_(), owner != null ? owner.m_19879_() : 0, this.m_20184_().m_82490_(3.9 / (double)((Float)this.f_19804_.m_135370_(INITIAL_SPEED)).floatValue()), (double)this.m_6080_());
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        Vec3 packetVelocity = new Vec3(packet.m_131503_(), packet.m_131504_(), packet.m_131505_());
        this.m_20256_(packetVelocity.m_82490_(0.25641025641025644));
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        super.m_7350_(accessor);
        if (INITIAL_SPEED.equals(accessor) && this.m_9236_().f_46443_ && !this.packetSpeedReceived) {
            this.m_20256_(this.m_20184_().m_82490_((double)((Float)this.f_19804_.m_135370_(INITIAL_SPEED)).floatValue()));
            this.packetSpeedReceived = true;
        }
    }
}

