/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import ewewukek.musketmod.Config;
import ewewukek.musketmod.GunItem;
import ewewukek.musketmod.Items;
import ewewukek.musketmod.MusketMod;
import ewewukek.musketmod.ScopedMusketItem;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class ClientUtilities {
    public static boolean canUseScope;
    public static boolean attackKeyDown;
    public static boolean preventFiring;
    public static boolean disableMainHandEquipAnimation;
    public static boolean disableOffhandEquipAnimation;

    public static void registerItemProperties() {
        ClientUtilities.registerItemPredicate(MusketMod.resource("loaded"), (stack, level, entity, seed) -> GunItem.isLoaded(stack) ? 1.0f : 0.0f);
        ClientUtilities.registerItemPredicate(MusketMod.resource("loading"), (stack, level, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21120_(entity.m_7655_()) == stack ? 1.0f : 0.0f);
        ClientUtilities.registerItemPredicate(MusketMod.resource("aiming"), (stack, level, entity, seed) -> entity != null && ClientUtilities.shouldAim(entity, stack) ? 1.0f : 0.0f);
    }

    public static void registerItemPredicate(ResourceLocation location, ClampedItemPropertyFunction predicate) {
        ItemProperties.register((Item)Items.MUSKET, (ResourceLocation)location, (ItemPropertyFunction)predicate);
        ItemProperties.register((Item)Items.MUSKET_WITH_BAYONET, (ResourceLocation)location, (ItemPropertyFunction)predicate);
        ItemProperties.register((Item)Items.MUSKET_WITH_SCOPE, (ResourceLocation)location, (ItemPropertyFunction)predicate);
        ItemProperties.register((Item)Items.BLUNDERBUSS, (ResourceLocation)location, (ItemPropertyFunction)predicate);
        ItemProperties.register((Item)Items.PISTOL, (ResourceLocation)location, (ItemPropertyFunction)predicate);
    }

    public static void setScoping(Player player, boolean scoping) {
        if (scoping != ScopedMusketItem.isScoping) {
            player.m_5496_(scoping ? SoundEvents.f_144231_ : SoundEvents.f_144232_, 1.0f, 1.0f);
            ScopedMusketItem.isScoping = scoping;
        }
        if (!scoping) {
            ScopedMusketItem.recoilTicks = 0;
        }
    }

    public static boolean poseArm(LivingEntity entity, HumanoidModel<? extends LivingEntity> model, ModelPart arm) {
        Mob mob;
        if (entity.m_6117_() || entity instanceof Mob && !(mob = (Mob)entity).m_5912_()) {
            return false;
        }
        boolean isRight = arm == model.f_102811_;
        InteractionHand hand = entity.m_5737_() == (isRight ? HumanoidArm.RIGHT : HumanoidArm.LEFT) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        ItemStack stack = entity.m_21120_(hand);
        if (stack.m_41720_() instanceof GunItem && ClientUtilities.shouldAim(entity, stack, hand)) {
            arm.f_104203_ = model.f_102808_.f_104203_ + 0.1f - 1.5707964f;
            if (model.f_102817_) {
                arm.f_104203_ -= 0.4f;
            }
            arm.f_104204_ = model.f_102808_.f_104204_ + (isRight ? -0.3f : 0.3f);
            return true;
        }
        InteractionHand hand2 = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack stack2 = entity.m_21120_(hand2);
        Item item = stack2.m_41720_();
        if (item instanceof GunItem) {
            GunItem gun2 = (GunItem)item;
            if (ClientUtilities.shouldAim(entity, stack2, hand2) && (gun2.twoHanded() || stack == ItemStack.f_41583_)) {
                arm.f_104203_ = model.f_102808_.f_104203_ - 1.5f;
                if (model.f_102817_) {
                    arm.f_104203_ -= 0.4f;
                }
                arm.f_104204_ = model.f_102808_.f_104204_ + (isRight ? -0.6f : 0.6f);
                return true;
            }
        }
        return false;
    }

    public static boolean shouldAim(LivingEntity entity, ItemStack stack, InteractionHand hand) {
        if (entity.m_6117_()) {
            return false;
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            return mob.m_5912_() || mob instanceof Pillager;
        }
        return ((GunItem)stack.m_41720_()).canUseFrom(entity, hand) && (GunItem.isLoaded(stack) || Config.alwaysAim);
    }

    public static boolean shouldAim(LivingEntity entity, ItemStack stack) {
        InteractionHand hand = stack == entity.m_21205_() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        return ClientUtilities.shouldAim(entity, stack, hand);
    }

    public static void renderGunInHand(ItemInHandRenderer renderer, AbstractClientPlayer player, InteractionHand hand, float dt, float pitch, float swingProgress, float equipProgress, ItemStack stack, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        if (player.m_150108_()) {
            return;
        }
        HumanoidArm arm = hand == InteractionHand.MAIN_HAND ? player.m_5737_() : player.m_5737_().m_20828_();
        boolean isRightHand = arm == HumanoidArm.RIGHT;
        float sign = isRightHand ? 1.0f : -1.0f;
        GunItem gun = (GunItem)stack.m_41720_();
        if (!gun.canUseFrom((LivingEntity)player, hand)) {
            poseStack.m_85836_();
            poseStack.m_85837_((double)sign * 0.5, -0.5 - 0.6 * (double)equipProgress, -0.7);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(70.0f));
            renderer.m_269530_((LivingEntity)player, stack, isRightHand ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND, !isRightHand, poseStack, bufferSource, light);
            poseStack.m_85849_();
            return;
        }
        ItemStack activeStack = GunItem.getActiveStack(hand);
        if (stack == activeStack) {
            ClientUtilities.setEquipAnimationDisabled(hand, true);
        } else if (activeStack != null && activeStack.m_41720_() != gun) {
            ClientUtilities.setEquipAnimationDisabled(hand, false);
        }
        poseStack.m_85836_();
        poseStack.m_85837_((double)sign * 0.15, -0.25, -0.35);
        if (swingProgress > 0.0f) {
            float swingSharp = Mth.m_14031_((float)(Mth.m_14116_((float)swingProgress) * (float)Math.PI));
            float swingNormal = Mth.m_14031_((float)(swingProgress * (float)Math.PI));
            if (gun == Items.MUSKET_WITH_BAYONET) {
                poseStack.m_85837_((double)sign * -0.05 * (double)swingNormal, 0.0, 0.05 - 0.3 * (double)swingSharp);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(5.0f * swingSharp));
            } else {
                poseStack.m_85837_((double)sign * 0.05 * (double)(1.0f - swingNormal), 0.05 * (double)(1.0f - swingNormal), 0.05 - 0.4 * (double)swingSharp);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f + sign * 20.0f * (1.0f - swingSharp)));
            }
        } else if (player.m_6117_() && player.m_7655_() == hand) {
            Pair<Integer, Integer> loadingDuration = GunItem.getLoadingDuration(stack);
            int loadingStages = (Integer)loadingDuration.getLeft();
            int ticksPerLoadingStage = (Integer)loadingDuration.getRight();
            float usingTicks = (float)player.m_21252_() + dt - 1.0f;
            int loadingStage = GunItem.getLoadingStage(stack) + (int)(usingTicks / (float)ticksPerLoadingStage);
            int reloadDuration = GunItem.reloadDuration(stack);
            if (reloadDuration > 0 && usingTicks < (float)(reloadDuration + 5)) {
                poseStack.m_85837_(0.0, -0.3, 0.05);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(60.0f));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(sign * 10.0f));
                float t = 0.0f;
                if (usingTicks >= (float)ticksPerLoadingStage && loadingStage <= loadingStages && (usingTicks %= (float)ticksPerLoadingStage) < 4.0f) {
                    t = (4.0f - usingTicks) / 4.0f;
                }
                if (usingTicks >= (float)(ticksPerLoadingStage - 2) && loadingStage < loadingStages) {
                    t = (usingTicks - (float)ticksPerLoadingStage + 2.0f) / 2.0f;
                    t = Mth.m_14031_((float)(1.5707964f * Mth.m_14116_((float)t)));
                }
                poseStack.m_85837_(0.0, 0.0, 0.025 * (double)t);
                if (gun == Items.BLUNDERBUSS) {
                    poseStack.m_85837_(0.0, 0.0, -0.06);
                } else if (gun == Items.PISTOL) {
                    poseStack.m_85837_(0.0, 0.0, -0.12);
                }
            }
        } else if (ClientUtilities.isEquipAnimationDisabled(hand)) {
            if (equipProgress == 0.0f) {
                ClientUtilities.setEquipAnimationDisabled(hand, false);
                GunItem.setActiveStack(hand, null);
            }
        } else {
            poseStack.m_85837_(0.0, -0.6 * (double)equipProgress, 0.0);
        }
        renderer.m_269530_((LivingEntity)player, stack, isRightHand ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND, !isRightHand, poseStack, bufferSource, light);
        poseStack.m_85849_();
    }

    public static boolean isEquipAnimationDisabled(InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            return disableMainHandEquipAnimation;
        }
        return disableOffhandEquipAnimation;
    }

    public static void setEquipAnimationDisabled(InteractionHand hand, boolean disabled) {
        if (hand == InteractionHand.MAIN_HAND) {
            disableMainHandEquipAnimation = disabled;
        } else {
            disableOffhandEquipAnimation = disabled;
        }
    }
}

