/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod.mixin;

import ewewukek.musketmod.Config;
import ewewukek.musketmod.MusketMod;
import ewewukek.musketmod.RangedGunAttackGoal;
import ewewukek.musketmod.VanillaHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractSkeleton.class})
abstract class AbstractSkeletonMixin {
    private static final ResourceLocation LOOT_TABLE = MusketMod.resource("skeleton_weapon");

    AbstractSkeletonMixin() {
    }

    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    private void registerGoals(CallbackInfo ci) {
        AbstractSkeleton skeleton = (AbstractSkeleton)this;
        skeleton.f_21345_.m_25352_(4, (Goal)new RangedGunAttackGoal<AbstractSkeleton>(skeleton){
            private static final double speedModifier = 1.0;
            private static final float attackRadius = 15.0f;
            private int seeTime;
            private int attackDelay;
            private boolean strafingClockwise;
            private boolean strafingBackwards;
            private int strafingTime;
            {
                this.strafingTime = -1;
            }

            public boolean m_8045_() {
                return (this.isTargetValid() || !((AbstractSkeleton)this.mob).m_21573_().m_26571_()) && this.canUseGun();
            }

            public void m_8056_() {
                super.m_8056_();
                ((AbstractSkeleton)this.mob).m_21561_(true);
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                this.seeTime = 0;
                this.attackDelay = 0;
            }

            @Override
            public void m_8037_() {
                boolean wasSeeing;
                super.m_8037_();
                LivingEntity target = ((AbstractSkeleton)this.mob).m_5448_();
                if (target == null) {
                    return;
                }
                boolean canSee = ((AbstractSkeleton)this.mob).m_21574_().m_148306_((Entity)target);
                boolean bl = wasSeeing = this.seeTime > 0;
                if (canSee != wasSeeing) {
                    this.seeTime = 0;
                }
                this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
                float dist = ((AbstractSkeleton)this.mob).m_20270_((Entity)target);
                if (dist < 15.0f && this.seeTime >= 20) {
                    ((AbstractSkeleton)this.mob).m_21573_().m_26573_();
                    ++this.strafingTime;
                } else {
                    ((AbstractSkeleton)this.mob).m_21573_().m_5624_((Entity)target, 1.0);
                    this.strafingTime = -1;
                }
                if (this.strafingTime >= 20) {
                    if (((AbstractSkeleton)this.mob).m_217043_().m_188501_() < 0.3f) {
                        boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                    }
                    if (((AbstractSkeleton)this.mob).m_217043_().m_188501_() < 0.3f) {
                        this.strafingBackwards = !this.strafingBackwards;
                    }
                    this.strafingTime = 0;
                }
                if (this.strafingTime > -1) {
                    if (dist > 11.25f) {
                        this.strafingBackwards = false;
                    } else if (dist < 3.75f) {
                        this.strafingBackwards = true;
                    }
                    ((AbstractSkeleton)this.mob).m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                    Entity entity = ((AbstractSkeleton)this.mob).m_275832_();
                    if (entity instanceof Mob) {
                        Mob vehicle = (Mob)entity;
                        vehicle.m_21391_((Entity)target, 30.0f, 30.0f);
                    }
                    ((AbstractSkeleton)this.mob).m_21391_((Entity)target, 30.0f, 30.0f);
                } else {
                    ((AbstractSkeleton)this.mob).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                }
                if (this.seeTime < -60) {
                    this.attackDelay = Math.max(20, this.attackDelay);
                }
                if (this.attackDelay > 0) {
                    --this.attackDelay;
                } else if (this.isReady()) {
                    if (canSee) {
                        boolean isHard = ((AbstractSkeleton)this.mob).m_9236_().m_46791_() == Difficulty.HARD;
                        this.fire(isHard ? 2.0f : 6.0f);
                        this.attackDelay = 10;
                    }
                } else {
                    this.reload();
                }
            }

            @Override
            public void onReady() {
                boolean isHard = ((AbstractSkeleton)this.mob).m_9236_().m_46791_() == Difficulty.HARD;
                this.attackDelay = Math.max(isHard ? 20 : 40, this.attackDelay);
            }
        });
    }

    @Inject(method={"populateDefaultEquipmentSlots"}, at={@At(value="TAIL")})
    private void populateDefaultEquipmentSlots(CallbackInfo ci) {
        ItemStack weapon;
        AbstractSkeleton skeleton = (AbstractSkeleton)this;
        if (skeleton.m_9236_().m_46791_() != Difficulty.EASY && skeleton.m_217043_().m_188501_() < Config.musketSkeletonChance && !(weapon = VanillaHelper.getRandomWeapon((Entity)skeleton, LOOT_TABLE)).m_41619_()) {
            skeleton.m_8061_(EquipmentSlot.MAINHAND, weapon);
        }
    }
}

