/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.network;

import com.obscuria.obscureapi.ObscureAPI;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PlayerDataCapability {
    public static final Capability<PlayerData> OBS_DATA = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerData>(){});

    public static CompoundTag get(Player player) {
        return ((PlayerData)player.getCapability(PlayerDataCapability.OBS_DATA, null).orElse((Object)new PlayerData())).tag;
    }

    public static CompoundTag get(Player player, String name) {
        CompoundTag tag = PlayerDataCapability.get(player);
        return tag.m_128441_(name) ? (CompoundTag)tag.m_128423_(name) : new CompoundTag();
    }

    public static void put(Player player, CompoundTag tag) {
        player.getCapability(OBS_DATA, null).ifPresent(capability -> {
            capability.tag = tag;
            capability.syncPlayerData((Entity)player);
        });
    }

    public static void put(Player player, String name, CompoundTag data) {
        CompoundTag tag = PlayerDataCapability.get(player);
        if (tag.m_128441_(name)) {
            tag.m_128473_(name);
        }
        tag.m_128365_(name, (Tag)data);
        PlayerDataCapability.put(player, tag);
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        ObscureAPI.addNetworkMessage(PlayerDataMessage.class, PlayerDataMessage::buffer, PlayerDataMessage::new, PlayerDataMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerData.class);
    }

    public static class PlayerData {
        public CompoundTag tag = new CompoundTag();

        public void syncPlayerData(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                ObscureAPI.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerDataMessage(this));
            }
        }
    }

    public static class PlayerDataMessage {
        public PlayerData data;

        public PlayerDataMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerData();
            this.data.tag = buffer.m_130260_();
        }

        public PlayerDataMessage(PlayerData data) {
            this.data = data;
        }

        public static void buffer(PlayerDataMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_(message.data.tag);
        }

        public static void handler(PlayerDataMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    assert (Minecraft.m_91087_().f_91074_ != null);
                    PlayerData dataTag = (PlayerData)Minecraft.m_91087_().f_91074_.getCapability(OBS_DATA, null).orElse((Object)new PlayerData());
                    dataTag.tag = message.data.tag;
                }
            });
            context.setPacketHandled(true);
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerDataProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerData playerData = new PlayerData();
        private final LazyOptional<PlayerData> instance = LazyOptional.of(() -> this.playerData);

        private PlayerDataProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("obscuria", "data"), (ICapabilityProvider)new PlayerDataProvider());
            }
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
            return cap == OBS_DATA ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerData.tag;
        }

        public void deserializeNBT(Tag nbt) {
            this.playerData.tag = (CompoundTag)nbt;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (event.getEntity().m_9236_().m_5776_()) {
                return;
            }
            ((PlayerData)event.getEntity().getCapability(OBS_DATA, null).orElse((Object)new PlayerData())).syncPlayerData((Entity)event.getEntity());
        }

        @SubscribeEvent
        public static void onPlayerRespawned(PlayerEvent.PlayerRespawnEvent event) {
            if (event.getEntity().m_9236_().m_5776_()) {
                return;
            }
            ((PlayerData)event.getEntity().getCapability(OBS_DATA, null).orElse((Object)new PlayerData())).syncPlayerData((Entity)event.getEntity());
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (event.getEntity().m_9236_().m_5776_()) {
                return;
            }
            ((PlayerData)event.getEntity().getCapability(OBS_DATA, null).orElse((Object)new PlayerData())).syncPlayerData((Entity)event.getEntity());
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().reviveCaps();
            PlayerData original = (PlayerData)event.getOriginal().getCapability(OBS_DATA, null).orElse((Object)new PlayerData());
            PlayerData clone = (PlayerData)event.getEntity().getCapability(OBS_DATA, null).orElse((Object)new PlayerData());
            event.getOriginal().invalidateCaps();
            clone.tag = original.tag;
        }
    }
}

