/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public final class WorldUtils {
    public static void setDayTime(ServerLevel level, int ticks) {
        level.m_8615_(level.m_46468_() - level.m_46468_() % 24000L + (long)ticks);
    }

    public static void setNight(ServerLevel level) {
        WorldUtils.setDayTime(level, 18000);
    }

    public static void setDay(ServerLevel level) {
        WorldUtils.setDayTime(level, 0);
    }

    public static boolean isNight(Level world) {
        long roundedTime = world.m_46468_() % 24000L;
        return roundedTime >= 13000L && roundedTime <= 22000L;
    }

    public static boolean isDay(Level world) {
        return !WorldUtils.isNight(world);
    }

    public static boolean isNightOrDark(Level level, BlockPos pos) {
        int sky = level.m_45517_(LightLayer.SKY, pos);
        int block = level.m_45517_(LightLayer.BLOCK, pos);
        return (WorldUtils.isNight(level) ? block : Math.max(sky, block)) < 7;
    }

    @SafeVarargs
    public static boolean isBiomes(Biome biome, TagKey<Biome> ... biomes) {
        for (TagKey<Biome> key : biomes) {
            if (!Holder.m_205709_((Object)biome).m_203656_(key)) continue;
            return true;
        }
        return false;
    }

    public static void spawnItem(Level level, BlockPos pos, Item item) {
        WorldUtils.dropItem(level, pos, item, new Vec3(0.0, 0.0, 0.0));
    }

    public static void spawnItem(Level level, BlockPos pos, ItemStack stack) {
        WorldUtils.dropItem(level, pos, stack, new Vec3(0.0, 0.0, 0.0));
    }

    public static void dropItem(Level level, BlockPos pos, Item item) {
        WorldUtils.dropItem(level, pos, item, new Vec3(0.0, 0.25, 0.0));
    }

    public static void dropItem(Level level, BlockPos pos, ItemStack item) {
        WorldUtils.dropItem(level, pos, item, new Vec3(0.0, 0.25, 0.0));
    }

    public static void dropItem(Level level, BlockPos pos, Item item, Vec3 motion) {
        WorldUtils.dropItem(level, pos, item.m_7968_(), motion);
    }

    public static void dropItem(Level level, BlockPos pos, ItemStack item, Vec3 motion) {
        ItemEntity drop = new ItemEntity(EntityType.f_20461_, level);
        drop.m_20256_(motion);
        drop.m_32045_(item);
        drop.m_7678_((double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)((float)pos.m_123343_() + 0.5f), 0.0f, 0.0f);
        level.m_7967_((Entity)drop);
    }

    public static boolean growPlants(ItemStack stack, Level level, BlockPos pos, Player player) {
        BonemealableBlock bonemealableBlock;
        BlockState state = level.m_8055_(pos);
        int hook = ForgeEventFactory.onApplyBonemeal((Player)player, (Level)level, (BlockPos)pos, (BlockState)state, (ItemStack)stack);
        if (hook != 0) {
            return hook > 0;
        }
        Block block = state.m_60734_();
        if (block instanceof BonemealableBlock && (bonemealableBlock = (BonemealableBlock)block).m_7370_((LevelReader)level, pos, state, level.f_46443_)) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (bonemealableBlock.m_214167_(level, level.m_213780_(), pos, state)) {
                    bonemealableBlock.m_214148_(serverLevel, level.m_213780_(), pos, state);
                }
                stack.m_41774_(1);
            }
            return true;
        }
        return false;
    }
}

