/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.loot;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import insane96mcp.progressivebosses.setup.PBLoot;
import insane96mcp.progressivebosses.utils.LvlHelper;
import java.util.Set;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class SetCountPerLvl
extends LootItemConditionalFunction {
    final NumberProvider count;
    final float perLvlChance;
    final int lvlModifier;

    SetCountPerLvl(LootItemCondition[] lootItemConditions, NumberProvider count, float perLvlChance, int lvlModifier) {
        super(lootItemConditions);
        this.count = count;
        this.perLvlChance = perLvlChance;
        this.lvlModifier = lvlModifier;
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)PBLoot.SET_COUNT_PER_LVL.get();
    }

    public Set<LootContextParam<?>> m_6231_() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)LootContextParams.f_81455_);
        return builder.build();
    }

    public ItemStack m_7372_(ItemStack itemStack, LootContext lootContext) {
        Entity entity = (Entity)lootContext.m_165124_(LootContextParams.f_81455_);
        if (!(entity instanceof Mob)) {
            return itemStack;
        }
        Mob mob = (Mob)entity;
        if (!mob.getPersistentData().m_128441_("progressivebosses:difficulty")) {
            return itemStack;
        }
        int lvl = LvlHelper.getLvl((LivingEntity)mob);
        int tries = lvl + this.lvlModifier;
        for (int i = 0; i < tries; ++i) {
            float r = lootContext.m_230907_().m_188501_();
            if (!(r < this.perLvlChance)) continue;
            itemStack.m_41769_(this.count.m_142683_(lootContext));
        }
        itemStack.m_41774_(1);
        return itemStack;
    }

    public static LootItemConditionalFunction.Builder<?> setCountPerLvl(NumberProvider count, float perLvlChance, int lvlModifier) {
        return SetCountPerLvl.m_80683_(lootItemConditions -> new SetCountPerLvl((LootItemCondition[])lootItemConditions, count, perLvlChance, lvlModifier));
    }

    public static LootItemConditionalFunction.Builder<?> setCountPerLvl(NumberProvider count, float perLvlChance) {
        return SetCountPerLvl.m_80683_(lootItemConditions -> new SetCountPerLvl((LootItemCondition[])lootItemConditions, count, perLvlChance, 0));
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<SetCountPerLvl> {
        public void serialize(JsonObject jsonObject, SetCountPerLvl setCountPerLvl, JsonSerializationContext jsonSerializationContext) {
            super.m_6170_(jsonObject, (LootItemConditionalFunction)setCountPerLvl, jsonSerializationContext);
            jsonObject.add("count", jsonSerializationContext.serialize((Object)setCountPerLvl.count));
            jsonObject.add("per_lvl_chance", jsonSerializationContext.serialize((Object)Float.valueOf(setCountPerLvl.perLvlChance)));
            jsonObject.add("lvl_modifier", jsonSerializationContext.serialize((Object)setCountPerLvl.lvlModifier));
        }

        public SetCountPerLvl deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditions) {
            NumberProvider numberprovider = (NumberProvider)GsonHelper.m_13836_((JsonObject)jsonObject, (String)"count", (JsonDeserializationContext)jsonDeserializationContext, NumberProvider.class);
            return new SetCountPerLvl(lootItemConditions, numberprovider, Mth.m_14036_((float)GsonHelper.m_13820_((JsonObject)jsonObject, (String)"per_lvl_chance", (float)1.0f), (float)0.0f, (float)1.0f), GsonHelper.m_13824_((JsonObject)jsonObject, (String)"lvl_modifier", (int)0));
        }
    }
}

