/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.insanelib.util.json.ILGsonHelper;
import insane96mcp.progressivebosses.event.DragonPhaseEvent;
import insane96mcp.progressivebosses.module.dragon.DragonFeature;
import insane96mcp.progressivebosses.module.dragon.data.BlastAttackComponent;
import insane96mcp.progressivebosses.module.dragon.data.DragonComponent;
import insane96mcp.progressivebosses.network.SyncDragonAnger;
import java.lang.reflect.Type;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonAdapter(value=Serializer.class)
public class AngerComponent
implements DragonComponent {
    public int maxAnger;
    public int angerDuration;
    @Nullable
    public Float tickDown;
    @Nullable
    public Float damageToAngerRatio;
    @Nullable
    public Float crystalDestroyedAnger;
    public boolean forceAngeredWhenLastCrystalDestroyed;
    public static final String ANGER_TAG = "progressivebosses:anger";
    public static final String ANGERED_TAG = "progressivebosses:angered";

    public static float getAnger(EnderDragon dragon) {
        return dragon.getPersistentData().m_128457_(ANGER_TAG);
    }

    public void addAnger(EnderDragon dragon, float anger) {
        if (AngerComponent.isAngered(dragon)) {
            return;
        }
        float newAnger = AngerComponent.getAnger(dragon) + anger;
        dragon.getPersistentData().m_128350_(ANGER_TAG, newAnger);
        if (newAnger >= (float)this.maxAnger) {
            DragonFeature.getDragonDefinition(dragon).flatMap(stats -> stats.getComponent(BlastAttackComponent.class)).ifPresentOrElse(blastAttackComponent -> BlastAttackComponent.setForcedToBlast(dragon, true), () -> AngerComponent.setAngered(dragon, true));
        }
    }

    public static boolean isAngered(@NotNull EnderDragon dragon) {
        return dragon.getPersistentData().m_128471_(ANGERED_TAG);
    }

    public void tickAnger(EnderDragon dragon) {
        float tickDown;
        if (dragon.f_19797_ % 20 != 0) {
            return;
        }
        float anger = AngerComponent.getAnger(dragon);
        boolean angered = AngerComponent.isAngered(dragon);
        if (anger <= 0.0f) {
            if (angered) {
                AngerComponent.setAngered(dragon, false);
            }
            return;
        }
        if (anger >= (float)this.maxAnger && !angered) {
            return;
        }
        if (angered) {
            tickDown = (float)this.maxAnger / (float)this.angerDuration;
        } else if (this.tickDown != null) {
            tickDown = this.tickDown.floatValue();
        } else {
            return;
        }
        dragon.getPersistentData().m_128350_(ANGER_TAG, anger -= tickDown);
        if (anger <= 0.0f) {
            dragon.getPersistentData().m_128350_(ANGER_TAG, 0.0f);
            AngerComponent.setAngered(dragon, false);
        }
    }

    public static void setAngered(EnderDragon dragon, boolean angered) {
        dragon.getPersistentData().m_128379_(ANGERED_TAG, angered);
        if (!dragon.m_9236_().f_46443_) {
            ((ServerLevel)dragon.m_9236_()).m_6907_().forEach(player -> SyncDragonAnger.sync(player, dragon));
        }
    }

    @Override
    public void tick(EnderDragon dragon) {
        if (!dragon.m_9236_().f_46443_) {
            this.tickAnger(dragon);
        }
    }

    public static void tickClient(EnderDragon dragon) {
        if (AngerComponent.isAngered(dragon) && !dragon.m_31157_().m_31415_().m_7080_()) {
            dragon.f_31075_ -= 4;
            Vec3 vec3 = dragon.m_31174_(1.0f).m_82541_();
            vec3.m_82524_(-0.7853982f);
            double d0 = dragon.f_31080_.m_20185_();
            double d1 = dragon.f_31080_.m_20227_(0.5);
            double d2 = dragon.f_31080_.m_20189_();
            for (int i = 0; i < 4; ++i) {
                RandomSource randomsource = dragon.m_217043_();
                double d3 = d0 + randomsource.m_188583_() / 2.0;
                double d4 = d1 + randomsource.m_188583_() / 2.0;
                double d5 = d2 + randomsource.m_188583_() / 2.0;
                Vec3 vec31 = dragon.m_20184_();
                dragon.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123799_, true, d3, d4, d5, -vec3.f_82479_ * (double)0.01f + vec31.f_82479_, -vec3.f_82480_ * (double)0.04f + vec31.f_82480_, -vec3.f_82481_ * (double)0.01f + vec31.f_82481_);
                vec3.m_82524_(0.19634955f);
            }
        }
    }

    @Override
    public void onPhaseChange(DragonPhaseEvent.Change event, EnderDragon dragon) {
        if (event.getNewPhase().equals((Object)EnderDragonPhase.f_31386_)) {
            AngerComponent.setAngered(dragon, false);
        }
    }

    @Override
    public void onLivingHurt(LivingHurtEvent event, EnderDragon dragon) {
        if (this.damageToAngerRatio == null) {
            return;
        }
        this.addAnger(dragon, this.damageToAngerRatio.floatValue() * event.getAmount());
    }

    @Override
    public void onCrystalDestroyed(EnderDragon dragon, EndCrystal endCrystal, int crystalsAlive) {
        if (this.crystalDestroyedAnger != null) {
            this.addAnger(dragon, this.crystalDestroyedAnger.floatValue() <= 1.0f ? this.crystalDestroyedAnger.floatValue() * (float)this.maxAnger : this.crystalDestroyedAnger.floatValue());
        }
        if (crystalsAlive == 0 && this.forceAngeredWhenLastCrystalDestroyed) {
            DragonFeature.getDragonDefinition(dragon).flatMap(stats -> stats.getComponent(BlastAttackComponent.class)).ifPresent(component -> BlastAttackComponent.setForcedToBlast(dragon, true));
        }
    }

    public static class Serializer
    implements JsonDeserializer<AngerComponent> {
        public AngerComponent deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            AngerComponent component = new AngerComponent();
            JsonObject jObject = json.getAsJsonObject();
            component.maxAnger = GsonHelper.m_13927_((JsonObject)jObject, (String)"max_anger");
            component.angerDuration = GsonHelper.m_13927_((JsonObject)jObject, (String)"anger_duration");
            component.tickDown = ILGsonHelper.getAsNullableFloat((JsonObject)jObject, (String)"tick_down");
            component.damageToAngerRatio = ILGsonHelper.getAsNullableFloat((JsonObject)jObject, (String)"damage_to_anger_ratio");
            component.crystalDestroyedAnger = ILGsonHelper.getAsNullableFloat((JsonObject)jObject, (String)"crystal_destroyed_anger");
            component.forceAngeredWhenLastCrystalDestroyed = GsonHelper.m_13855_((JsonObject)jObject, (String)"force_angered_when_last_crystal_destroyed", (boolean)false);
            return component;
        }
    }
}

