/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.progressivebosses.event.DragonPhaseEvent;
import insane96mcp.progressivebosses.event.PBEventFactory;
import insane96mcp.progressivebosses.module.dragon.DragonFeature;
import insane96mcp.progressivebosses.module.dragon.data.DragonComponent;
import insane96mcp.progressivebosses.module.dragon.data.DragonValue;
import insane96mcp.progressivebosses.module.dragon.data.PhaseChanger;
import insane96mcp.progressivebosses.module.dragon.phase.DragonBlastAttackPhase;
import java.lang.reflect.Type;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import org.jetbrains.annotations.Nullable;

@JsonAdapter(value=Serializer.class)
public class BlastAttackComponent
implements DragonComponent,
PhaseChanger {
    public DragonValue chance;
    public DragonValue range;
    @Nullable
    public DragonValue knockback;
    public DragonValue chargeUpTime;
    public DragonValue damage;
    public int timeBeforeTakeoff;
    public DragonValue cooldown;
    public static final String LAST_BLAST_TAG = "progressivebosses:last_blast";
    private static final String FORCE_BLAST_TAG = "progressivebosses:force_blast";

    public static boolean isForcedToBlast(EnderDragon dragon) {
        return dragon.getPersistentData().m_128471_(FORCE_BLAST_TAG);
    }

    public static void setForcedToBlast(EnderDragon dragon, boolean forcedToBlast) {
        dragon.getPersistentData().m_128379_(FORCE_BLAST_TAG, forcedToBlast);
    }

    public void blast(DragonPhaseEvent.Change event, EnderDragon dragon, boolean forceBegin) {
        if (event.getOldPhase() != EnderDragonPhase.f_31387_ && (dragon.m_31157_().m_31418_(event.getOldPhase()).m_7080_() || dragon.m_31157_().m_31418_(event.getNewPhase()).m_7080_())) {
            event.setNewPhase(DragonBlastAttackPhase.getPhaseType());
            if (forceBegin) {
                DragonPhaseInstance phase = dragon.m_31157_().m_31418_(event.getNewPhase());
                phase.m_7083_();
                PBEventFactory.onDragonPhaseBegin(dragon, phase);
            }
            BlastAttackComponent.setForcedToBlast(dragon, false);
        } else {
            event.setNewPhase(EnderDragonPhase.f_31380_);
        }
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public EnderDragonPhase<?> getPhase() {
        return DragonBlastAttackPhase.getPhaseType();
    }

    @Override
    public boolean shouldExecute(EnderDragon dragon) {
        if (DragonBlastAttackPhase.isInCooldown(dragon, dragon.m_9236_(), this)) {
            return false;
        }
        if (DragonFeature.getRandomPlayer(dragon, dragon.m_9236_(), this.range.getIntValue(dragon)) == null) {
            return false;
        }
        if (BlastAttackComponent.isForcedToBlast(dragon)) {
            return true;
        }
        double chance = this.chance.getValue(dragon);
        if (chance == 0.0) {
            return false;
        }
        return dragon.m_217043_().m_188500_() < chance;
    }

    @Override
    public void execute(EnderDragon dragon, boolean forceBegin) {
        BlastAttackComponent.setForcedToBlast(dragon, true);
    }

    @Override
    public void onPhaseChange(DragonPhaseEvent.Change event, EnderDragon dragon) {
        if (BlastAttackComponent.isForcedToBlast(dragon) && event.getNewPhase() != EnderDragonPhase.f_31386_) {
            this.blast(event, dragon, false);
        }
    }

    public static class Serializer
    implements JsonDeserializer<BlastAttackComponent> {
        public BlastAttackComponent deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            BlastAttackComponent component = new BlastAttackComponent();
            JsonObject jObject = json.getAsJsonObject();
            component.chance = (DragonValue)GsonHelper.m_13836_((JsonObject)jObject, (String)"chance", (JsonDeserializationContext)context, DragonValue.class);
            component.range = (DragonValue)GsonHelper.m_13836_((JsonObject)jObject, (String)"range", (JsonDeserializationContext)context, DragonValue.class);
            component.knockback = (DragonValue)GsonHelper.m_13845_((JsonObject)jObject, (String)"knockback", null, (JsonDeserializationContext)context, DragonValue.class);
            component.chargeUpTime = (DragonValue)GsonHelper.m_13836_((JsonObject)jObject, (String)"charge_up_time", (JsonDeserializationContext)context, DragonValue.class);
            component.damage = (DragonValue)GsonHelper.m_13836_((JsonObject)jObject, (String)"damage", (JsonDeserializationContext)context, DragonValue.class);
            component.timeBeforeTakeoff = GsonHelper.m_13824_((JsonObject)jObject, (String)"time_before_takeoff", (int)0);
            component.cooldown = (DragonValue)GsonHelper.m_13836_((JsonObject)jObject, (String)"cooldown", (JsonDeserializationContext)context, DragonValue.class);
            return component;
        }
    }
}

