/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import insane96mcp.progressivebosses.ProgressiveBosses;
import insane96mcp.progressivebosses.data.ComponentRegistry;
import insane96mcp.progressivebosses.event.DragonPhaseEvent;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public interface DragonComponent {
    default public void tick(EnderDragon dragon) {
    }

    default public void apply(EnderDragon dragon) {
    }

    default public void onPhaseChange(DragonPhaseEvent.Change event, EnderDragon dragon) {
    }

    default public void onCrystalDestroyed(EnderDragon dragon, EndCrystal endCrystal, int crystalsAlive) {
    }

    default public void onEntityJoinLevel(EntityJoinLevelEvent event, EnderDragon dragon) {
    }

    default public void onLivingHurt(LivingHurtEvent event, EnderDragon dragon) {
    }

    default public void onLivingDeath(LivingDeathEvent event, EnderDragon dragon) {
    }

    public static List<DragonComponent> deserializeList(JsonObject jObject, String memberName, JsonDeserializationContext context) {
        ArrayList<DragonComponent> components = new ArrayList<DragonComponent>();
        if (!jObject.has(memberName)) {
            return components;
        }
        JsonArray aModifiers = GsonHelper.m_13933_((JsonObject)jObject, (String)memberName);
        for (JsonElement jsonElement : aModifiers) {
            JsonObject jObjectComponent = jsonElement.getAsJsonObject();
            ResourceLocation componentId = ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)jObjectComponent, (String)"id"));
            Type component = ComponentRegistry.getComponent(componentId);
            if (component == null) {
                ProgressiveBosses.LOGGER.warn("BossComponent {} does not exist. Skipping", (Object)componentId);
                continue;
            }
            components.add((DragonComponent)context.deserialize((JsonElement)jObjectComponent, component));
        }
        return components;
    }
}

