/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.progressivebosses.event.DragonPhaseEvent;
import insane96mcp.progressivebosses.event.PBEventFactory;
import insane96mcp.progressivebosses.module.dragon.DragonFeature;
import insane96mcp.progressivebosses.module.dragon.data.DragonComponent;
import insane96mcp.progressivebosses.module.dragon.data.DragonValue;
import insane96mcp.progressivebosses.module.dragon.data.PhaseChanger;
import insane96mcp.progressivebosses.module.dragon.phase.PBDragonStrafePlayerPhase;
import java.lang.reflect.Type;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;

@JsonAdapter(value=Serializer.class)
public class StrafePlayerComponent
implements DragonComponent,
PhaseChanger {
    public DragonValue chance;
    public DragonValue minAcidballShot;
    public DragonValue maxAcidballShot;
    public DragonValue cooldownBetweenShots;
    public DragonValue acidballPerShot;
    private static final String FORCE_STRAFE_TAG = "progressivebosses:force_strafe";

    public static boolean isForcedToStrafe(EnderDragon dragon) {
        return StrafePlayerComponent.getForcedToStrafe(dragon) > 0;
    }

    public static int getForcedToStrafe(EnderDragon dragon) {
        return dragon.getPersistentData().m_128451_(FORCE_STRAFE_TAG);
    }

    public static void setForcedToStrafe(EnderDragon dragon, int forcedToStrafe) {
        dragon.getPersistentData().m_128405_(FORCE_STRAFE_TAG, forcedToStrafe);
    }

    public int getAcidballShot(EnderDragon dragon, RandomSource random) {
        int min = Math.max(1, this.minAcidballShot.getIntValue(dragon));
        int max = Math.max(1, this.maxAcidballShot.getIntValue(dragon));
        return Mth.m_216271_((RandomSource)random, (int)min, (int)max);
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public EnderDragonPhase<?> getPhase() {
        return PBDragonStrafePlayerPhase.getPhaseType();
    }

    @Override
    public boolean shouldExecute(EnderDragon dragon) {
        if (DragonFeature.getRandomPlayer(dragon, dragon.m_9236_(), 96) == null) {
            return false;
        }
        if (StrafePlayerComponent.isForcedToStrafe(dragon)) {
            return true;
        }
        double chance = this.chance.getValue(dragon);
        if (chance == 0.0) {
            return false;
        }
        return dragon.m_217043_().m_188500_() < chance;
    }

    @Override
    public void execute(EnderDragon dragon, boolean forceBegin) {
        dragon.m_31157_().m_31416_(PBDragonStrafePlayerPhase.getPhaseType());
        if (StrafePlayerComponent.isForcedToStrafe(dragon)) {
            StrafePlayerComponent.setForcedToStrafe(dragon, StrafePlayerComponent.getForcedToStrafe(dragon) - 1);
        }
        if (forceBegin) {
            DragonPhaseInstance phase = dragon.m_31157_().m_31418_(PBDragonStrafePlayerPhase.getPhaseType());
            phase.m_7083_();
            PBEventFactory.onDragonPhaseBegin(dragon, phase);
        }
    }

    @Override
    public void onPhaseChange(DragonPhaseEvent.Change event, EnderDragon dragon) {
        if (event.getNewPhase().equals((Object)EnderDragonPhase.f_31378_)) {
            event.setNewPhase(PBDragonStrafePlayerPhase.getPhaseType());
        }
    }

    @Override
    public void onCrystalDestroyed(EnderDragon dragon, EndCrystal endCrystal, int crystalsAlive) {
        StrafePlayerComponent.setForcedToStrafe(dragon, StrafePlayerComponent.getForcedToStrafe(dragon) + 1);
    }

    public static class Serializer
    implements JsonDeserializer<StrafePlayerComponent> {
        public StrafePlayerComponent deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            StrafePlayerComponent sittingComponent = new StrafePlayerComponent();
            JsonObject jObject = json.getAsJsonObject();
            sittingComponent.chance = (DragonValue)GsonHelper.m_13836_((JsonObject)jObject, (String)"chance", (JsonDeserializationContext)context, DragonValue.class);
            sittingComponent.minAcidballShot = (DragonValue)GsonHelper.m_13836_((JsonObject)jObject, (String)"min_acidball_shot", (JsonDeserializationContext)context, DragonValue.class);
            sittingComponent.maxAcidballShot = (DragonValue)GsonHelper.m_13836_((JsonObject)jObject, (String)"max_acidball_shot", (JsonDeserializationContext)context, DragonValue.class);
            sittingComponent.cooldownBetweenShots = (DragonValue)GsonHelper.m_13836_((JsonObject)jObject, (String)"cooldown_between_shots", (JsonDeserializationContext)context, DragonValue.class);
            sittingComponent.acidballPerShot = (DragonValue)GsonHelper.m_13836_((JsonObject)jObject, (String)"acidball_per_shot", (JsonDeserializationContext)context, DragonValue.class);
            return sittingComponent;
        }
    }
}

