/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.phase;

import insane96mcp.progressivebosses.module.dragon.DragonFeature;
import insane96mcp.progressivebosses.module.dragon.data.AngerComponent;
import insane96mcp.progressivebosses.module.dragon.data.BlastAttackComponent;
import insane96mcp.progressivebosses.module.dragon.data.DragonDefinition;
import insane96mcp.progressivebosses.module.dragon.data.PhaseChanger;
import insane96mcp.progressivebosses.network.BeginBlastAttackPhase;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.AbstractDragonSittingPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class DragonBlastAttackPhase
extends AbstractDragonSittingPhase {
    private static EnderDragonPhase<DragonBlastAttackPhase> PHASE;
    private int blowUpTick;
    private int timeToBlowUp;

    public DragonBlastAttackPhase(EnderDragon pDragon) {
        super(pDragon);
    }

    public void m_6991_() {
        RandomSource random = this.f_31176_.m_217043_();
        double x = this.f_31176_.m_20185_();
        double y = this.f_31176_.m_20186_() + 2.0;
        double z = this.f_31176_.m_20189_();
        if (--this.blowUpTick > 30) {
            int particles = (int)((1.0f - (float)this.blowUpTick / (float)this.timeToBlowUp) * 200.0f);
            for (int i = 0; i < particles; ++i) {
                double r = 96.0;
                double v = r / 2.0;
                double x1 = x + (double)random.m_188501_() * r - v;
                double y1 = y + (double)random.m_188501_() * r - v;
                double z1 = z + (double)random.m_188501_() * r - v;
                Vec3 dir = new Vec3(x1 - x, y1 - y, z1 - z).m_82541_().m_82490_(-4.0 * (1.0 - (double)this.blowUpTick / (double)this.timeToBlowUp));
                this.f_31176_.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123799_, true, x1, y1, z1, dir.f_82479_, dir.f_82480_, dir.f_82481_);
            }
        }
        this.f_31176_.f_31082_ = this.blowUpTick > 9 ? 0.25f + (float)this.blowUpTick / (float)this.timeToBlowUp * 0.6f : (this.blowUpTick >= 4 ? 0.35f - (float)(8 - this.blowUpTick + 1) * 0.08f : 0.8f - (float)(4 - this.blowUpTick) * 0.05f);
        if (this.blowUpTick == 4) {
            for (int i = 0; i < 4000; ++i) {
                double r = 8.0;
                double v = r / 2.0;
                double x1 = x + (double)this.f_31176_.m_9236_().f_46441_.m_188501_() * r - v;
                double y1 = y + (double)this.f_31176_.m_9236_().f_46441_.m_188501_() * r - v;
                double z1 = z + (double)this.f_31176_.m_9236_().f_46441_.m_188501_() * r - v;
                Vec3 dir = new Vec3(x1 - x, y1 - y, z1 - z).m_82541_().m_82490_(5.0);
                this.f_31176_.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123799_, true, x1, y1, z1, dir.f_82479_, dir.f_82480_, dir.f_82481_);
            }
        }
    }

    public void m_6989_() {
        DragonDefinition definition = DragonFeature.getDragonDefinition(this.f_31176_).orElse(null);
        if (definition == null) {
            return;
        }
        BlastAttackComponent component = definition.getComponent(BlastAttackComponent.class).orElse(null);
        if (component == null) {
            return;
        }
        if (--this.blowUpTick == 0) {
            int radius = component.range.getIntValue(this.f_31176_);
            int sqrRadius = radius * radius;
            List entities = this.f_31176_.m_9236_().m_6249_((Entity)null, this.f_31176_.m_20191_().m_82400_((double)radius), EntitySelector.f_20406_);
            float damage = component.damage.getValue(this.f_31176_);
            for (Entity entity : entities) {
                double multiplier;
                if (entity == this.f_31176_ || entity instanceof EnderDragonPart || this.f_31176_.m_20280_(entity) > (double)sqrRadius) continue;
                double distanceX = entity.m_20185_() - this.f_31176_.m_20185_();
                double distanceY = entity.m_20186_() - this.f_31176_.m_20186_();
                double distanceZ = entity.m_20189_() - this.f_31176_.m_20189_();
                double distance = Math.sqrt(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ);
                double d = multiplier = component.knockback == null ? 0.0 : (double)component.knockback.getValue(this.f_31176_);
                if (multiplier > 0.0) {
                    double d2;
                    LivingEntity living;
                    if (!(entity instanceof Player)) {
                        multiplier *= 2.0;
                    }
                    if (entity instanceof LivingEntity) {
                        living = (LivingEntity)entity;
                        d2 = 1.0 - living.m_21133_(Attributes.f_22278_);
                    } else {
                        d2 = 1.0;
                    }
                    double knockbackReduction = d2;
                    entity.m_5997_(distanceX / distance * multiplier * knockbackReduction, Math.max(1.0, distanceY / distance * multiplier * 0.5 * knockbackReduction), distanceZ / distance * multiplier * knockbackReduction);
                    if (entity instanceof LivingEntity) {
                        living = (LivingEntity)entity;
                        living.f_19864_ = true;
                    }
                }
                entity.m_6469_(this.f_31176_.m_269291_().m_269036_((Entity)this.f_31176_, (Entity)this.f_31176_), damage);
            }
            for (int i = 0; i < 8; ++i) {
                this.f_31176_.m_9236_().m_6263_(null, this.f_31176_.m_20185_() + (double)(this.f_31176_.m_217043_().m_188501_() * 48.0f) - 24.0, this.f_31176_.m_20186_() + (double)(this.f_31176_.m_217043_().m_188501_() * 48.0f) - 24.0, this.f_31176_.m_20189_() + (double)(this.f_31176_.m_217043_().m_188501_() * 48.0f) - 24.0, SoundEvents.f_11913_, SoundSource.HOSTILE, 4.0f, 0.7f);
            }
            definition.getComponent(AngerComponent.class).ifPresent(angerComponent -> AngerComponent.setAngered(this.f_31176_, true));
            this.f_31176_.getPersistentData().m_128356_("progressivebosses:last_blast", this.f_31176_.m_9236_().m_46467_());
        } else if (this.blowUpTick <= -component.timeBeforeTakeoff) {
            if (!PhaseChanger.trySetNewPhase(this.f_31176_, definition, this.m_7309_())) {
                this.f_31176_.m_31157_().m_31416_(EnderDragonPhase.f_31381_);
            }
        } else {
            if (this.blowUpTick % 5 == 0 && this.blowUpTick > 10) {
                this.f_31176_.m_9236_().m_6269_(null, (Entity)this.f_31176_, SoundEvents.f_11894_, SoundSource.HOSTILE, 4.0f, 0.5f + (1.0f - (float)this.blowUpTick / (float)this.timeToBlowUp) * 1.2f);
            }
            this.f_31176_.f_31082_ = 1.0f - (float)(this.timeToBlowUp - this.blowUpTick) / (float)this.timeToBlowUp;
        }
    }

    public void m_7083_() {
        DragonDefinition definition = DragonFeature.getDragonDefinition(this.f_31176_).orElse(null);
        if (definition == null) {
            return;
        }
        BlastAttackComponent component = definition.getComponent(BlastAttackComponent.class).orElse(null);
        if (component == null) {
            return;
        }
        this.initBlowUpTick(component.chargeUpTime.getIntValue(this.f_31176_));
        if (!this.f_31176_.m_9236_().f_46443_) {
            ((ServerLevel)this.f_31176_.m_9236_()).m_6907_().forEach(player -> BeginBlastAttackPhase.sync(player, this.f_31176_, this.timeToBlowUp));
        }
    }

    public void initBlowUpTick(int ticks) {
        this.timeToBlowUp = this.blowUpTick = Math.max(10, ticks);
    }

    public static boolean isInCooldown(EnderDragon dragon, Level level, BlastAttackComponent component) {
        if (component.cooldown == null) {
            return false;
        }
        return level.m_46467_() - dragon.getPersistentData().m_128454_("progressivebosses:last_blast") < (long)component.cooldown.getIntValue(dragon);
    }

    @NotNull
    public EnderDragonPhase<DragonBlastAttackPhase> m_7309_() {
        return PHASE;
    }

    public static EnderDragonPhase<DragonBlastAttackPhase> getPhaseType() {
        return PHASE;
    }

    public static void init() {
        PHASE = EnderDragonPhase.m_31402_(DragonBlastAttackPhase.class, (String)"BlastAttack");
    }
}

