/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.elderguardian;

import insane96mcp.insanelib.ai.ILNearestAttackableTargetGoal;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.module.base.TagsFeature;
import insane96mcp.insanelib.util.MCUtils;
import insane96mcp.insanelib.util.ModNBTData;
import insane96mcp.progressivebosses.ProgressiveBosses;
import insane96mcp.progressivebosses.module.elderguardian.data.ElderGuardianStats;
import insane96mcp.progressivebosses.module.elderguardian.data.ElderGuardianStatsReloadListener;
import insane96mcp.progressivebosses.setup.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;

@LoadFeature(module="progressivebosses:elder_guardian")
public class ElderGuardianFeature
extends Feature {
    public static ResourceLocation LEVEL;
    public static ResourceLocation PREVIOUSLY_NEAR_ELDER_GUARDIAN;
    public static ResourceLocation ADVENTURE_MESSAGE;
    public static ResourceLocation ELDER_MINION_COOLDOWN;
    public static ResourceLocation ELDER_MINION;
    public static String APPROACHING_ELDER_GUARDIAN;
    @Config(description="If true, the player will not be able to break blocks when an Elder Guardian is nearby. This also removes Mining Fatigue.")
    public static Boolean adventure;
    @Config(description="The range from any Elder Guardian at which players get adventure mode. This range is doubled when YUNG's Better Ocean Monuments is installed.")
    public static Double adventureRange;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        LEVEL = this.createDataKey("level");
        PREVIOUSLY_NEAR_ELDER_GUARDIAN = this.createDataKey("previously_near_elder_guardian");
        ADVENTURE_MESSAGE = this.createDataKey("adventure_message");
        ELDER_MINION_COOLDOWN = this.createDataKey("elder_minion_cooldown");
        ELDER_MINION = this.createDataKey("elder_minion");
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.m_9236_().f_46443_ || !this.isEnabled() || !adventure.booleanValue() || event.player.f_19797_ % 20 != 0 || !event.player.m_6084_()) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)event.player;
        ServerLevel world = (ServerLevel)serverPlayer.m_9236_();
        boolean previouslyNearElderGuardian = (Boolean)ModNBTData.get((Entity)serverPlayer, (ResourceLocation)PREVIOUSLY_NEAR_ELDER_GUARDIAN, Boolean.class);
        boolean adventureMessage = (Boolean)ModNBTData.get((Entity)serverPlayer, (ResourceLocation)ADVENTURE_MESSAGE, Boolean.class);
        float range = adventureRange.floatValue();
        if (ModList.get().isLoaded("betteroceanmonuments")) {
            range *= 2.0f;
        }
        boolean nearElderGuardian = !world.m_45976_(ElderGuardian.class, serverPlayer.m_20191_().m_82400_((double)range)).isEmpty();
        ModNBTData.put((Entity)serverPlayer, (ResourceLocation)PREVIOUSLY_NEAR_ELDER_GUARDIAN, (Object)nearElderGuardian);
        if (serverPlayer.f_8941_.m_9290_() == GameType.SURVIVAL && nearElderGuardian) {
            serverPlayer.f_8941_.m_143473_(GameType.ADVENTURE);
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132156_, (float)GameType.ADVENTURE.m_46392_()));
            if (!adventureMessage) {
                serverPlayer.m_213846_((Component)Component.m_237115_((String)APPROACHING_ELDER_GUARDIAN));
                ModNBTData.put((Entity)serverPlayer, (ResourceLocation)ADVENTURE_MESSAGE, (Object)true);
            }
        } else if (serverPlayer.f_8941_.m_9290_() == GameType.ADVENTURE && !nearElderGuardian && previouslyNearElderGuardian) {
            serverPlayer.f_8941_.m_143473_(GameType.SURVIVAL);
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132156_, (float)GameType.SURVIVAL.m_46392_()));
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity;
        if (!(this.isEnabled() && adventure.booleanValue() && (livingEntity = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
        boolean previouslyNearElderGuardian = (Boolean)ModNBTData.get((Entity)serverPlayer, (ResourceLocation)PREVIOUSLY_NEAR_ELDER_GUARDIAN, Boolean.class);
        if (previouslyNearElderGuardian && serverPlayer.f_8941_.m_9290_() == GameType.ADVENTURE) {
            serverPlayer.f_8941_.m_143473_(GameType.SURVIVAL);
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132156_, (float)GameType.SURVIVAL.m_46392_()));
        }
    }

    @SubscribeEvent
    public void onExplosionDetonate(ExplosionEvent.Start event) {
        boolean nearElderGuardian;
        if (!this.isEnabled() || !adventure.booleanValue() || event.getExplosion().getExploder() == null || event.getExplosion().f_46010_ == Explosion.BlockInteraction.KEEP) {
            return;
        }
        boolean bl = nearElderGuardian = !event.getLevel().m_45976_(ElderGuardian.class, event.getExplosion().getExploder().m_20191_().m_82400_(adventureRange.doubleValue())).isEmpty();
        if (nearElderGuardian) {
            event.setCanceled(true);
            event.getLevel().m_255391_(event.getExplosion().getExploder(), event.getExplosion().getPosition().f_82479_, event.getExplosion().getPosition().f_82480_, event.getExplosion().getPosition().f_82481_, event.getExplosion().f_46017_, event.getExplosion().f_46009_, Level.ExplosionInteraction.NONE);
        }
    }

    @SubscribeEvent
    public void onElderGuardianDeath(LivingDeathEvent event) {
        LivingEntity livingEntity;
        if (!this.isEnabled() || !((livingEntity = event.getEntity()) instanceof ElderGuardian)) {
            return;
        }
        ElderGuardian elderGuardian = (ElderGuardian)livingEntity;
        List elderGuardiansNearby = elderGuardian.m_9236_().m_6249_((Entity)elderGuardian, elderGuardian.m_20191_().m_82400_(64.0), entity -> entity instanceof ElderGuardian);
        if (elderGuardiansNearby.isEmpty()) {
            return;
        }
        int newLvl = ElderGuardianFeature.getGuardianLvl(elderGuardian) + 1;
        elderGuardian.m_5496_(SoundEvents.f_11880_, 2.0f, 0.5f);
        for (Entity elderGuardianNearby : elderGuardiansNearby) {
            ModNBTData.put((Entity)elderGuardianNearby, (ResourceLocation)LEVEL, (Object)newLvl);
            this.updateHealth((ElderGuardian)elderGuardianNearby);
            ElderGuardianFeature.updateExperienceDropped(elderGuardian);
        }
    }

    public static byte getGuardianLvl(ElderGuardian elderGuardian) {
        return (Byte)ModNBTData.get((Entity)elderGuardian, (ResourceLocation)LEVEL, Byte.class);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onSpawn(EntityJoinLevelEvent event) {
        ElderGuardian elderGuardian;
        Entity entity;
        if (event.getLevel().f_46443_ || !this.isEnabled() || !((entity = event.getEntity()) instanceof ElderGuardian) || TagsFeature.isSpawnType((MobSpawnType)MobSpawnType.SPAWNER, (LivingEntity)(elderGuardian = (ElderGuardian)entity))) {
            return;
        }
        if (ModNBTData.contains((Entity)elderGuardian, (ResourceLocation)LEVEL)) {
            return;
        }
        ModNBTData.put((Entity)elderGuardian, (ResourceLocation)LEVEL, (Object)0);
        Optional<ElderGuardianStats> oElderGuardianStats = ElderGuardianFeature.getStats(elderGuardian);
        this.updateHealth(elderGuardian);
        ElderGuardianFeature.updateExperienceDropped(elderGuardian);
        if (!ModNBTData.contains((Entity)elderGuardian, (ResourceLocation)ELDER_MINION_COOLDOWN) && oElderGuardianStats.isPresent()) {
            ModNBTData.put((Entity)elderGuardian, (ResourceLocation)ELDER_MINION_COOLDOWN, (Object)oElderGuardianStats.get().minionCooldown);
        }
    }

    public static Optional<ElderGuardianStats> getStats(ElderGuardian elderGuardian) {
        byte lvl = ElderGuardianFeature.getGuardianLvl(elderGuardian);
        if (!ElderGuardianStatsReloadListener.STATS_MAP.containsKey(lvl)) {
            return Optional.empty();
        }
        return Optional.of(ElderGuardianStatsReloadListener.STATS_MAP.get(lvl));
    }

    @SubscribeEvent
    public void onDamageDealt(LivingHurtEvent event) {
        Entity entity;
        if (event.getEntity().m_9236_().f_46443_ || !this.isEnabled() || !((entity = event.getSource().m_7639_()) instanceof ElderGuardian)) {
            return;
        }
        ElderGuardian elderGuardian = (ElderGuardian)entity;
        Optional<ElderGuardianStats> oElderGuardianStats = ElderGuardianFeature.getStats(elderGuardian);
        if (oElderGuardianStats.isEmpty()) {
            return;
        }
        event.setAmount(event.getAmount() * (1.0f + oElderGuardianStats.get().bonusDamage));
        if (!event.getSource().m_276093_(DamageTypes.f_268440_)) {
            elderGuardian.m_5634_(oElderGuardianStats.get().regenOnAttack / 2.0f);
        }
    }

    private void updateHealth(ElderGuardian elderGuardian) {
        Optional<ElderGuardianStats> oElderGuardianStats = ElderGuardianFeature.getStats(elderGuardian);
        if (oElderGuardianStats.isEmpty()) {
            return;
        }
        AttributeInstance maxHealth = elderGuardian.m_21051_(Attributes.f_22276_);
        if (maxHealth == null) {
            return;
        }
        double prevMaxHealth = maxHealth.m_22115_();
        maxHealth.m_22100_((double)oElderGuardianStats.get().health);
        elderGuardian.m_5634_((float)((double)oElderGuardianStats.get().health - prevMaxHealth));
        if (oElderGuardianStats.get().absorption > 0.0f) {
            elderGuardian.m_7911_(oElderGuardianStats.get().absorption);
        }
    }

    @SubscribeEvent
    public void update(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity;
        if (event.getEntity().m_9236_().f_46443_ || !this.isEnabled() || !((livingEntity = event.getEntity()) instanceof ElderGuardian)) {
            return;
        }
        ElderGuardian elderGuardian = (ElderGuardian)livingEntity;
        Level world = event.getEntity().m_9236_();
        if (elderGuardian.m_21223_() <= 0.0f) {
            return;
        }
        int cooldown = (Integer)ModNBTData.get((Entity)elderGuardian, (ResourceLocation)ELDER_MINION_COOLDOWN, Integer.class);
        if (cooldown > 0) {
            ModNBTData.put((Entity)elderGuardian, (ResourceLocation)ELDER_MINION_COOLDOWN, (Object)(cooldown - 1));
            return;
        }
        Optional<ElderGuardianStats> oElderGuardianStats = ElderGuardianFeature.getStats(elderGuardian);
        if (oElderGuardianStats.isEmpty()) {
            return;
        }
        ModNBTData.put((Entity)elderGuardian, (ResourceLocation)ELDER_MINION_COOLDOWN, (Object)oElderGuardianStats.get().minionCooldown);
        int radius = 24;
        BlockPos pos1 = elderGuardian.m_20183_().m_7918_(-radius, -radius, -radius);
        BlockPos pos2 = elderGuardian.m_20183_().m_7918_(radius, radius, radius);
        AABB bb = new AABB(pos1, pos2);
        List players = world.m_45976_(ServerPlayer.class, bb);
        if (players.isEmpty()) {
            return;
        }
        List guardiansInRange = world.m_45976_(Guardian.class, elderGuardian.m_20191_().m_82400_(12.0));
        if (guardiansInRange.size() >= 6) {
            return;
        }
        ElderGuardianFeature.summonMinion(world, new Vec3(elderGuardian.m_20185_(), elderGuardian.m_20186_(), elderGuardian.m_20189_()));
    }

    public static void summonMinion(Level world, Vec3 pos) {
        Guardian elderMinion = new Guardian(EntityType.f_20455_, world);
        ModNBTData.put((Entity)elderMinion, (ResourceLocation)ELDER_MINION, (Object)true);
        elderMinion.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        elderMinion.m_6593_((Component)Component.m_237115_((String)Util.m_137492_((String)"entity", (ResourceLocation)ELDER_MINION)));
        elderMinion.f_21355_ = BuiltInLootTables.f_78712_;
        MCUtils.applyModifier((LivingEntity)elderMinion, (Attribute)((Attribute)ForgeMod.SWIM_SPEED.get()), (UUID)Strings.AttributeModifiers.SWIM_SPEED_BONUS_UUID, (String)"progressivebosses:swim_speed_bonus", (double)2.0, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE);
        MCUtils.applyModifier((LivingEntity)elderMinion, (Attribute)Attributes.f_22276_, (UUID)Strings.AttributeModifiers.BONUS_HEALTH_UUID, (String)"progressivebosses:bonus_health", (double)-0.5, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE);
        ArrayList<Goal> goalsToRemove = new ArrayList<Goal>();
        for (WrappedGoal prioritizedGoal : elderMinion.f_21346_.f_25345_) {
            if (!(prioritizedGoal.m_26015_() instanceof NearestAttackableTargetGoal)) continue;
            goalsToRemove.add(prioritizedGoal.m_26015_());
        }
        goalsToRemove.forEach(arg_0 -> ((GoalSelector)elderMinion.f_21345_).m_25363_(arg_0));
        elderMinion.f_21346_.m_25352_(1, (Goal)new ILNearestAttackableTargetGoal((Mob)elderMinion, Player.class, false).setIgnoreLineOfSight());
        world.m_7967_((Entity)elderMinion);
    }

    public static void updateExperienceDropped(ElderGuardian elderGuardian) {
        Optional<ElderGuardianStats> oElderGuardianStats = ElderGuardianFeature.getStats(elderGuardian);
        if (oElderGuardianStats.isEmpty()) {
            return;
        }
        elderGuardian.f_21364_ = oElderGuardianStats.get().xpDropped;
    }

    @SubscribeEvent
    public void onElderGuardianDamage(LivingDamageEvent event) {
        LivingEntity livingEntity;
        if (!this.isEnabled() || !((livingEntity = event.getEntity()) instanceof ElderGuardian)) {
            return;
        }
        ElderGuardian elderGuardian = (ElderGuardian)livingEntity;
        Optional<ElderGuardianStats> oElderGuardianStats = ElderGuardianFeature.getStats(elderGuardian);
        if (oElderGuardianStats.isEmpty()) {
            return;
        }
        float damageReduction = oElderGuardianStats.get().damageResistance;
        event.setAmount(event.getAmount() * (1.0f - damageReduction));
    }

    static {
        APPROACHING_ELDER_GUARDIAN = ProgressiveBosses.lang("elder_guardian.approach");
        adventure = true;
        adventureRange = 48.0;
    }
}

