/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.ai;

import insane96mcp.progressivebosses.module.wither.ai.WitherChargeAttackGoal;
import insane96mcp.progressivebosses.module.wither.entity.PBWither;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class WitherRangedAttackGoal
extends Goal {
    private final PBWither wither;
    public final int[] headAttackTimes = new int[3];
    private int unseenTargetSeconds = 0;
    private final float attackRadiusSqr;

    public WitherRangedAttackGoal(PBWither wither, float attackRadius) {
        this.wither = wither;
        this.attackRadiusSqr = attackRadius * attackRadius;
        for (int i = 0; i < 3; ++i) {
            this.headAttackTimes[i] = wither.m_217043_().m_216339_(30, 60);
        }
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.wither.getInvulnerableTicks() > 0) {
            return false;
        }
        boolean anyHeadHasTarget = false;
        for (int i = 0; i < 3; ++i) {
            int targetId = this.wither.getAlternativeTarget(i);
            if (targetId == 0) continue;
            anyHeadHasTarget = true;
        }
        return anyHeadHasTarget;
    }

    public boolean m_8045_() {
        return this.m_8036_() || !this.wither.m_21573_().m_26571_();
    }

    public void m_8041_() {
    }

    public void m_8037_() {
        for (int i = 0; i < 3; ++i) {
            LivingEntity target;
            int targetId = this.wither.getAlternativeTarget(i);
            if (targetId <= 0 || (target = (LivingEntity)this.wither.m_9236_().m_6815_(targetId)) == null || target.m_21224_()) continue;
            double distanceSqr = this.wither.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            boolean canSee = this.wither.m_21574_().m_148306_((Entity)target);
            if (i == 0 && this.wither.f_19797_ % 20 == 0) {
                if (canSee) {
                    if (this.unseenTargetSeconds > 0) {
                        --this.unseenTargetSeconds;
                    }
                } else if (this.wither.canCharge() && this.wither.stats.attack.charge != null && this.wither.stats.attack.charge.targetUnseen != null) {
                    ++this.unseenTargetSeconds;
                    int seconds = this.unseenTargetSeconds - this.wither.stats.attack.charge.targetUnseen.secondsUnseen;
                    if (seconds > 0) {
                        this.wither.tryCharge(Math.min((float)seconds * this.wither.stats.attack.charge.targetUnseen.chancePerSecond, this.wither.stats.attack.charge.targetUnseen.maxChance), WitherChargeAttackGoal.ChargeType.TARGET_UNSEEN);
                    }
                }
            }
            if (distanceSqr <= (double)this.attackRadiusSqr) {
                this.wither.m_20334_(0.0, this.wither.m_20184_().f_82480_, 0.0);
            }
            if (i == 0) {
                this.wither.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            }
            if (this.wither.barrageTicks > 0) {
                if (this.wither.barrageTicks % (3 * this.wither.stats.attack.barrage.attackSpeed) != i * this.wither.stats.attack.barrage.attackSpeed) continue;
                float inaccuracy = this.wither.stats.attack.barrage.inaccuracy.getValue(this.wither);
                this.wither.performRangedAttack(i, target.m_20185_() + Mth.m_216263_((RandomSource)this.wither.m_217043_(), (double)(-inaccuracy), (double)inaccuracy), target.m_20186_() + (double)target.m_20192_() * 0.5 + Mth.m_216263_((RandomSource)this.wither.m_217043_(), (double)(-inaccuracy), (double)inaccuracy), target.m_20189_() + Mth.m_216263_((RandomSource)this.wither.m_217043_(), (double)(-inaccuracy), (double)inaccuracy), false);
                continue;
            }
            if (!(distanceSqr <= (double)this.attackRadiusSqr) || this.wither.getBarrageChargeUpTicks() > 0) continue;
            int n = i;
            this.headAttackTimes[n] = this.headAttackTimes[n] - 1;
            if (this.headAttackTimes[n] > 0) continue;
            if (!canSee) {
                return;
            }
            this.wither.performRangedAttack(i, target);
            int attackSpeedDelta = this.wither.stats.attack.attackSpeedFar - this.wither.stats.attack.attackSpeedNear;
            double distanceRatio = distanceSqr / (double)this.attackRadiusSqr;
            this.headAttackTimes[i] = (int)((double)this.wither.stats.attack.attackSpeedNear + (double)attackSpeedDelta * distanceRatio) + this.wither.m_217043_().m_216339_(-5, 6);
            if (i == 0 || this.wither.needsHealing()) continue;
            this.headAttackTimes[i] = (int)((float)this.headAttackTimes[i] * this.wither.stats.attack.sideHeadsAttackSpeedMultiplier);
        }
    }

    public boolean m_183429_() {
        return true;
    }
}

