/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.charm;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class UniversalAttractorItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"attractor").active(CastData.builder().type(CastType.INTERRUPTIBLE).build()).icon((player, stack, ability) -> ability + "_" + this.getMode((ItemStack)stack).name().toLowerCase(Locale.ROOT)).stat(StatData.builder((String)"radius").initialValue(3.0, 5.0).upgradeModifier(UpgradeOperation.ADD, 1.0).formatValue(value -> (int)MathUtils.round((double)value, (int)1)).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-2883584).borderBottom(-15245846).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).build()).loot(LootData.builder().entry(LootCollections.ANTHROPOGENIC).build()).build();
    }

    public Mode getMode(ItemStack stack) {
        return Mode.byIndex(NBTUtils.getInt((ItemStack)stack, (String)"mode", (int)Mode.ATTRACT.getIndex()));
    }

    public void setMode(ItemStack stack, Mode mode) {
        NBTUtils.setInt((ItemStack)stack, (String)"mode", (int)mode.getIndex());
    }

    public void cycleMode(ItemStack stack, int steps) {
        this.setMode(stack, this.getMode(stack).cycle(steps));
    }

    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        this.cycleMode(stack, 1);
    }

    public void wornTick(LivingEntity entity, ItemStack stack) {
        Player player;
        if (!(entity instanceof Player) || (player = (Player)entity).m_20193_().m_5776_() || !this.canPlayerUseActiveAbility(player, stack, "attractor") || this.getMode(stack) == Mode.NEUTRAL) {
            return;
        }
        Vec3 pos = player.m_20182_();
        RandomSource random = player.m_217043_();
        Level level = player.m_20193_();
        for (ItemEntity item : level.m_45976_(ItemEntity.class, player.m_20191_().m_82400_(this.getAbilityValue(stack, "attractor", "radius")))) {
            if (!item.m_6084_() || item.m_32063_()) continue;
            Vec3 oldPos = new Vec3(item.m_20185_(), item.m_20186_() - (double)(item.m_20206_() * 3.0f), item.m_20189_());
            if (this.getMode(stack) == Mode.ATTRACT) {
                item.m_20219_(pos);
                UniversalAttractorItem.createLine(ParticleUtils.constructSimpleSpark((Color)new Color(200 + random.m_188503_(55), random.m_188503_(50), random.m_188503_(50)), (float)0.2f, (int)20, (float)0.8f), level, pos, oldPos);
                continue;
            }
            item.m_20256_(item.m_20182_().m_82546_(pos).m_82541_().m_82490_(0.5));
            if (item.f_19862_) continue;
            UniversalAttractorItem.createLine(ParticleUtils.constructSimpleSpark((Color)new Color(random.m_188503_(50), random.m_188503_(50), 200 + random.m_188503_(55)), (float)0.2f, (int)3, (float)0.5f), level, pos, oldPos);
        }
    }

    public static void createLine(ParticleOptions particle, Level level, Vec3 start, Vec3 end) {
        Vec3 delta = end.m_82546_(start);
        Vec3 dir = delta.m_82541_();
        double amount = delta.m_82553_() * 3.0;
        for (double i = 0.0; i < amount; i += 1.0) {
            double progress = i * delta.m_82553_() / amount;
            ((ServerLevel)level).m_8767_(particle, start.f_82479_ + dir.f_82479_ * progress, start.f_82480_ + dir.f_82480_ * progress + 1.0, start.f_82481_ + dir.f_82481_ * progress, 0, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static enum Mode {
        ATTRACT(1),
        REPEL(2),
        NEUTRAL(3);

        private final int index;

        public static Mode byIndex(int index) {
            for (Mode mode : Mode.values()) {
                if (mode.getIndex() != index) continue;
                return mode;
            }
            throw new IllegalArgumentException();
        }

        public Mode cycle(int steps) {
            Mode[] modes = Mode.values();
            int index = (this.ordinal() + steps) % modes.length;
            if (index < 0) {
                index += modes.length;
            }
            return modes[index];
        }

        public int getIndex() {
            return this.index;
        }

        private Mode(int index) {
            this.index = index;
        }
    }

    @Mod.EventBusSubscriber
    public static class UniversalAttractorEvent {
        @SubscribeEvent
        public static void onItemPickedUp(EntityItemPickupEvent event) {
            UniversalAttractorItem relic;
            ItemStack stack;
            Player player;
            block6: {
                block5: {
                    Item item;
                    player = event.getEntity();
                    stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.UNIVERSAL_ATTRACTOR.get()));
                    if (player.m_20193_().m_5776_() || !((item = stack.m_41720_()) instanceof UniversalAttractorItem)) break block5;
                    relic = (UniversalAttractorItem)item;
                    if (NBTUtils.getBoolean((ItemStack)stack, (String)"toggled", (boolean)false)) break block6;
                }
                return;
            }
            ItemStack item = event.getItem().m_32055_();
            ItemEntity itemEntity = event.getItem();
            if (itemEntity.m_20193_().f_46441_.m_188500_() <= (double)item.m_41613_() / (double)item.m_41741_()) {
                if (itemEntity.m_19749_() != null && itemEntity.m_19749_().m_20148_().equals(player.m_20148_())) {
                    return;
                }
                relic.spreadExperience((LivingEntity)player, stack, 1);
            }
        }
    }
}

