/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.hands;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class PocketPistonItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"discarding").stat(StatData.builder((String)"interaction").initialValue(0.2, 0.4).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.15).formatValue(value -> (int)MathUtils.round((double)(value * 100.0), (int)1)).build()).build()).ability(AbilityData.builder((String)"interaction").requiredLevel(5).stat(StatData.builder((String)"range").initialValue(0.2, 0.4).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.15).formatValue(value -> (int)MathUtils.round((double)(value * 100.0), (int)1)).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-3434424).borderBottom(-9803158).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(15).step(100).build()).loot(LootData.builder().entry(LootCollections.VILLAGE).build()).build();
    }

    public void wornTick(LivingEntity entity, ItemStack stack) {
        Player player;
        block3: {
            block2: {
                if (!(entity instanceof Player)) break block2;
                player = (Player)entity;
                if (this.canUseAbility(stack, "interaction")) break block3;
            }
            return;
        }
        float modifier = (float)this.getAbilityValue(stack, "interaction", "range");
        EntityUtils.applyAttribute((LivingEntity)player, (ItemStack)stack, (Attribute)((Attribute)ForgeMod.ENTITY_REACH.get()), (float)modifier, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
        EntityUtils.applyAttribute((LivingEntity)player, (ItemStack)stack, (Attribute)((Attribute)ForgeMod.BLOCK_REACH.get()), (float)modifier, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    public void onUnequip(LivingEntity entity, ItemStack stack) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        EntityUtils.removeAttribute((LivingEntity)player, (ItemStack)stack, (Attribute)((Attribute)ForgeMod.ENTITY_REACH.get()), (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
        EntityUtils.removeAttribute((LivingEntity)player, (ItemStack)stack, (Attribute)((Attribute)ForgeMod.BLOCK_REACH.get()), (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    @Mod.EventBusSubscriber
    public static class PocketPistonEvent {
        @SubscribeEvent
        public static void onContacted(BlockEvent.EntityPlaceEvent event) {
            PocketPistonItem relic;
            Entity entity = event.getEntity();
            if (!(entity instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.POCKET_PISTON.get()));
            Item item = stack.m_41720_();
            if (!(item instanceof PocketPistonItem) || !(relic = (PocketPistonItem)item).canPlayerUseActiveAbility(player, stack, "discarding")) {
                return;
            }
            int distance = (int)Math.sqrt(event.getPos().m_203198_(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_()));
            if (distance >= 5) {
                relic.spreadExperience((LivingEntity)player, stack, 1);
            }
        }

        @SubscribeEvent
        public static void onContacted(LivingDestroyBlockEvent event) {
            PocketPistonItem relic;
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.POCKET_PISTON.get()));
            Item item = stack.m_41720_();
            if (!(item instanceof PocketPistonItem) || !(relic = (PocketPistonItem)item).canPlayerUseActiveAbility(player, stack, "discarding")) {
                return;
            }
            int distance = (int)Math.sqrt(event.getPos().m_203198_(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_()));
            if (distance >= 5) {
                relic.spreadExperience((LivingEntity)player, stack, 1);
            }
        }

        @SubscribeEvent
        public static void onAttacking(AttackEntityEvent event) {
            PocketPistonItem relic;
            LivingEntity target;
            ItemStack stack;
            Player player;
            block5: {
                block4: {
                    player = event.getEntity();
                    stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.POCKET_PISTON.get()));
                    Entity entity = event.getTarget();
                    if (!(entity instanceof LivingEntity)) break block4;
                    target = (LivingEntity)entity;
                    entity = stack.m_41720_();
                    if (entity instanceof PocketPistonItem && (relic = (PocketPistonItem)entity).canPlayerUseActiveAbility(player, stack, "discarding")) break block5;
                }
                return;
            }
            float modifier = (float)relic.getAbilityValue(stack, "discarding", "interaction");
            relic.spreadExperience((LivingEntity)player, stack, 1);
            if (player.m_20270_((Entity)target) > 3.0f) {
                relic.spreadExperience((LivingEntity)player, stack, 1);
            }
            Vec3 toEntity = target.m_20182_().m_82546_(player.m_20182_()).m_82541_().m_82490_((double)modifier);
            target.m_20334_(toEntity.f_82479_, toEntity.f_82480_ / 2.0, toEntity.f_82481_);
        }
    }
}

