/*
 * Decompiled with CFR 0.152.
 */
package net.yonchi.refm;

import java.nio.file.Path;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.yonchi.refm.api.animation.configs.RapierStaminaConfig;
import net.yonchi.refm.gameasset.RapierAnimations;
import net.yonchi.refm.gameasset.RapierSkills;
import net.yonchi.refm.gameasset.RapierSounds;
import net.yonchi.refm.skill.RapierSkillDataKeys;
import net.yonchi.refm.skill.guard.AmethystCompatSkills;
import net.yonchi.refm.skill.guard.AmethystGuardWoM;
import net.yonchi.refm.skill.guard.RapierCompatSkills;
import net.yonchi.refm.skill.guard.RapierGuardWoM;
import net.yonchi.refm.world.capabilities.item.RapierWeaponCategories;
import net.yonchi.refm.world.item.RapierAddonItems;
import net.yonchi.refm.world.item.RapierTab;
import yesman.epicfight.compat.ICompatModule;
import yesman.epicfight.world.capabilities.item.WeaponCategory;

@Mod(value="refm")
public class RapierForEpicfight {
    public static RapierAnimations.IProxy proxy;
    public static final String MOD_ID = "refm";

    public RapierForEpicfight(FMLJavaModLoadingContext eventBus) {
        IEventBus bus = eventBus.getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        WeaponCategory.ENUM_MANAGER.registerEnumCls(MOD_ID, RapierWeaponCategories.class);
        RapierTab.register(bus);
        RapierAddonItems.ITEMS.register(bus);
        RapierSounds.SOUNDS.register(bus);
        RapierSkillDataKeys.DATA_KEYS.register(bus);
        bus.addListener(RapierAnimations::registerAnimations);
        bus.addListener(RapierSkills::registerRapierSkills);
        bus.addListener(RapierCompatSkills::forceGuard);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> bus.addListener(RapierCompatSkills::onIconCreate));
        bus.addListener(this::addPackFindersEvent);
        bus.addListener(this::addCreative);
        proxy = FMLEnvironment.dist == Dist.CLIENT ? new RapierAnimations.ClientProxy() : new RapierAnimations.ServerProxy();
        if (ModList.get().isLoaded("efstaminainteractions")) {
            ICompatModule.loadCompatModule((FMLJavaModLoadingContext)eventBus, RapierStaminaConfig.class);
            bus.addListener(RapierStaminaConfig::registerStamina);
        }
        if (ModList.get().isLoaded("irons_spellbooks")) {
            ICompatModule.loadCompatModule((FMLJavaModLoadingContext)eventBus, AmethystCompatSkills.class);
            bus.addListener(AmethystCompatSkills::forceGuard);
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> bus.addListener(AmethystCompatSkills::onIconCreate));
        }
        if (ModList.get().isLoaded("wom")) {
            ICompatModule.loadCompatModule((FMLJavaModLoadingContext)eventBus, RapierGuardWoM.class);
        }
        if (ModList.get().isLoaded("wom") && ModList.get().isLoaded("irons_spellbooks")) {
            ICompatModule.loadCompatModule((FMLJavaModLoadingContext)eventBus, AmethystGuardWoM.class);
        }
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    public void addPackFindersEvent(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            Path resourcePath = ModList.get().getModFileById(MOD_ID).getFile().findResource(new String[]{"packs/all_rapiers_3D"});
            PathPackResources pack = new PathPackResources(ModList.get().getModFileById(MOD_ID).getFile().getFileName() + ":" + resourcePath, resourcePath, false);
            Pack.ResourcesSupplier resourcesSupplier = string -> pack;
            Pack.Info info = Pack.m_246334_((String)"all_rapiers_3D", (Pack.ResourcesSupplier)resourcesSupplier);
            if (info != null) {
                event.addRepositorySource(source -> source.accept(Pack.m_245512_((String)"all_rapiers_3D", (Component)Component.m_237115_((String)"pack.all_rapiers_3D.title"), (boolean)false, (Pack.ResourcesSupplier)resourcesSupplier, (Pack.Info)info, (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (boolean)false, (PackSource)PackSource.f_10528_)));
            }
        }
    }
}

