/*
 * Decompiled with CFR 0.152.
 */
package net.yonchi.refm.skill.weaponpassive;

import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class EnderRapierPassive
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("06542d5a-7b38-4db8-9959-fa6a4f6cbbc0");
    private long lastTeleportTime = 0L;
    private static final long COOLDOWN_TIME = 3600L;

    public EnderRapierPassive(SkillBuilder<? extends PassiveSkill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.PROJECTILE_HIT_EVENT, EVENT_UUID, event -> {
            LivingEntity target = (LivingEntity)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
            if (target == null || !target.m_6084_()) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastTeleportTime < 3600L) {
                event.setCanceled(false);
            } else {
                event.setCanceled(true);
                this.teleportToSafeLocation(target);
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        PlayerEventListener listener = container.getExecutor().getEventListener();
        listener.removeListener(PlayerEventListener.EventType.PROJECTILE_HIT_EVENT, EVENT_UUID);
    }

    private void teleportToSafeLocation(LivingEntity entity) {
        this.lastTeleportTime = System.currentTimeMillis();
        Random random = new Random();
        int attempts = 24;
        for (int i = 0; i < attempts; ++i) {
            float yaw = entity.m_6080_();
            float adjustedYaw = yaw + 90.0f;
            if (adjustedYaw > 180.0f) {
                adjustedYaw -= 360.0f;
            }
            if (adjustedYaw < -180.0f) {
                adjustedYaw += 360.0f;
            }
            double distance = 1.5 + random.nextDouble();
            double offsetX = Math.cos(Math.toRadians(adjustedYaw)) * distance;
            double offsetZ = Math.sin(Math.toRadians(adjustedYaw)) * distance;
            double newX = entity.m_20185_() + offsetX;
            double newZ = entity.m_20189_() + offsetZ;
            int newY = (int)Math.floor(entity.m_20186_());
            BlockPos pos = new BlockPos((int)Math.floor(newX), newY, (int)Math.floor(newZ));
            while (pos.m_123342_() > entity.m_9236_().m_141937_() && !entity.m_9236_().m_8055_(pos).m_60795_()) {
                pos = pos.m_7495_();
            }
            BlockPos above = pos.m_7494_();
            if (!entity.m_9236_().m_8055_(pos).m_60795_() || !entity.m_9236_().m_8055_(above).m_60795_()) continue;
            this.spawnPortalParticles((Entity)entity, entity.m_9236_().f_46441_);
            entity.m_6021_(newX, (double)pos.m_123342_(), newZ);
            this.spawnPortalParticles((Entity)entity, entity.m_9236_().f_46441_);
            entity.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_11757_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return;
        }
    }

    private void spawnPortalParticles(Entity entity, RandomSource random) {
        ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
        if (clientLevel != null) {
            double horizontalRadius = 1.2;
            for (int i = 0; i < 69; ++i) {
                double xOffset = (random.m_188500_() - 0.4) * horizontalRadius;
                double yOffset = (random.m_188500_() - random.m_188500_()) * 1.4;
                double zOffset = (random.m_188500_() - 0.4) * horizontalRadius;
                clientLevel.m_7106_((ParticleOptions)ParticleTypes.f_123760_, entity.m_20185_() + xOffset, entity.m_20186_() + yOffset, entity.m_20189_() + zOffset, 0.0, 0.2, 0.0);
            }
        }
    }
}

