/*
 * Decompiled with CFR 0.152.
 */
package net.yonchi.refm.skill.weaponpassive;

import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.yonchi.refm.api.animation.JointTrack;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class OceanRapierPassive
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("09a20178-a51c-4062-80f4-1618e30672fc");

    public OceanRapierPassive(SkillBuilder<? extends PassiveSkill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID, event -> {
            MobEffectInstance effect;
            MobEffectInstance effect2;
            LivingEntity player = (LivingEntity)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal();
            if (player == null) {
                return;
            }
            if (player.m_20069_()) {
                int duration = 5;
                int amplifier1 = 1;
                int amplifier2 = 0;
                MobEffectInstance dolphinEffect = new MobEffectInstance(MobEffects.f_19593_, duration, amplifier1, true, false);
                MobEffectInstance breathingEffect = new MobEffectInstance(MobEffects.f_19592_, duration, amplifier2, true, false);
                player.m_7292_(dolphinEffect);
                player.m_7292_(breathingEffect);
                if (player.m_20142_()) {
                    double speedThreshold;
                    Vec3 velocity = player.m_20184_();
                    double speed = Math.sqrt(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82480_ * velocity.f_82480_ + velocity.f_82481_ * velocity.f_82481_);
                    if (speed > (speedThreshold = 0.286)) {
                        int numParticles = 2;
                        for (int i = 0; i < numParticles; ++i) {
                            Particle particle;
                            float x_L = -0.08f;
                            float x_R = 0.08f;
                            float dynamicY = OceanRapierPassive.getDynamicYRotation(player.m_146909_());
                            float dynamicX = OceanRapierPassive.getDynamicXOffset(player.m_146909_());
                            Vec3 pos_L = JointTrack.getJointWithTranslation(Minecraft.m_91087_().f_91074_, (Entity)player, new Vec3f(x_L, dynamicY, dynamicX), ((HumanoidArmature)Armatures.BIPED.get()).legL);
                            Vec3 pos_R = JointTrack.getJointWithTranslation(Minecraft.m_91087_().f_91074_, (Entity)player, new Vec3f(x_R, dynamicY, dynamicX), ((HumanoidArmature)Armatures.BIPED.get()).legR);
                            if (pos_L != null && (particle = Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ParticleTypes.f_123795_, pos_L.f_82479_, pos_L.f_82480_, pos_L.f_82481_, player.m_20184_().f_82479_, player.m_20184_().f_82480_, player.m_20184_().f_82481_)) != null) {
                                particle.m_6569_(0.92f);
                                particle.m_107257_(12);
                            }
                            if (pos_R == null || (particle = Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ParticleTypes.f_123795_, pos_R.f_82479_, pos_R.f_82480_, pos_R.f_82481_, player.m_20184_().f_82479_, player.m_20184_().f_82480_, player.m_20184_().f_82481_)) == null) continue;
                            particle.m_6569_(0.92f);
                            particle.m_107257_(12);
                        }
                    }
                }
            } else if (player.m_21023_(MobEffects.f_19593_) && (effect2 = player.m_21124_(MobEffects.f_19593_)) != null && effect2.m_19557_() < 10) {
                player.m_21195_(MobEffects.f_19593_);
                player.m_21195_(MobEffects.f_19592_);
            }
            if (!player.m_20069_() && player.m_21023_(MobEffects.f_19593_) && (effect = player.m_21124_(MobEffects.f_19593_)) != null && effect.m_19557_() < 10) {
                player.m_21195_(MobEffects.f_19593_);
                player.m_21195_(MobEffects.f_19592_);
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        MobEffectInstance effect;
        PlayerEventListener listener = container.getExecutor().getEventListener();
        LivingEntity player = (LivingEntity)container.getExecutor().getOriginal();
        if (player != null && player.m_21023_(MobEffects.f_19593_) && (effect = player.m_21124_(MobEffects.f_19593_)) != null && effect.m_19557_() < 10) {
            player.m_21195_(MobEffects.f_19593_);
            player.m_21195_(MobEffects.f_19592_);
        }
        listener.removeListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID);
    }

    public static float getDynamicXOffset(float pitch) {
        float lookingUp = 0.2f;
        float lookingDown = -1.12f;
        float lookingStraight = -0.72f;
        if (pitch <= 0.0f) {
            return lookingUp + (pitch + 90.0f) / 90.0f * -0.92f;
        }
        return lookingStraight + pitch / 90.0f * (lookingDown + 0.72f);
    }

    public static float getDynamicYRotation(float pitch) {
        float lookingUp = 0.1f;
        float lookingDown = -0.52f;
        float lookingStraight = 0.52f;
        if (pitch <= 0.0f) {
            return lookingUp + (pitch + 90.0f) / 90.0f * 0.42f;
        }
        return lookingStraight + pitch / 90.0f * (lookingDown - 0.52f);
    }
}

