/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.silentsdelight.datagen;

import com.google.common.collect.ImmutableMap;
import com.scouter.silentsdelight.SilentsDelight;
import com.scouter.silentsdelight.items.SDItems;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class ItemModelGenerator
extends ItemModelProvider {
    public static BlockFamily family = null;
    static final Map<BlockFamily.Variant, BiConsumer<ItemModelGenerator, Block>> SHAPE_CONSUMERS = ImmutableMap.builder().put((Object)BlockFamily.Variant.BUTTON, ItemModelGenerator::toBlockButton).put((Object)BlockFamily.Variant.DOOR, ItemModelGenerator::singleTexBlockItem).put((Object)BlockFamily.Variant.CHISELED, ItemModelGenerator::toBlock).put((Object)BlockFamily.Variant.CRACKED, ItemModelGenerator::toBlock).put((Object)BlockFamily.Variant.CUSTOM_FENCE, ItemModelGenerator::toBlockFence).put((Object)BlockFamily.Variant.FENCE, ItemModelGenerator::toBlockFence).put((Object)BlockFamily.Variant.CUSTOM_FENCE_GATE, ItemModelGenerator::toBlock).put((Object)BlockFamily.Variant.FENCE_GATE, ItemModelGenerator::toBlock).put((Object)BlockFamily.Variant.SIGN, ItemModelGenerator::toBlock).put((Object)BlockFamily.Variant.SLAB, ItemModelGenerator::toBlock).put((Object)BlockFamily.Variant.STAIRS, ItemModelGenerator::toBlock).put((Object)BlockFamily.Variant.PRESSURE_PLATE, ItemModelGenerator::toBlock).put((Object)BlockFamily.Variant.TRAPDOOR, ItemModelGenerator::toBlockTrapdoor).put((Object)BlockFamily.Variant.WALL, ItemModelGenerator::toBlockWall).build();

    public ItemModelGenerator(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "silentsdelight", existingFileHelper);
    }

    protected void registerModels() {
        this.simpleItem(SDItems.WARDEN_EAR);
        this.simpleItem(SDItems.CUT_WARDEN_EAR);
        this.simpleItem(SDItems.WARDEN_EAR_ON_A_STICK);
        this.simpleItem(SDItems.BAKED_WARDEN_EAR_ON_A_STICK);
        this.simpleItem(SDItems.WARDEN_EAR_FRIED_RICE);
        this.simpleItem(SDItems.SCULK_SENSOR_TENDRIL);
        this.simpleItem(SDItems.SCULK_SENSOR_TENDRIL_ROLL);
        this.simpleItem(SDItems.SCULK_SENSOR_TENDRIL_ROLL_SLICE);
        this.simpleItem(SDItems.SCULK_SENSOR_SPRINKLES);
        this.simpleItem(SDItems.SCULK_BARBECUE_STICK);
        this.simpleItem(SDItems.SCULK_SOUP);
        this.simpleItem(SDItems.SCULK_VEIN_SALAD);
        this.simpleItem(SDItems.SCULK_CATALYST_PIE_CRUST);
        this.simpleItem(SDItems.SCULK_CATALYST_PIE);
        this.simpleItem(SDItems.SCULK_CATALYST_PIE_SLICE);
        this.simpleItem(SDItems.SCULK_SHRIEKER_SHAKE);
        this.simpleItem(SDItems.WARDEN_HEART);
        this.simpleItem(SDItems.MINCED_WARDEN_HEART);
        this.simpleItem(SDItems.WARDEN_HEART_PATTY);
        this.simpleItem(SDItems.HEARTBURGER);
        this.simpleItem(SDItems.PLATED_WARDEN_HEART);
        this.simpleItem(SDItems.PLATE_OF_WARDEN_HEART);
    }

    private ItemModelBuilder simpleItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("silentsdelight", "item/" + item.getId().m_135815_()));
    }

    private void toBlock(RegistryObject<Block> b) {
        this.toBlockModel(b, b.getId().m_135815_());
    }

    private void toBlockWall(Block block) {
        Block block1 = block;
        if (family != null) {
            block1 = family.m_175951_();
        }
        this.wallInventory(BuiltInRegistries.f_256975_.m_7981_((Object)block).toString(), SilentsDelight.prefix("block/" + BuiltInRegistries.f_256975_.m_7981_((Object)block1).m_135815_()));
    }

    private void toBlockTrapdoor(Block b) {
        String s = BuiltInRegistries.f_256975_.m_7981_((Object)b).m_135815_();
        StringBuilder stringBuilder = new StringBuilder(s);
        stringBuilder.append("_bottom");
        this.toBlockModel(b, stringBuilder.toString());
    }

    private void toBlock(Block b) {
        this.toBlockModel(b, BuiltInRegistries.f_256975_.m_7981_((Object)b).m_135815_());
    }

    private void toBlockItem(Block b) {
        this.toBlockModelItem(b, BuiltInRegistries.f_256975_.m_7981_((Object)b).m_135815_());
    }

    private void toBlockFence(Block block) {
        Block block1 = block;
        if (family != null) {
            block1 = family.m_175951_();
        }
        this.fenceInventory(BuiltInRegistries.f_256975_.m_7981_((Object)block).toString(), SilentsDelight.prefix("block/" + BuiltInRegistries.f_256975_.m_7981_((Object)block1).m_135815_()));
    }

    private void toBlockButton(Block block) {
        Block block1 = block;
        if (family != null) {
            block1 = family.m_175951_();
        }
        this.buttonInventory(BuiltInRegistries.f_256975_.m_7981_((Object)block).toString(), SilentsDelight.prefix("block/" + BuiltInRegistries.f_256975_.m_7981_((Object)block1).m_135815_()));
    }

    private void toBlockModel(Block b, String model) {
        this.toBlockModel(b, SilentsDelight.prefix("block/" + model));
    }

    private void toBlockModelItem(Block b, String model) {
        this.toBlockModel(b, SilentsDelight.prefix("item/" + model));
    }

    private void toBlockModel(RegistryObject<Block> b, String model) {
        this.toBlockModel(b, SilentsDelight.prefix("block/" + model));
    }

    private void toBlockModel(RegistryObject<Block> b, ResourceLocation model) {
        this.withExistingParent(b.getId().m_135815_(), model);
    }

    private ItemModelBuilder singleTex(RegistryObject<Item> item) {
        return this.generated(item.getId().m_135815_(), SilentsDelight.prefix("item/" + item.getId().m_135815_()));
    }

    private ItemModelBuilder singleTexBlockItem(Block item) {
        return this.generated(this.key(item).m_135815_(), SilentsDelight.prefix("item/" + this.key(item).m_135815_()));
    }

    private ItemModelBuilder singleTexBlockItem(RegistryObject<Block> item) {
        return this.generated(item.getId().m_135815_(), SilentsDelight.prefix("item/" + item.getId().m_135815_()));
    }

    private ItemModelBuilder singleTexBlock(RegistryObject<Block> item) {
        return this.generated(item.getId().m_135815_(), SilentsDelight.prefix("block/" + item.getId().m_135815_()));
    }

    private ItemModelBuilder generated(String name, ResourceLocation ... layers) {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent(name, "item/generated");
        for (int i = 0; i < layers.length; ++i) {
            builder = (ItemModelBuilder)builder.texture("layer" + i, layers[i]);
        }
        return builder;
    }

    private ItemModelBuilder singleTexHandheld(RegistryObject<Item> item) {
        return this.generatedHandheld(item.getId().m_135815_(), SilentsDelight.prefix("item/" + item.getId().m_135815_()));
    }

    private ItemModelBuilder generatedHandheld(String name, ResourceLocation ... layers) {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent(name, "item/handheld");
        for (int i = 0; i < layers.length; ++i) {
            builder = (ItemModelBuilder)builder.texture("layer" + i, layers[i]);
        }
        return builder;
    }

    private void toBlockModel(Block b, ResourceLocation model) {
        this.withExistingParent(BuiltInRegistries.f_256975_.m_7981_((Object)b).m_135815_(), model);
    }

    private ResourceLocation key(Block block) {
        return BuiltInRegistries.f_256975_.m_7981_((Object)block);
    }
}

