/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.silentsdelight.datagen;

import com.google.common.collect.ImmutableMap;
import com.scouter.silentsdelight.effects.SDEffects;
import com.scouter.silentsdelight.items.SDItems;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.RegistryObject;

public class LanguageGenerator
extends LanguageProvider {
    private final Set<Item> itemSet = new HashSet<Item>();
    static final Map<BlockFamily.Variant, BiConsumer<LanguageGenerator, Block>> SHAPE_CONSUMERS = ImmutableMap.builder().put((Object)BlockFamily.Variant.BUTTON, LanguageGenerator::add).put((Object)BlockFamily.Variant.DOOR, LanguageGenerator::add).put((Object)BlockFamily.Variant.CHISELED, LanguageGenerator::add).put((Object)BlockFamily.Variant.CRACKED, LanguageGenerator::add).put((Object)BlockFamily.Variant.CUSTOM_FENCE, LanguageGenerator::add).put((Object)BlockFamily.Variant.FENCE, LanguageGenerator::add).put((Object)BlockFamily.Variant.CUSTOM_FENCE_GATE, LanguageGenerator::add).put((Object)BlockFamily.Variant.FENCE_GATE, LanguageGenerator::add).put((Object)BlockFamily.Variant.SIGN, LanguageGenerator::add).put((Object)BlockFamily.Variant.SLAB, LanguageGenerator::add).put((Object)BlockFamily.Variant.STAIRS, LanguageGenerator::add).put((Object)BlockFamily.Variant.PRESSURE_PLATE, LanguageGenerator::add).put((Object)BlockFamily.Variant.TRAPDOOR, LanguageGenerator::add).put((Object)BlockFamily.Variant.WALL, LanguageGenerator::add).build();

    public LanguageGenerator(PackOutput output) {
        super(output, "silentsdelight", "en_us");
    }

    protected void addTranslations() {
        this.add("itemGroup.silentsdelight", "Silent's Delight");
        this.add(SDItems.WARDEN_EAR, "Warden Ear");
        this.add(SDItems.CUT_WARDEN_EAR, "Cut Warden Ear");
        this.add(SDItems.WARDEN_EAR_ON_A_STICK, "Warden Ear on a Stick");
        this.add(SDItems.BAKED_WARDEN_EAR_ON_A_STICK, "Baked Warden Ear on a Stick");
        this.add(SDItems.WARDEN_EAR_FRIED_RICE, "Warden Ear Fried Rice");
        this.add(SDItems.SCULK_SENSOR_TENDRIL, "Sculk Sensor Tendril");
        this.add(SDItems.SCULK_SENSOR_TENDRIL_ROLL, "Sculk Sensor Tendril Roll");
        this.add(SDItems.SCULK_SENSOR_TENDRIL_ROLL_SLICE, "Sculk Sensor Tendril Roll Slice");
        this.add(SDItems.SCULK_SENSOR_SPRINKLES, "Sculk Sensor Sprinkles");
        this.add(SDItems.SCULK_BARBECUE_STICK, "Sculk Barbecue Stick");
        this.add(SDItems.SCULK_SOUP, "Sculk Soup");
        this.add(SDItems.SCULK_VEIN_SALAD, "Sculk Vein Salad");
        this.add(SDItems.SCULK_CATALYST_PIE_CRUST, "Sculk Catalyst Pie Crust");
        this.add(SDItems.SCULK_CATALYST_PIE, "Sculk Catalyst Pie");
        this.add(SDItems.SCULK_CATALYST_PIE_SLICE, "Sculk Catalyst Pie Slice");
        this.add(SDItems.SCULK_SHRIEKER_SHAKE, "Sculk Shrieker Shake");
        this.add(SDItems.WARDEN_HEART, "Warden Heart");
        this.add(SDItems.MINCED_WARDEN_HEART, "Minced Warden Heart");
        this.add(SDItems.WARDEN_HEART_PATTY, "Warden Heart Patty");
        this.add(SDItems.HEARTBURGER, "Heartburger");
        this.add(SDItems.PLATED_WARDEN_HEART, "Plated Warden Heart");
        this.add(SDItems.PLATE_OF_WARDEN_HEART, "Plate of Warden Heart");
        this.add((MobEffect)SDEffects.WARDENS_SENSE.get(), "Warden Sense");
        this.add("silentsdelight.advancement.root.desc", "This can be eaten?");
        this.add("silentsdelight.advancement.root", "A feast of the depths!");
        this.add("silentsdelight.advancement.obtain_warden_ear", "It can still hear me!");
        this.add("silentsdelight.advancement.obtain_warden_ear.desc", "Obtain a Warden Ear");
        this.add("silentsdelight.advancement.obtain_warden_ear_fried_rice.desc", "Cook a Warden Ear fried rice!");
        this.add("silentsdelight.advancement.obtain_warden_ear_fried_rice", "A hearty meal");
        this.add("silentsdelight.advancement.obtain_baked_warden_ear", "Be Silent!");
        this.add("silentsdelight.advancement.obtain_baked_warden_ear.desc", "Bake a Warden Ear");
        this.add("silentsdelight.advancement.grow_sculk_catalyst_pie", "It Grows!");
        this.add("silentsdelight.advancement.grow_sculk_catalyst_pie.desc", "Kill next to a Catalyst Pie and... obtain more Pie!");
        this.add("silentsdelight.advancement.get_warden_heartburger", "Silent but deadly");
        this.add("silentsdelight.advancement.get_warden_heartburger.desc", "Make a Heartburger");
        this.add("silentsdelight.advancement.get_warden_heart.desc", "Obtain a Warden Heart");
        this.add("silentsdelight.advancement.get_warden_heart", "A hard fought battle!");
        this.add("silentsdelight.advancement.get_sculk_vein_salad", "It's still moving!");
        this.add("silentsdelight.advancement.get_sculk_vein_salad.desc", "Craft a Sculk Vein Salad");
        this.add("silentsdelight.advancement.get_sculk_soup", "Peer into the depths");
        this.add("silentsdelight.advancement.get_sculk_soup.desc", "Cook Sculk Soup");
        this.add("silentsdelight.advancement.get_sculk_shrieker_shake", "Shh be silent!");
        this.add("silentsdelight.advancement.get_sculk_shrieker_shake.desc", "Craft a Sculk Shrieker Shake");
        this.add("silentsdelight.advancement.get_sculk_sensor_tendril_sprinkles", "Sprinkled Delight");
        this.add("silentsdelight.advancement.get_sculk_sensor_tendril_sprinkles.desc", "Craft Sculk Sensor Tendril Sprinkles");
        this.add("silentsdelight.advancement.get_sculk_sensor_tendril_roll", "Rolled Sensor");
        this.add("silentsdelight.advancement.get_sculk_sensor_tendril_roll.desc", "Craft a Sculk Sensor Tendril Roll");
        this.add("silentsdelight.advancement.get_sculk_sensor_tendril", "A senseful food");
        this.add("silentsdelight.advancement.get_sculk_sensor_tendril.desc", "Obtain Sculk Sensor Tendrils");
        this.add("silentsdelight.advancement.get_sculk_catalyst_pie", "A pie with depth");
        this.add("silentsdelight.advancement.get_sculk_catalyst_pie.desc", "Craft a Sculk Catalyst Pie");
        this.add("silentsdelight.advancement.get_plated_warden_heart", "Does it still beat?");
        this.add("silentsdelight.advancement.get_plated_warden_heart.desc", "Craft a plate of Warden Heart");
    }

    public void add(RegistryObject<Item> block, String name) {
        this.add((Item)block.get(), name);
    }

    public void add(Item key, String name) {
        this.itemSet.add(key);
        this.add(key.m_5524_(), name);
    }

    public void addLeftOver(Item key) {
        String keyDescription = this.name(key);
        String[] parts = keyDescription.replace("item.silentsdelight.", "").split("_");
        StringBuilder modifiedString = new StringBuilder();
        int i = 0;
        for (String part : parts) {
            if (0 == i) {
                modifiedString.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1));
            } else {
                modifiedString.append(" ").append(Character.toUpperCase(part.charAt(0))).append(part.substring(1));
            }
            ++i;
        }
        modifiedString.trimToSize();
        String finalModifiedString = modifiedString.toString();
        this.add(key, finalModifiedString);
    }

    public void add(Block key) {
        this.itemSet.add(key.m_5456_());
        String keyDescription = key.m_7705_();
        String[] parts = keyDescription.replace("block.scalebound.", "").split("_");
        StringBuilder modifiedString = new StringBuilder();
        int i = 0;
        for (String part : parts) {
            if (0 == i) {
                modifiedString.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1));
            } else {
                modifiedString.append(" ").append(Character.toUpperCase(part.charAt(0))).append(part.substring(1));
            }
            ++i;
        }
        modifiedString.trimToSize();
        String finalModifiedString = modifiedString.toString();
        this.add(key.m_7705_(), finalModifiedString);
    }

    private String name(Item block) {
        return this.key(block).m_135815_();
    }

    private ResourceLocation key(Item block) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)block);
    }
}

