/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.effect;

import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.effect.OrbitingEffect;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class MagislamEffect
extends OrbitingEffect {
    public MagislamEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
        this.setParticleType((ParticleOptions)ParticleTypes.f_123809_);
    }

    @Override
    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        if (!livingEntity.m_9236_().m_5776_() && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            int ability_timer = Objects.requireNonNull(player.m_21124_((MobEffect)EffectRegistry.MAGISLAM.get())).m_19557_();
            int radius = (int)Config.getFloat("magislamRadius", "UniqueEffects", ConfigDefaultValues.magislamRadius);
            double leapVelocity = 1.5;
            double height = 0.9;
            double descentVelocity = 1.0;
            double damage_multiplier = Config.getFloat("magislamDamageModifier", "UniqueEffects", ConfigDefaultValues.magislamDamageModifier);
            double damage = HelperMethods.getAttackDamage(livingEntity.m_21205_()) * damage_multiplier;
            if (ability_timer >= 60) {
                player.m_20256_(livingEntity.m_20154_().m_82490_(leapVelocity));
                player.m_20334_(livingEntity.m_20184_().f_82479_, height, livingEntity.m_20184_().f_82481_);
                player.f_19864_ = true;
            } else if (ability_timer <= 50) {
                player.m_20334_(livingEntity.m_20184_().f_82479_, -descentVelocity, livingEntity.m_20184_().f_82481_);
                player.f_19864_ = true;
                if (player.m_20096_()) {
                    AABB box = HelperMethods.createBox((Entity)player, radius);
                    for (Entity entities : livingEntity.m_9236_().m_6249_((Entity)livingEntity, box, EntitySelector.f_20403_)) {
                        LivingEntity le;
                        if (entities == null || !(entities instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, (LivingEntity)player)) continue;
                        le.m_20334_((le.m_20185_() - player.m_20185_()) / 4.0, (le.m_20186_() - player.m_20186_()) / 4.0, (le.m_20189_() - player.m_20189_()) / 4.0);
                        le.m_6469_(player.m_269291_().m_269075_(player), (float)damage);
                    }
                    HelperMethods.spawnOrbitParticles((ServerLevel)player.m_9236_(), player.m_20182_(), (ParticleOptions)ParticleTypes.f_123777_, 2.0, 8);
                    HelperMethods.spawnOrbitParticles((ServerLevel)player.m_9236_(), player.m_20182_(), (ParticleOptions)ParticleTypes.f_123813_, 1.0, 3);
                    player.m_9236_().m_6269_(null, (Entity)player, SoundEvents.f_11913_, SoundSource.PLAYERS, 0.9f, 1.1f);
                    player.m_21195_((MobEffect)EffectRegistry.MAGISLAM.get());
                    player.m_21195_((MobEffect)EffectRegistry.RESILIENCE.get());
                }
            }
        }
        super.m_6742_(livingEntity, amplifier);
    }

    @Override
    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }
}

