/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.effect;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.effect.OrbitingEffect;
import net.sweenus.simplyswords.effect.instance.SimplySwordsStatusEffectInstance;
import net.sweenus.simplyswords.registry.EffectRegistry;

public class VoidAssaultEffect
extends OrbitingEffect {
    public LivingEntity sourceEntity;
    public int additionalData;

    public VoidAssaultEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
        this.setParticleType((ParticleOptions)ParticleTypes.f_123762_);
    }

    public void setSourcePlayer(LivingEntity livingEntity) {
        this.sourceEntity = livingEntity;
    }

    public void setAdditionalData(int data) {
        this.additionalData = data;
    }

    @Override
    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        if (!livingEntity.m_9236_().m_5776_()) {
            int voidcallerStartingTickFrequency = (int)Config.getFloat("voidcallerStartingTickFrequency", "UniqueEffects", ConfigDefaultValues.voidcallerStartingTickFrequency);
            MobEffectInstance mobEffectInstance = livingEntity.m_21124_((MobEffect)EffectRegistry.VOIDASSAULT.get());
            if (mobEffectInstance instanceof SimplySwordsStatusEffectInstance) {
                SimplySwordsStatusEffectInstance statusEffect = (SimplySwordsStatusEffectInstance)mobEffectInstance;
                this.sourceEntity = statusEffect.getSourceEntity();
                this.additionalData = statusEffect.getAdditionalData();
            }
            if (livingEntity.f_19797_ % Math.max(1, voidcallerStartingTickFrequency - amplifier * 2) == 0 && this.additionalData != 0) {
                DamageSource damageSource = livingEntity.m_269291_().m_269425_();
                livingEntity.f_19802_ = 0;
                if (this.sourceEntity != null) {
                    damageSource = livingEntity.m_269291_().m_269104_((Entity)livingEntity, (Entity)this.sourceEntity);
                }
                livingEntity.m_6469_(damageSource, (float)(this.additionalData + amplifier));
            }
        }
        super.m_6742_(livingEntity, amplifier);
    }

    @Override
    public boolean m_6584_(int pDuration, int pAmplifier) {
        return super.m_6584_(pDuration, pAmplifier);
    }
}

