/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class MagispearSwordItem
extends UniqueSwordItem {
    private static int stepMod = 0;

    public MagispearSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            HelperMethods.playHitSounds(attacker, target);
            ServerLevel world = (ServerLevel)attacker.m_9236_();
            float hitChance = Config.getFloat("magislamMagicChance", "UniqueEffects", ConfigDefaultValues.magislamMagicChance);
            int random = new Random().nextInt(100);
            if ((float)random < hitChance) {
                float damage = (float)(HelperMethods.getAttackDamage(stack) * (double)Config.getFloat("magislamMagicModifier", "UniqueEffects", ConfigDefaultValues.magislamMagicModifier));
                target.f_19802_ = 0;
                target.m_6469_(attacker.m_269291_().m_269104_((Entity)attacker, (Entity)attacker), damage);
                target.f_19802_ = 0;
                world.m_5594_(null, attacker.m_20183_(), (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_02.get(), attacker.m_5720_(), 0.2f, 1.1f);
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        int skillCooldown = (int)Config.getFloat("magislamCooldown", "UniqueEffects", ConfigDefaultValues.magislamCooldown);
        world.m_5594_(null, user.m_20183_(), (SoundEvent)SoundRegistry.MAGIC_SHAMANIC_NORDIC_27.get(), user.m_5720_(), 0.2f, 1.1f);
        user.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.MAGISLAM.get(), 62, 1));
        user.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.RESILIENCE.get(), 64, 3));
        user.m_36335_().m_41524_((Item)this, skillCooldown);
        return super.m_7203_(world, user, hand);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        HelperMethods.createFootfalls(entity, stack, world, stepMod, ParticleTypes.f_123809_, ParticleTypes.f_123809_, ParticleTypes.f_123783_, true);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style RIGHTCLICK = HelperMethods.getStyle("rightclick");
        Style ABILITY = HelperMethods.getStyle("ability");
        Style TEXT = HelperMethods.getStyle("text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.magispearsworditem.tooltip1").m_6270_(ABILITY));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.magispearsworditem.tooltip2").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.magispearsworditem.tooltip3").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.magispearsworditem.tooltip4").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(RIGHTCLICK));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.magispearsworditem.tooltip5").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.magispearsworditem.tooltip6").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.magispearsworditem.tooltip7").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.magispearsworditem.tooltip8").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.magispearsworditem.tooltip9").m_6270_(TEXT));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

