/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.controller.ControllerBlockEntityBase;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.util.IDoubleBlock;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.VoxelOutliner;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.ICountDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.IFillLevelDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.ILockable;
import net.p3pp3rf1y.sophisticatedstorage.block.ITierDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.IUpgradeDisplay;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class ControllerBlockEntity
extends ControllerBlockEntityBase
implements ILockable,
ICountDisplay,
ITierDisplay,
IUpgradeDisplay,
IFillLevelDisplay {
    private long lastDepositTime = -100L;
    private List<VoxelOutliner.Edge> cachedStorageEdges = null;
    private List<VoxelOutliner.Edge> cachedLinkedBlockEdges = null;
    private List<VoxelOutliner.Edge> cachedControllerEdges = null;

    public ControllerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlocks.CONTROLLER_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82400_((double)this.getSearchRange());
    }

    public void depositPlayerItems(Player player, InteractionHand hand) {
        if (this.m_58904_() == null) {
            return;
        }
        long gameTime = this.m_58904_().m_46467_();
        boolean doubleClick = gameTime - this.lastDepositTime < 10L;
        this.lastDepositTime = gameTime;
        if (doubleClick) {
            player.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).ifPresent(playerInventory -> InventoryHelper.iterate((IItemHandler)playerInventory, (slot, stack) -> {
                if (this.canDepositStack((ItemStack)stack)) {
                    ItemStack resultStack = this.insertItem((ItemStack)stack, true, false);
                    int countToExtract = stack.m_41613_() - resultStack.m_41613_();
                    if (countToExtract > 0 && playerInventory.extractItem(slot.intValue(), countToExtract, true).m_41613_() == countToExtract) {
                        this.insertItem(playerInventory.extractItem(slot.intValue(), countToExtract, false), false, false);
                    }
                }
            }));
            return;
        }
        ItemStack itemInHand = player.m_21120_(hand);
        if (!itemInHand.m_41619_() && this.canDepositStack(itemInHand)) {
            player.m_21008_(hand, this.insertItem(itemInHand, false, false));
        }
    }

    private boolean canDepositStack(ItemStack stack) {
        return this.hasItem(stack.m_41720_()) || this.isMemorizedItem(stack) || this.isFilterItem(stack.m_41720_());
    }

    @Override
    public void toggleLock() {
        HashSet unlockedStorages = new HashSet();
        HashSet lockedStorages = new HashSet();
        this.getStoragePositions().forEach(storagePosition -> WorldHelper.getLoadedBlockEntity((Level)this.f_58857_, (BlockPos)storagePosition, ILockable.class).ifPresent(lockable -> {
            if (lockable.isLocked()) {
                lockedStorages.add(lockable);
            } else {
                unlockedStorages.add(lockable);
            }
        }));
        if (unlockedStorages.isEmpty()) {
            lockedStorages.forEach(ILockable::toggleLock);
        } else {
            unlockedStorages.forEach(ILockable::toggleLock);
        }
    }

    @Override
    public boolean isLocked() {
        return false;
    }

    @Override
    public boolean shouldShowLock() {
        return false;
    }

    @Override
    public void toggleLockVisibility() {
        HashSet invisibleLockStorages = new HashSet();
        HashSet visibleLockStorages = new HashSet();
        this.getStoragePositions().forEach(storagePosition -> WorldHelper.getLoadedBlockEntity((Level)this.f_58857_, (BlockPos)storagePosition, ILockable.class).ifPresent(lockable -> {
            if (lockable.isLocked()) {
                if (lockable.shouldShowLock()) {
                    visibleLockStorages.add(lockable);
                } else {
                    invisibleLockStorages.add(lockable);
                }
            }
        }));
        if (invisibleLockStorages.isEmpty()) {
            visibleLockStorages.forEach(ILockable::toggleLockVisibility);
        } else {
            invisibleLockStorages.forEach(ILockable::toggleLockVisibility);
        }
    }

    @Override
    public boolean shouldShowCounts() {
        return false;
    }

    @Override
    public void toggleCountVisibility() {
        HashSet invisibleCountStorages = new HashSet();
        HashSet visibleCountStorages = new HashSet();
        this.getStoragePositions().forEach(storagePosition -> WorldHelper.getLoadedBlockEntity((Level)this.f_58857_, (BlockPos)storagePosition, ICountDisplay.class).ifPresent(countDisplay -> {
            if (countDisplay.shouldShowCounts()) {
                visibleCountStorages.add(countDisplay);
            } else {
                invisibleCountStorages.add(countDisplay);
            }
        }));
        if (invisibleCountStorages.isEmpty()) {
            visibleCountStorages.forEach(ICountDisplay::toggleCountVisibility);
        } else {
            invisibleCountStorages.forEach(ICountDisplay::toggleCountVisibility);
        }
    }

    @Override
    public List<Integer> getSlotCounts() {
        return List.of();
    }

    @Override
    public boolean shouldShowTier() {
        return false;
    }

    @Override
    public void toggleTierVisiblity() {
        HashSet invisibleTierStorages = new HashSet();
        HashSet visibleTierStorages = new HashSet();
        this.getStoragePositions().forEach(storagePosition -> WorldHelper.getLoadedBlockEntity((Level)this.f_58857_, (BlockPos)storagePosition, ITierDisplay.class).ifPresent(tierDisplay -> {
            if (tierDisplay.shouldShowTier()) {
                visibleTierStorages.add(tierDisplay);
            } else {
                invisibleTierStorages.add(tierDisplay);
            }
        }));
        if (invisibleTierStorages.isEmpty()) {
            visibleTierStorages.forEach(ITierDisplay::toggleTierVisiblity);
        } else {
            invisibleTierStorages.forEach(ITierDisplay::toggleTierVisiblity);
        }
    }

    @Override
    public boolean shouldShowUpgrades() {
        return false;
    }

    @Override
    public void toggleUpgradesVisiblity() {
        HashSet invisibleUpgradeStorages = new HashSet();
        HashSet visibleUpgradeStorages = new HashSet();
        this.getStoragePositions().forEach(storagePosition -> WorldHelper.getLoadedBlockEntity((Level)this.f_58857_, (BlockPos)storagePosition, IUpgradeDisplay.class).ifPresent(upgradeDisplay -> {
            if (upgradeDisplay.shouldShowUpgrades()) {
                visibleUpgradeStorages.add(upgradeDisplay);
            } else {
                invisibleUpgradeStorages.add(upgradeDisplay);
            }
        }));
        if (invisibleUpgradeStorages.isEmpty()) {
            visibleUpgradeStorages.forEach(IUpgradeDisplay::toggleUpgradesVisiblity);
        } else {
            invisibleUpgradeStorages.forEach(IUpgradeDisplay::toggleUpgradesVisiblity);
        }
    }

    @Override
    public boolean shouldShowFillLevels() {
        return false;
    }

    @Override
    public void toggleFillLevelVisibility() {
        HashSet invisibleFillLevelStorages = new HashSet();
        HashSet visibleFillLevelStorages = new HashSet();
        this.getStoragePositions().forEach(storagePosition -> WorldHelper.getLoadedBlockEntity((Level)this.f_58857_, (BlockPos)storagePosition, IFillLevelDisplay.class).ifPresent(fillLevelDisplay -> {
            if (fillLevelDisplay.shouldShowFillLevels()) {
                visibleFillLevelStorages.add(fillLevelDisplay);
            } else {
                invisibleFillLevelStorages.add(fillLevelDisplay);
            }
        }));
        if (invisibleFillLevelStorages.isEmpty()) {
            visibleFillLevelStorages.forEach(IFillLevelDisplay::toggleFillLevelVisibility);
        } else {
            invisibleFillLevelStorages.forEach(IFillLevelDisplay::toggleFillLevelVisibility);
        }
    }

    @Override
    public List<Float> getSlotFillLevels() {
        return List.of();
    }

    protected int getSearchRange() {
        return (Integer)Config.SERVER.controllerRange.get();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.cachedStorageEdges = null;
        this.cachedLinkedBlockEdges = null;
    }

    public List<VoxelOutliner.Edge> getStorageBlockEdges() {
        if (this.cachedStorageEdges == null) {
            HashSet<Object> positions = new HashSet<Object>(this.getStoragePositions());
            positions.removeIf(this.getLinkedBlocks()::contains);
            ArrayList extraPositions = new ArrayList();
            positions.forEach(pos -> {
                BlockState state = this.f_58857_.m_8055_(pos);
                Block patt8119$temp = state.m_60734_();
                if (patt8119$temp instanceof IDoubleBlock) {
                    IDoubleBlock doubleBlock = (IDoubleBlock)patt8119$temp;
                    doubleBlock.getOtherPosition(state, pos).ifPresent(extraPositions::add);
                }
            });
            positions.addAll(extraPositions);
            this.cachedStorageEdges = VoxelOutliner.computeRenderableEdges(positions);
        }
        return this.cachedStorageEdges;
    }

    public List<VoxelOutliner.Edge> getLinkedBlockEdges() {
        if (this.cachedLinkedBlockEdges == null) {
            this.cachedLinkedBlockEdges = new ArrayList<VoxelOutliner.Edge>();
            this.getLinkedBlocks().forEach(linkedPos -> this.cachedLinkedBlockEdges.addAll(VoxelOutliner.computeShapeRenderableEdges((Level)this.f_58857_, List.of(linkedPos))));
        }
        return this.cachedLinkedBlockEdges;
    }

    public List<VoxelOutliner.Edge> getControllerEdges() {
        if (this.cachedControllerEdges == null) {
            this.cachedControllerEdges = VoxelOutliner.computeRenderableEdges(List.of(this.f_58858_));
        }
        return this.cachedControllerEdges;
    }

    public List<BlockPos> getStackStorages(ItemStackKey stackKey) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        result.addAll(this.stackStorages.getOrDefault(stackKey, Collections.emptySet()));
        result.addAll(this.memorizedStackStorages.getOrDefault(stackKey.hashCode(), Collections.emptySet()));
        return result;
    }

    public List<BlockPos> getItemStorages(ItemStackKey stackKey) {
        HashSet positions = new HashSet();
        Item item = stackKey.getStack().m_41720_();
        if (this.itemStackKeys.containsKey(item)) {
            ((Set)this.itemStackKeys.get(item)).forEach(sk -> {
                if (sk.equals((Object)stackKey)) {
                    return;
                }
                if (this.stackStorages.containsKey(sk)) {
                    positions.addAll((Collection)this.stackStorages.get(sk));
                }
            });
        }
        positions.addAll(this.memorizedItemStorages.getOrDefault(item, Collections.emptySet()));
        positions.addAll(this.filterItemStorages.getOrDefault(item, Collections.emptySet()));
        this.getStackStorages(stackKey).forEach(positions::remove);
        return new ArrayList<BlockPos>(positions);
    }

    public List<BlockPos> getEmptyTargetSlotStorages(ItemStackKey stackKey) {
        HashSet<BlockPos> positions = new HashSet<BlockPos>(this.emptySlotsStorages);
        this.getStackStorages(stackKey).forEach(positions::remove);
        this.getItemStorages(stackKey).forEach(positions::remove);
        ItemStack copy = stackKey.getStack().m_255036_(1);
        positions.removeIf(p -> !this.insertIntoStorage((BlockPos)p, copy, true).m_41619_());
        return new ArrayList<BlockPos>(positions);
    }
}

