/*
 * Decompiled with CFR 0.152.
 */
package krelox.spartanaether;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.item.EquipmentUtil;
import com.aetherteam.aether.item.combat.AetherItemTiers;
import com.aetherteam.aether.item.combat.abilities.weapon.ZaniteWeapon;
import com.aetherteam.aether.recipe.AetherRecipeSerializers;
import com.aetherteam.aether.recipe.builder.AltarRepairBuilder;
import com.google.common.collect.ImmutableMultimap;
import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.api.data.model.ModelGenerator;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import com.oblivioussp.spartanweaponry.util.WeaponType;
import com.rolfmao.aethergearexpansion.handlers.AetheriteHandler;
import com.rolfmao.aethergearexpansion.items.AGEItems;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import krelox.spartanaether.AetherGearExpModule;
import krelox.spartanaether.DeepAetherModule;
import krelox.spartantoolkit.BetterWeaponTrait;
import krelox.spartantoolkit.IBetterWeaponTrait;
import krelox.spartantoolkit.SpartanAddon;
import krelox.spartantoolkit.SpartanMaterial;
import krelox.spartantoolkit.WeaponItem;
import krelox.spartantoolkit.WeaponMap;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.util.TriConsumer;
import teamrazor.deepaether.init.DAItems;

@Mod(value="spartanaether")
@Mod.EventBusSubscriber(modid="spartanaether")
public class SpartanAether
extends SpartanAddon {
    public static final String MODID = "spartanaether";
    public static final WeaponMap WEAPONS = new WeaponMap();
    public static final DeferredRegister<Item> ITEMS = SpartanAether.itemRegister((String)"spartanaether");
    public static final DeferredRegister<WeaponTrait> TRAITS = SpartanAether.traitRegister((String)"spartanaether");
    public static final DeferredRegister<CreativeModeTab> TABS = SpartanAether.tabRegister((String)"spartanaether");
    public static final RegistryObject<Item> SKYROOT_HANDLE = ITEMS.register("skyroot_handle", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> SKYROOT_POLE = ITEMS.register("skyroot_pole", () -> new Item(new Item.Properties()));
    public static final RegistryObject<WeaponTrait> DOUBLE_DROPS = SpartanAether.registerTrait(TRAITS, (WeaponTrait)new BetterWeaponTrait("double_drops", "spartanaether", WeaponTrait.TraitQuality.POSITIVE).setUniversal());
    public static final RegistryObject<WeaponTrait> PROSPECT = SpartanAether.registerTrait(TRAITS, (WeaponTrait)new BetterWeaponTrait("prospect", "spartanaether", WeaponTrait.TraitQuality.POSITIVE){

        public float modifyDamageDealt(WeaponMaterial material, float baseDamage, DamageSource source, LivingEntity attacker, LivingEntity victim) {
            if (EquipmentUtil.isFullStrength((LivingEntity)attacker) && !victim.m_6095_().m_204039_(AetherTags.Entities.NO_AMBROSIUM_DROPS) && victim.m_9236_().m_213780_().m_188503_(25) == 0) {
                victim.m_19998_((ItemLike)AetherItems.AMBROSIUM_SHARD.get());
            }
            return super.modifyDamageDealt(material, baseDamage, source, attacker, victim);
        }
    }.setUniversal());
    public static final RegistryObject<WeaponTrait> ADAPTIVE = SpartanAether.registerTrait(TRAITS, (WeaponTrait)new BetterWeaponTrait("adaptive", "spartanaether", WeaponTrait.TraitQuality.POSITIVE){
        ItemStack stack = ItemStack.f_41583_;

        public void onModifyAttributesMelee(ImmutableMultimap.Builder<Attribute, AttributeModifier> builder) {
            ImmutableMultimap map = builder.build();
            double baseDamage = 0.0;
            Iterator it = map.get((Object)Attributes.f_22281_).stream().iterator();
            while (it.hasNext()) {
                AttributeModifier modifier = (AttributeModifier)it.next();
                baseDamage += modifier.m_22218_();
            }
            double boostedDamage = Math.max(EquipmentUtil.calculateZaniteBuff((ItemStack)this.stack, (double)baseDamage) - baseDamage, 0.0);
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(ZaniteWeapon.DAMAGE_MODIFIER_UUID, "Damage modifier", (double)Math.round(boostedDamage), AttributeModifier.Operation.ADDITION));
        }

        public boolean isEnabled(WeaponMaterial material, ItemStack stack) {
            this.stack = stack;
            return super.isEnabled(material, stack);
        }
    }.setMelee().setThrowing());
    public static final RegistryObject<WeaponTrait> ETHEREAL = SpartanAether.registerTrait(TRAITS, (WeaponTrait)new BetterWeaponTrait("ethereal", "spartanaether", WeaponTrait.TraitQuality.NEUTRAL){
        ItemStack stack = ItemStack.f_41583_;

        public void onModifyAttributesMelee(ImmutableMultimap.Builder<Attribute, AttributeModifier> builder) {
            ImmutableMultimap map = builder.build();
            double baseDamage = 0.0;
            Iterator it = map.get((Object)Attributes.f_22281_).stream().iterator();
            while (it.hasNext()) {
                AttributeModifier modifier = (AttributeModifier)it.next();
                baseDamage += modifier.m_22218_();
            }
            double boostedDamage = baseDamage * ((double)this.stack.m_41773_() / (double)this.stack.m_41776_() + 0.5);
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(ZaniteWeapon.DAMAGE_MODIFIER_UUID, "Damage modifier", (double)Math.round(-(boostedDamage -= baseDamage)), AttributeModifier.Operation.ADDITION));
        }

        public boolean isEnabled(WeaponMaterial material, ItemStack stack) {
            this.stack = stack;
            return super.isEnabled(material, stack);
        }
    }.setMelee().setThrowing());
    public static final RegistryObject<WeaponTrait> UPDRAFT = SpartanAether.registerTrait(TRAITS, (WeaponTrait)new BetterWeaponTrait("updraft", "spartanaether", WeaponTrait.TraitQuality.POSITIVE){

        public void onHitEntity(WeaponMaterial material, ItemStack stack, LivingEntity target, LivingEntity attacker, Entity projectile) {
            if (EquipmentUtil.isFullStrength((LivingEntity)attacker) && !target.m_6095_().m_204039_(AetherTags.Entities.UNLAUNCHABLE) && (target.m_20096_() || target.isInFluidType())) {
                target.m_5997_(0.0, 1.0, 0.0);
                if (target instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)target;
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)serverPlayer));
                }
            }
        }
    }.setMelee());
    public static final RegistryObject<WeaponTrait> REACTIVE = SpartanAether.registerTrait(TRAITS, (WeaponTrait)new BetterWeaponTrait("reactive", "spartanaether", WeaponTrait.TraitQuality.POSITIVE){

        public float modifyDamageDealt(WeaponMaterial material, float baseDamage, DamageSource source, LivingEntity attacker, LivingEntity victim) {
            if (!EquipmentUtil.isFullStrength((LivingEntity)attacker)) {
                return baseDamage;
            }
            return baseDamage + AetheriteHandler.getLastDamageDone((LivingEntity)attacker).floatValue() / 10.0f;
        }
    }.setUniversal());
    public static final RegistryObject<WeaponTrait> FLOATING = SpartanAether.registerTrait(TRAITS, (WeaponTrait)new WeaponTrait("floating", "spartanaether", WeaponTrait.TraitQuality.POSITIVE).setUniversal());
    public static final ArrayList<SpartanMaterial> MATERIALS = new ArrayList();
    public static final SpartanMaterial SKYROOT = SpartanAether.material(AetherItemTiers.SKYROOT, (TagKey<Item>)AetherTags.Items.SKYROOT_REPAIRING, new RegistryObject[]{DOUBLE_DROPS});
    public static final SpartanMaterial HOLYSTONE = SpartanAether.material(AetherItemTiers.HOLYSTONE, (TagKey<Item>)AetherTags.Items.HOLYSTONE_REPAIRING, new RegistryObject[]{PROSPECT});
    public static final SpartanMaterial ZANITE = SpartanAether.material(AetherItemTiers.ZANITE, (TagKey<Item>)AetherTags.Items.ZANITE_REPAIRING, new RegistryObject[]{ADAPTIVE});
    public static final SpartanMaterial SKYJADE = ModList.get().isLoaded("deep_aether") ? DeepAetherModule.skyjade() : null;
    public static final SpartanMaterial GRAVITITE = SpartanAether.material(AetherItemTiers.GRAVITITE, (TagKey<Item>)AetherTags.Items.GRAVITITE_REPAIRING, new RegistryObject[]{UPDRAFT});
    public static final SpartanMaterial STRATUS = ModList.get().isLoaded("deep_aether") ? DeepAetherModule.stratus() : null;
    public static final SpartanMaterial AETHERITE = ModList.get().isLoaded("aethergearexpansion") ? AetherGearExpModule.aetherite() : null;
    public static final RegistryObject<CreativeModeTab> SPARTAN_AETHER_TAB = SpartanAether.registerTab(TABS, (String)"spartanaether", () -> (Item)WEAPONS.get(GRAVITITE, krelox.spartantoolkit.WeaponType.BATTLE_HAMMER).get(), (parameters, output) -> ITEMS.getEntries().forEach(item -> output.m_246326_((ItemLike)item.get())));

    public SpartanAether() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        this.registerSpartanWeapons(ITEMS);
        ITEMS.register(bus);
        TRAITS.register(bus);
        TABS.register(bus);
    }

    @SafeVarargs
    static SpartanMaterial material(Enum<?> tier, TagKey<Item> repairTag, RegistryObject<WeaponTrait> ... traits) {
        SpartanMaterial material = new SpartanMaterial(tier.name().toLowerCase(), MODID, (Tier)tier, repairTag, traits).setPlanks(AetherTags.Items.SKYROOT_STICK_CRAFTING).setStick(AetherTags.Items.SKYROOT_STICKS).setHandle(SKYROOT_HANDLE).setPole(SKYROOT_POLE);
        MATERIALS.add(material);
        return material;
    }

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.LOWEST)
    public static void onLivingDamage(LivingDamageEvent event) {
        Item item;
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        ItemStack stack = attacker.m_21205_();
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof WeaponItem) {
            WeaponItem weapon = (WeaponItem)item;
            WeaponMaterial material = weapon.getMaterial();
            List traits = material.getBonusTraits(WeaponType.MELEE);
            if (traits == null) {
                return;
            }
            if (traits.contains(REACTIVE.get()) && ((IBetterWeaponTrait)REACTIVE.get()).isEnabled(material, stack) && EquipmentUtil.isFullStrength((LivingEntity)attacker)) {
                AetheriteHandler.addDamageDoneToList((LivingEntity)attacker, (Integer)attacker.f_19797_, (Float)Float.valueOf(Math.min(event.getAmount(), event.getEntity().m_21223_())));
            }
        }
    }

    protected void addTranslations(LanguageProvider provider, Function<RegistryObject<?>, String> formatName) {
        super.addTranslations(provider, formatName);
        provider.add((Item)SKYROOT_HANDLE.get(), "Skyroot Handle");
        provider.add((Item)SKYROOT_POLE.get(), "Skyroot Pole");
    }

    protected void registerModels(ItemModelProvider provider, ModelGenerator generator) {
        super.registerModels(provider, generator);
        provider.basicItem((Item)SKYROOT_HANDLE.get());
        provider.basicItem((Item)SKYROOT_POLE.get());
    }

    protected void addItemTags(ItemTagsProvider provider, Function<TagKey<Item>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>> tag) {
        super.addItemTags(provider, tag);
        tag.apply(AetherGearExpModule.INGOTS_AETHERITE).m_255245_((Object)((Item)AGEItems.AETHERITE_INGOT.get()));
    }

    protected void buildCraftingRecipes(Consumer<FinishedRecipe> consumer) {
        TriConsumer skyrootStickRecipe = (builder, skyrootStickCount, ingredient) -> builder.m_126186_(Ingredient.m_204132_((TagKey)AetherTags.Items.SKYROOT_STICKS), skyrootStickCount.intValue()).m_206419_(ingredient).m_126145_(ForgeRegistries.ITEMS.getKey((Object)builder.m_142372_()).toString()).m_126132_("has_skyroot_sticks", (CriterionTriggerInstance)SpartanAether.has((TagKey)AetherTags.Items.SKYROOT_STICKS)).m_126140_(consumer, ForgeRegistries.ITEMS.getKey((Object)builder.m_142372_()).m_266382_("_from_" + ingredient.f_203868_().m_135815_()));
        skyrootStickRecipe.accept((Object)ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)SKYROOT_HANDLE.get())), (Object)1, (Object)Tags.Items.STRING);
        skyrootStickRecipe.accept((Object)ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)SKYROOT_HANDLE.get()), (int)4), (Object)4, (Object)ItemTags.f_13167_);
        skyrootStickRecipe.accept((Object)ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)SKYROOT_HANDLE.get()), (int)4), (Object)4, (Object)Tags.Items.LEATHER);
        skyrootStickRecipe.accept((Object)ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)SKYROOT_POLE.get()), (int)4), (Object)8, (Object)ItemTags.f_13167_);
        skyrootStickRecipe.accept((Object)ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)SKYROOT_POLE.get()), (int)4), (Object)8, (Object)Tags.Items.LEATHER);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)SKYROOT_POLE.get())).m_206416_(Character.valueOf('|'), AetherTags.Items.SKYROOT_STICKS).m_206416_(Character.valueOf('#'), Tags.Items.STRING).m_126130_("| ").m_126130_("|#").m_126130_("| ").m_126145_(SKYROOT_POLE.getId().toString()).m_126132_("has_skyroot_sticks", (CriterionTriggerInstance)SpartanAether.has((TagKey)AetherTags.Items.SKYROOT_STICKS)).m_176500_(consumer, SKYROOT_POLE.getId() + "_from_string");
        Map<SpartanMaterial, Integer> repairTimes = Map.of(SKYROOT, 250, HOLYSTONE, 500, ZANITE, 750, SKYJADE, 750, GRAVITITE, 1500, STRATUS, 1500, AETHERITE, 1500);
        WEAPONS.forEach((key, item) -> {
            SpartanMaterial material = (SpartanMaterial)key.first();
            krelox.spartantoolkit.WeaponType type = (krelox.spartantoolkit.WeaponType)key.second();
            Item weapon = (Item)item.get();
            if (material.equals(STRATUS)) {
                SmithingTransformRecipeBuilder.m_266555_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DAItems.STRATUS_SMITHING_TEMPLATE.get()}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)WEAPONS.get(GRAVITITE, type).get()}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DAItems.STRATUS_INGOT.get()}), (RecipeCategory)RecipeCategory.COMBAT, (Item)weapon).m_266439_("has_stratus_ingot", (CriterionTriggerInstance)SpartanAether.has((ItemLike)((ItemLike)DAItems.STRATUS_INGOT.get()))).m_266260_(consumer, item.getId() + "_smithing");
            } else if (material.equals(AETHERITE)) {
                SmithingTransformRecipeBuilder.m_266555_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)AGEItems.AETHERITE_UPGRADE_SMITHING_TEMPLATE.get()}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)WEAPONS.get(GRAVITITE, type).get()}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)AGEItems.AETHERITE_INGOT.get()}), (RecipeCategory)RecipeCategory.COMBAT, (Item)weapon).m_266439_("has_aetherite_ingot", (CriterionTriggerInstance)SpartanAether.has((ItemLike)((ItemLike)AGEItems.AETHERITE_INGOT.get()))).m_266260_(consumer, item.getId() + "_smithing");
            } else {
                type.recipe.accept((Object)WEAPONS, (Object)consumer, (Object)material);
            }
            AltarRepairBuilder.repair((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)weapon, 1)}), (RecipeCategory)RecipeCategory.COMBAT, (int)((Integer)repairTimes.get(material)), (RecipeSerializer)((RecipeSerializer)AetherRecipeSerializers.REPAIRING.get())).unlockedBy("has_" + item.getId().m_135815_(), (CriterionTriggerInstance)SpartanAether.has((ItemLike)weapon)).m_176500_(consumer, item.getId() + "_repairing");
        });
    }

    protected Map<RegistryObject<WeaponTrait>, String> getTraitDescriptions() {
        return Map.of(DOUBLE_DROPS, "Mobs drop 2x as many items", PROSPECT, "4% chance of dropping an Ambrosium Shard while attacking", ADAPTIVE, "Gains strength the more it is used", ETHEREAL, "Starts very powerful. Wears down with use", UPDRAFT, "Flings foes into the air", REACTIVE, "Increased strength based on recently dealt damage", FLOATING, "Will float when dropped in the Aether");
    }

    public String modid() {
        return MODID;
    }

    public List<SpartanMaterial> getMaterials() {
        return MATERIALS;
    }

    public WeaponMap getWeaponMap() {
        return WEAPONS;
    }
}

