/*
 * Decompiled with CFR 0.152.
 */
package dev.cephelo.spartancataclysm;

import dev.cephelo.spartancataclysm.SpartanCataclysm;
import krelox.spartantoolkit.SpartanMaterial;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="spartancataclysm", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.BooleanValue MECHA_SMITE_REGEN_THRESHOLD_TYPE;
    private static final ForgeConfigSpec.BooleanValue CUSTOM_SOUNDS;
    private static final ForgeConfigSpec.DoubleValue ANCIENT_METAL_DAMAGE;
    private static final ForgeConfigSpec.DoubleValue BLACK_STEEL_DAMAGE;
    private static final ForgeConfigSpec.DoubleValue CURSIUM_DAMAGE;
    private static final ForgeConfigSpec.DoubleValue IGNITIUM_DAMAGE;
    private static final ForgeConfigSpec.DoubleValue WITHERITE_DAMAGE;
    private static final ForgeConfigSpec.DoubleValue ANCIENT_METAL_SPEED;
    private static final ForgeConfigSpec.DoubleValue BLACK_STEEL_SPEED;
    private static final ForgeConfigSpec.DoubleValue CURSIUM_SPEED;
    private static final ForgeConfigSpec.DoubleValue IGNITIUM_SPEED;
    private static final ForgeConfigSpec.DoubleValue WITHERITE_SPEED;
    private static final ForgeConfigSpec.DoubleValue ACCURSED_RAGE_CHANCE;
    private static final ForgeConfigSpec.DoubleValue ACCURSED_RAGE_EXTRA_DAMAGE;
    private static final ForgeConfigSpec.DoubleValue BLAZING_BRAND_CHANCE;
    private static final ForgeConfigSpec.DoubleValue BLAZING_BRAND_LIFESTEAL_CHANCE;
    private static final ForgeConfigSpec.DoubleValue BLAZING_BRAND_ARMOR_REDUCTION;
    private static final ForgeConfigSpec.DoubleValue BLAZING_BRAND_ARMOR_TOUGHNESS_REDUCTION;
    private static final ForgeConfigSpec.DoubleValue MECHA_SMITE_CHANCE;
    private static final ForgeConfigSpec.DoubleValue MECHA_SMITE_REGEN_CHANCE;
    private static final ForgeConfigSpec.DoubleValue LIFESTEAL_MULTIPLIER;
    private static final ForgeConfigSpec.DoubleValue MECHA_PULSE_CHARGE_CHANCE;
    private static final ForgeConfigSpec.DoubleValue MECHA_PULSE_EXTRA_DAMAGE;
    private static final ForgeConfigSpec.DoubleValue MECHA_SMITE_REGEN_THRESHOLD_PERCENT;
    private static final ForgeConfigSpec.DoubleValue PITCH_VARIATION;
    private static final ForgeConfigSpec.IntValue ACCURSED_RAGE_DURATION;
    private static final ForgeConfigSpec.IntValue ACCURSED_RAGE_MAXIMUM;
    private static final ForgeConfigSpec.IntValue BLAZING_BRAND_DURATION;
    private static final ForgeConfigSpec.IntValue BLAZING_BRAND_MAXIMUM;
    private static final ForgeConfigSpec.IntValue MECHA_PULSE_EFFECT_DURATION;
    private static final ForgeConfigSpec.IntValue MECHA_PULSE_STUN_THRESHOLD;
    private static final ForgeConfigSpec.IntValue MECHA_PULSE_COOLDOWN;
    private static final ForgeConfigSpec.IntValue MECHA_PULSE_STUN_DURATION;
    private static final ForgeConfigSpec.IntValue MECHA_SMITE_FIRE_DURATION;
    private static final ForgeConfigSpec.IntValue MECHA_SMITE_WITHER_DURATION;
    private static final ForgeConfigSpec.IntValue MECHA_SMITE_WITHER_AMP;
    private static final ForgeConfigSpec.IntValue MECHA_SMITE_REGEN_THRESHOLD;
    private static final ForgeConfigSpec.IntValue MECHA_SMITE_REGEN_DURATION;
    private static final ForgeConfigSpec.IntValue MECHA_SMITE_REGEN_AMP;
    static final ForgeConfigSpec SPEC;
    public static double accursedRageChance;
    public static double blazingBrandChance;
    public static double blazingBrandLifestealChance;
    public static double accursedRageExtraDamage;
    public static int accursedRageDuration;
    public static int accursedRageMaximum;
    public static double lifestealMultiplier;
    public static int blazingBrandDuration;
    public static int blazingBrandMaximum;
    public static double blazingBrandArmorReduction;
    public static double blazingBrandArmorToughnessReduction;
    public static double mechaPulseChargeChance;
    public static int mechaPulseStunThreshold;
    public static int mechaPulseCooldown;
    public static int mechaPulseStunDuration;
    public static int mechaPulseEffectDuration;
    public static double mechaPulseExtraDamage;
    public static double mechaSmiteChance;
    public static double mechaSmiteRegenChance;
    public static int mechaSmiteFireDuration;
    public static int mechaSmiteWitherDuration;
    public static int mechaSmiteWitherAmplifier;
    public static boolean mechaSmiteRegenThresholdType;
    public static double mechaSmiteRegenThresholdPercent;
    public static int mechaSmiteRegenThreshold;
    public static int mechaSmiteRegenDuration;
    public static int mechaSmiteRegenAmplifier;
    public static boolean customSounds;
    public static double pitchVariation;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        Config.updateMaterialValues(SpartanCataclysm.ANCIENT_METAL, ANCIENT_METAL_DAMAGE, ANCIENT_METAL_SPEED);
        Config.updateMaterialValues(SpartanCataclysm.BLACK_STEEL, BLACK_STEEL_DAMAGE, BLACK_STEEL_SPEED);
        Config.updateMaterialValues(SpartanCataclysm.CURSIUM, CURSIUM_DAMAGE, CURSIUM_SPEED);
        Config.updateMaterialValues(SpartanCataclysm.IGNITIUM, IGNITIUM_DAMAGE, IGNITIUM_SPEED);
        Config.updateMaterialValues(SpartanCataclysm.WITHERITE, WITHERITE_DAMAGE, WITHERITE_SPEED);
        accursedRageChance = (Double)ACCURSED_RAGE_CHANCE.get();
        blazingBrandChance = (Double)BLAZING_BRAND_CHANCE.get();
        blazingBrandLifestealChance = (Double)BLAZING_BRAND_LIFESTEAL_CHANCE.get();
        accursedRageExtraDamage = (Double)ACCURSED_RAGE_EXTRA_DAMAGE.get();
        accursedRageDuration = (Integer)ACCURSED_RAGE_DURATION.get();
        accursedRageMaximum = (Integer)ACCURSED_RAGE_MAXIMUM.get();
        lifestealMultiplier = (Double)LIFESTEAL_MULTIPLIER.get();
        blazingBrandDuration = (Integer)BLAZING_BRAND_DURATION.get();
        blazingBrandMaximum = (Integer)BLAZING_BRAND_MAXIMUM.get();
        blazingBrandArmorReduction = (Double)BLAZING_BRAND_ARMOR_REDUCTION.get();
        blazingBrandArmorToughnessReduction = (Double)BLAZING_BRAND_ARMOR_TOUGHNESS_REDUCTION.get();
        mechaPulseChargeChance = (Double)MECHA_PULSE_CHARGE_CHANCE.get();
        mechaPulseStunThreshold = (Integer)MECHA_PULSE_STUN_THRESHOLD.get();
        mechaPulseCooldown = (Integer)MECHA_PULSE_COOLDOWN.get();
        mechaPulseStunDuration = (Integer)MECHA_PULSE_STUN_DURATION.get();
        mechaPulseEffectDuration = (Integer)MECHA_PULSE_EFFECT_DURATION.get();
        mechaPulseExtraDamage = (Double)MECHA_PULSE_EXTRA_DAMAGE.get();
        mechaSmiteChance = (Double)MECHA_SMITE_CHANCE.get();
        mechaSmiteRegenChance = (Double)MECHA_SMITE_REGEN_CHANCE.get();
        mechaSmiteFireDuration = (Integer)MECHA_SMITE_FIRE_DURATION.get();
        mechaSmiteWitherDuration = (Integer)MECHA_SMITE_WITHER_DURATION.get();
        mechaSmiteWitherAmplifier = (Integer)MECHA_SMITE_WITHER_AMP.get();
        mechaSmiteRegenThresholdType = (Boolean)MECHA_SMITE_REGEN_THRESHOLD_TYPE.get();
        mechaSmiteRegenThresholdPercent = (Double)MECHA_SMITE_REGEN_THRESHOLD_PERCENT.get();
        mechaSmiteRegenThreshold = (Integer)MECHA_SMITE_REGEN_THRESHOLD.get();
        mechaSmiteRegenDuration = (Integer)MECHA_SMITE_REGEN_DURATION.get();
        mechaSmiteRegenAmplifier = (Integer)MECHA_SMITE_REGEN_AMP.get();
        customSounds = (Boolean)CUSTOM_SOUNDS.get();
        pitchVariation = (Double)PITCH_VARIATION.get();
    }

    private static void updateMaterialValues(SpartanMaterial material, ForgeConfigSpec.DoubleValue damage, ForgeConfigSpec.DoubleValue speed) {
        material.setAttackDamageModifier(((Double)damage.get()).floatValue());
        material.setAttackSpeedModifier((double)((Double)speed.get()).floatValue());
    }

    public static float getRandomPitch() {
        return (float)(Math.random() * pitchVariation * 2.0 - pitchVariation + 1.0);
    }

    static {
        ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
        BUILDER.comment(" SPARTAN CATACLYSM CONFIG\n");
        BUILDER.push("Material Modifiers");
        ANCIENT_METAL_DAMAGE = BUILDER.comment(" Attack Damage Modifier for Ancient Metal weapons.  Requires restart.").defineInRange("ancientMetalDamageModifier", 0.0, -10000.0, 10000.0);
        ANCIENT_METAL_SPEED = BUILDER.comment(" Attack Speed Modifier for Ancient Metal weapons.  Requires restart.").defineInRange("ancientMetalSpeedModifier", 0.0, -10000.0, 10000.0);
        BLACK_STEEL_DAMAGE = BUILDER.comment(" Attack Damage Modifier for Black Steel weapons.  Requires restart.").defineInRange("blackSteelDamageModifier", 0.0, -10000.0, 10000.0);
        BLACK_STEEL_SPEED = BUILDER.comment(" Attack Speed Modifier for Black Steel weapons.  Requires restart.").defineInRange("blackSteelSpeedModifier", 0.0, -10000.0, 10000.0);
        CURSIUM_DAMAGE = BUILDER.comment(" Attack Damage Modifier for Cursium weapons.  Requires restart.").defineInRange("cursiumDamageModifier", 0.0, -10000.0, 10000.0);
        CURSIUM_SPEED = BUILDER.comment(" Attack Speed Modifier for Cursium weapons.  Requires restart.").defineInRange("cursiumSpeedModifier", 0.0, -10000.0, 10000.0);
        IGNITIUM_DAMAGE = BUILDER.comment(" Attack Damage Modifier for Ignitium weapons.  Requires restart.").defineInRange("ignitiumDamageModifier", 0.0, -10000.0, 10000.0);
        IGNITIUM_SPEED = BUILDER.comment(" Attack Speed Modifier for Ignitium weapons.  Requires restart.").defineInRange("ignitiumSpeedModifier", 0.0, -10000.0, 10000.0);
        WITHERITE_DAMAGE = BUILDER.comment(" Attack Damage Modifier for Witherite weapons.  Requires restart.").defineInRange("witheriteDamageModifier", 0.0, -10000.0, 10000.0);
        WITHERITE_SPEED = BUILDER.comment(" Attack Speed Modifier for Witherite weapons.  Requires restart.").defineInRange("witheriteSpeedModifier", 0.0, -10000.0, 10000.0);
        BUILDER.pop();
        BUILDER.push("Accursed Rage Options");
        ACCURSED_RAGE_CHANCE = BUILDER.comment(" Chance on hit for Cursium weapons to stack the Accursed Rage effect on the user.  Set to 0 to disable.").defineInRange("accursedRageChance", 0.66, 0.0, 1.0);
        ACCURSED_RAGE_EXTRA_DAMAGE = BUILDER.comment(" Additional damage attackers do with Cursium weapons per level of Accursed Rage.").defineInRange("accursedRageExtraDamage", 1.0, 0.0, Double.MAX_VALUE);
        ACCURSED_RAGE_DURATION = BUILDER.comment(" Duration (ticks) of the Accursed Rage effect granted by Cursium weapons.").defineInRange("accursedRageDuration", 110, 0, Integer.MAX_VALUE);
        ACCURSED_RAGE_MAXIMUM = BUILDER.comment(" Maximum amplifier the Accursed Rage effect can reach using Cursium weapons.").defineInRange("accursedRageMaxAmplifier", 4, 0, Integer.MAX_VALUE);
        BUILDER.pop();
        BUILDER.push("Blazing Brand Options");
        BLAZING_BRAND_CHANCE = BUILDER.comment(" Chance on hit for Ignitium weapons to stack the Blazing Brand effect onto attacked entities.  Set to 0 to disable.").defineInRange("blazingBrandChance", 0.75, 0.0, 1.0);
        BLAZING_BRAND_LIFESTEAL_CHANCE = BUILDER.comment(" Chance on hit for Ignitium weapons to grant lifesteal to the user.  Blazing Brand trait must have hit successfully - for example, if blazingBrandChance is 0 then lifesteal will never be given.  Set to 0 to disable.").defineInRange("blazingBrandLifestealChance", 1.0, 0.0, 1.0);
        LIFESTEAL_MULTIPLIER = BUILDER.comment(" Lifesteal multiplier for Ignitium weapons.  Lifesteal amount depends on attack speed, so rate should correlates with DPS.  Set to 0 to disable lifesteal.").defineInRange("lifestealMultiplier", 1.25, 0.0, Double.MAX_VALUE);
        BLAZING_BRAND_DURATION = BUILDER.comment(" Duration (ticks) of the Blazing Brand effect inflicted by Ignitium weapons.  Default is identical to Ignis' abilities.").defineInRange("blazingBrandDuration", 240, 0, Integer.MAX_VALUE);
        BLAZING_BRAND_MAXIMUM = BUILDER.comment(" Maximum amplifier the Blazing Brand effect can reach using Ignitium weapons.  Default is identical to Ignis' abilities.").defineInRange("blazingBrandMaxAmplifier", 4, 0, Integer.MAX_VALUE);
        BLAZING_BRAND_ARMOR_REDUCTION = BUILDER.comment(" Multiplier (per amplifier) that entities afflicted with Brazing Brand will have its Armor attribute reduced by.  Default is identical to Ignis' abilities.  Requires restart.").defineInRange("blazingBrandArmorMultiplier", 0.2, 0.0, 1.0);
        BLAZING_BRAND_ARMOR_TOUGHNESS_REDUCTION = BUILDER.comment(" Multiplier (per amplifier) that entities afflicted with Brazing Brand will have its Armor Toughness attribute reduced by.  Default is identical to Ignis' abilities.  Requires restart.").defineInRange("blazingBrandArmorToughnessMultiplier", 0.2, 0.0, 1.0);
        BUILDER.pop();
        BUILDER.push("Mecha Pulse Options");
        MECHA_PULSE_CHARGE_CHANCE = BUILDER.comment(" Chance on hit for Witherite weapons to stack the Pulse Charge effect on the user.  Set to 0 to disable.").defineInRange("mechaPulseChargeChance", 0.75, 0.0, 1.0);
        MECHA_PULSE_EFFECT_DURATION = BUILDER.comment(" Duration (ticks) of the Pulse Charge effect granted by Witherite weapons.").defineInRange("mechaPulseEffectDuration", 140, 0, Integer.MAX_VALUE);
        MECHA_PULSE_STUN_THRESHOLD = BUILDER.comment(" Amplifier of the Pulse Charge effect at which a shockwave is released, stunning the target.").defineInRange("mechaPulseStunThreshold", 9, 0, Integer.MAX_VALUE);
        MECHA_PULSE_COOLDOWN = BUILDER.comment(" Duration (ticks) of the Pulse Cooldown effect inflicted upon Witherite weapons releasing a shockwave.  Pulse Charge cannot accumulate while this effect is active.").defineInRange("mechaPulseCooldown", 800, 0, Integer.MAX_VALUE);
        MECHA_PULSE_STUN_DURATION = BUILDER.comment(" Stun duration (ticks) inflicted by Witherite weapons when a shockwave is released.").defineInRange("mechaPulseStunDuration", 200, 0, Integer.MAX_VALUE);
        MECHA_PULSE_EXTRA_DAMAGE = BUILDER.comment(" Additional damage a shockwave does when released.").defineInRange("mechaPulseStunDamage", 4.0, 0.0, Double.MAX_VALUE);
        BUILDER.pop();
        BUILDER.push("Mecha Smite Options");
        MECHA_SMITE_CHANCE = BUILDER.comment(" Chance on hit for Witherite weapons to set the target on fire and apply Wither.  Set to 0 to disable.").defineInRange("mechaSmiteHarmfulEffectsChance", 1.0, 0.0, 1.0);
        MECHA_SMITE_FIRE_DURATION = BUILDER.comment(" Duration (seconds) of the Fire applied by Witherite weapons.  Set to 0 to disable.").defineInRange("mechaSmiteFireDuration", 5, 0, Integer.MAX_VALUE);
        MECHA_SMITE_WITHER_DURATION = BUILDER.comment(" Duration (ticks) of the Wither effect applied to the target by Witherite weapons.  Set to 0 to disable.").defineInRange("mechaSmiteWitherDuration", 100, 0, Integer.MAX_VALUE);
        MECHA_SMITE_WITHER_AMP = BUILDER.comment(" Amplifier of the Wither effect applied to the target by Witherite weapons.").defineInRange("mechaSmiteWitherAmplifier", 1, 0, Integer.MAX_VALUE);
        MECHA_SMITE_REGEN_CHANCE = BUILDER.comment(" Chance on hit for Witherite weapons apply regeneration to the user when under health threshold.  Set to 0 to disable.").defineInRange("mechaSmiteRegenChance", 0.5, 0.0, Double.MAX_VALUE);
        MECHA_SMITE_REGEN_THRESHOLD_TYPE = BUILDER.comment(" Whether Witherite weapons should apply Regeneration to the user at a certain health percentage (true), or at a defined health amount (false).").define("mechaSmiteRegenUsesPercentage", true);
        MECHA_SMITE_REGEN_THRESHOLD_PERCENT = BUILDER.comment(" If mechaSmiteRegenUsesPercentage is true, Witherite weapons will apply Regeneration to the user when under this percentage of health.  Set to 0 to disable.").defineInRange("mechaSmiteRegenPercentage", 0.5, 0.0, Double.MAX_VALUE);
        MECHA_SMITE_REGEN_THRESHOLD = BUILDER.comment(" If mechaSmiteRegenUsesPercentage is false, Witherite weapons will apply Regeneration to the user when under this amount of health.  Set to 0 to disable.").defineInRange("mechaSmiteRegenThreshold", 10, 0, Integer.MAX_VALUE);
        MECHA_SMITE_REGEN_DURATION = BUILDER.comment(" Duration (ticks) of the Regeneration effect applied to the user by Witherite weapons.").defineInRange("mechaSmiteRegenDuration", 100, 0, Integer.MAX_VALUE);
        MECHA_SMITE_REGEN_AMP = BUILDER.comment(" Amplifier of the Regeneration effect applied to the user by Witherite weapons.").defineInRange("mechaSmiteRegenAmplifier", 1, 0, Integer.MAX_VALUE);
        BUILDER.pop();
        BUILDER.push("Miscellaneous Options");
        CUSTOM_SOUNDS = BUILDER.comment(" Enable/Disable Ignitium, Cursium, and Witherite weapons making custom sounds when attacking.").define("customWeaponSounds", true);
        PITCH_VARIATION = BUILDER.comment(" Pitch variation from 1.0 for custom weapon attack sounds.  For example: Set to 0.1, pitch will be random between 0.9 and 1.1.  Set to 0.0 for no variation.").defineInRange("customWeaponSoundsPitchVariation", 0.1, 0.0, 1.0);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

